package abl.compiler;


// Ideas:
// Have each method return a pair of values: the new node & a boolean. If the
// boolean is true, ASTWalker should continue processing the node's children
// separately; otherwise it shouldn't.

public interface ASTVisitor {
    Node visit(ASTBehaviorUnit a) throws CompileException;
    Node visit(ASTAblExpression a) throws CompileException;
    Node visit(ASTAblVariableDecl a) throws CompileException;
    Node visit(ASTActionRegistration a) throws CompileException;
    Node visit(ASTAnonymousStep a) throws CompileException;
    Node visit(ASTBehaviorDefinition a) throws CompileException;
    Node visit(ASTConditionalExpression a) throws CompileException;
    Node visit(ASTConstantDeclaration a) throws CompileException;
    Node visit(ASTFailStep a) throws CompileException;
    Node visit(ASTGoalStep a) throws CompileException;
    Node visit(ASTImportDeclaration a) throws CompileException;
    Node visit(ASTJavaName a) throws CompileException;
    Node visit(ASTJavaStatement a) throws CompileException;
    Node visit(ASTJavaType a) throws CompileException;
    Node visit(ASTMentalStep a) throws CompileException;
    Node visit(ASTModifyStep a) throws CompileException;
    Node visit(ASTPrimitiveStep a) throws CompileException;
    Node visit(ASTPropertyDeclaration a) throws CompileException;
    Node visit(ASTSucceedStep a) throws CompileException;
    Node visit(ASTTestExpression a) throws CompileException;
    Node visit(ASTVariableDeclaratorID a) throws CompileException;
    Node visit(ASTVariableInitializer a) throws CompileException;
    Node visit(ASTWaitStep a) throws CompileException;
    Node visit(ASTWMEDecl a) throws CompileException;
    Node visit(ASTWMEFieldTest a) throws CompileException;
    Node visit(ASTWMERegistration a) throws CompileException;
    Node visit(ASTWMETest a) throws CompileException;
}
