package abl.compiler;

public class ASTVariableInitializer extends AblParseNode {
    public ASTVariableInitializer(int id) {
	super(id);
    }
    
    public ASTVariableInitializer(AblParser p, int id) {
	super(p, id);
    }
    
    public void processVariableReferences(AblScopeMaintainer scope) throws ScopeException
    {
	AblParseNode n;
	for(int i = 0; i < jjtGetNumChildren(); i++) {
	    // Loop through child nodes looking for JavaNames, JavaStatements, or ConditionalExpressions

	    n = (AblParseNode)jjtGetChild(i);
	    if (n.id == JJTJAVANAME) {
		// Might be a variable reference.
		ASTJavaName jName = (ASTJavaName)n;
		jName.setJavaNameImage(jName.getVariableReference(scope));
	    }
	    else if (n.id == JJTJAVASTATEMENT) {
		((ASTJavaStatement)n).processVariableRefHelper(scope); 
	    }
	    else if (n.id == JJTCONDITIONALEXPRESSION) {
		((ASTConditionalExpression)n).processVariableReferences(scope);
	    }
	}
    }
}
