/* Generated By:JJTree: Do not edit this line. ASTReinforcementState.java */

package abl.compiler;

import jd.*;
import java.util.*;

public class ASTReinforcementState extends AblScopeMaintainer
{
	private List tupleList = new LinkedList();

	public ASTReinforcementState(int id)
	{
		super(id);
	}
	
	public ASTReinforcementState(AblParser p, int id) 
	{
		super(p, id);
	}
	
    AblScopeMaintainer getEnclosingBehaviorScope()
	{ 
		return this;
		//return ((ASTBehaviorDefinition)jjtGetParent()).getEnclosingBehaviorScope();
    }

	void addTupleEntry(ASTAblExpression tupleEntry)
	{
		tupleList.add(tupleEntry);
	}

	CodeStringDescriptor compileStateTupleAndClass() throws CompileException
	{
		final CodeBlockDescriptor codeBlock;
		final ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();
		final ASTBehaviorDefinition beh = (ASTBehaviorDefinition) jjtGetParent();
		final int behaviorID = beh.getID();
		final String stateClassName = behUnit.getBehavingEntityClass() + "_State" + behaviorID;

		String tupleArgs = "";
		String ctorArgs = "";
		List varTypes = new LinkedList();
		codeBlock = new CodeBlockDescriptor("public class " + stateClassName + " implements State {", "}");

		int i = 0;
		ListIterator tupleIter;
		tupleIter = tupleList.listIterator();
		while(tupleIter.hasNext()) {
			ASTAblExpression exp = (ASTAblExpression)tupleIter.next();
			String varType = exp.getType(this);
			String varName = exp.getFullNameOrLiteral();
System.out.println(varType + " " + varName);
			if (!tupleArgs.equals(""))
			{
				tupleArgs += ", ";
				ctorArgs += ", ";
			}
			tupleArgs += varName;
			ctorArgs += varType + " arg" + i;

			String varTypeClass = varType;
			if (varTypeClass.equals("int"))
				varTypeClass = "Integer";
			else if (varTypeClass.equals("float"))
				varTypeClass = "Float";
			else if (varTypeClass.equals("double"))
				varTypeClass = "Double";
			else if (varTypeClass.equals("char"))
				varTypeClass = "Char";
			else if (varTypeClass.equals("boolean"))
				varTypeClass = "Boolean";
			varTypes.add(varTypeClass);
			codeBlock.addToBlockBody(new CodeStringDescriptor("private "+varTypeClass+" value" + i + ";"));

			i += 1;
		}
		final int varNum = i;

		i = 0;
		codeBlock.addToBlockBody(new CodeStringDescriptor("public "+stateClassName+"(" + ctorArgs + ") {"));
		tupleIter = varTypes.listIterator();
		while(tupleIter.hasNext()) {
			String varTypeClass = (String)tupleIter.next();
			codeBlock.addToBlockBody(new CodeStringDescriptor(" value" + i + " = new " + varTypeClass + "(arg" + i + ");"));
			i += 1;
		}
		codeBlock.addToBlockBody(new CodeStringDescriptor("}"));

		// TODO find better way of combining hashes (?)
		String hashCodes = "";
		codeBlock.addToBlockBody(new CodeStringDescriptor("public int hashCode() {"));
		for (i = 0; i < varNum; ++i)
		{
			if (i > 0)
				hashCodes += " + ";
			hashCodes += "value" + i + ".hashCode()";
		}
		codeBlock.addToBlockBody(new CodeStringDescriptor(" return " + hashCodes + ";"));
		codeBlock.addToBlockBody(new CodeStringDescriptor("}"));

		codeBlock.addToBlockBody(new CodeStringDescriptor("public boolean equals(Object o) {"));
		codeBlock.addToBlockBody(new CodeStringDescriptor(" return (o instanceof "+stateClassName+") ?"));
		for (i = 0; i < varNum; ++i)
		{
			String equals = "  ";
			if (i > 0)
				equals += "&& ";
			equals += "value" + i + ".equals((("+stateClassName+")o)." + "value" + i + ")";
			codeBlock.addToBlockBody(new CodeStringDescriptor(equals));
		}
		codeBlock.addToBlockBody(new CodeStringDescriptor(" :false;"));
		codeBlock.addToBlockBody(new CodeStringDescriptor("}"));

		behUnit.writeRawClass(codeBlock, stateClassName);

		return new CodeStringDescriptor("return new "+stateClassName+"("+tupleArgs+");");
	}

	private CodeBlockDescriptor compileSensorActivationFactory(int testType) {
		AblParseNode n;
		ASTTestExpression test = null;
		
		for (int i = 0; i < jjtGetNumChildren(); i++) {
			// Loop through children nodes looking for a test of type testType
			n = (AblParseNode) jjtGetChild(i);
			if ((n.id == JJTTESTEXPRESSION)
				&& ((ASTTestExpression) n).getTestType() == testType)
				// Found the test type we're looking for
				test = (ASTTestExpression) n;
		}
		if (test != null) {
			// A test of type testType has been defined on this behavior
			CodeBlockDescriptor sensorArray =
				test.compileSensorActivationFactory();
			if (sensorArray != null) {
				int behaviorID = ((ASTBehaviorDefinition) jjtGetParent()).getID();
				CodeBlockDescriptor factorySwitchCase =
					new CodeBlockDescriptor("case " + behaviorID + ": {", "}");
				factorySwitchCase.addToBlockBody(sensorArray);
				return factorySwitchCase;
			}
		}
		return null;
	}
	
	void compileToJava() throws CompileException
	{	
		final ASTBehaviorDefinition beh = (ASTBehaviorDefinition) jjtGetParent();

		setScopeName( beh.getUniqueName() + "_State");
		setScopeType(AblScopeMaintainer.METHOD_SCOPE);
		setScopeParent(beh);
		initializeScope();

//		addChildVariableDeclarationsWithReferenceRewrite();

		// compile the case header
		CodeBlockDescriptor block;
		final ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();
		final int behaviorID = beh.getID();
		block = new CodeBlockDescriptor("case " + behaviorID + ": {", "");
		block.addToBlockBody(new CodeStringDescriptor("// " + beh.getUniqueName()));

		behUnit.writeStateWME(block, beh);

		// compile the test expressions
		AblParseNode n;
		for (int i = 0; i < jjtGetNumChildren(); i++)
		{
			// Loop through children nodes looking for steps.
			n = (AblParseNode) jjtGetChild(i);
			if (n.id == JJTTESTEXPRESSION)
			{
				// instant output
				((ASTTestExpression) n).compileToJava();
			}
		}
		// set up the test expression result handler
		String stateTestName = "stateTest"+behaviorID;
		block = new CodeBlockDescriptor("", "}");
		block.addToBlockBody(new CodeStringDescriptor(stateTestName+" theTest = new "+stateTestName+"();"));
		block.addToBlockBody(new CodeStringDescriptor("if (theTest.doTest()){"));

		// make a set of local variables to correspond with the test-class ones
		List variableFields = getDeclaredVariables();
		ListIterator fieldIter;
		fieldIter = variableFields.listIterator();
		while(fieldIter.hasNext()) {
			FieldDescriptor field = (FieldDescriptor)fieldIter.next();
//System.out.println(field.toString());
			String fieldName = field.getFieldNames()[0];
			block.addToBlockBody(new CodeStringDescriptor(field.fieldType+" "+fieldName+" = theTest."+fieldName+";"));
		}
		// compile the java code inside the state block
		for (int i = 0; i < jjtGetNumChildren(); i++)
		{
			n = (AblParseNode) jjtGetChild(i);
            if (n.id == JJTABLVARIABLEDECL) {
                // If the child node is a variable declaration, process it
                
                FieldDescriptor fields[]; 
                fields = ((ASTAblVariableDecl)n).getFieldDescriptors(this);
				for(int x = 0; x < fields.length; x++) {
					this.addVariableDeclaration(fields[x]);
					// Add the declared variables to the execute() method.
					block.addToBlockBody(fields[x]);
				}
            }
			if (n.id == JJTJAVASTATEMENT)
			{
                block.addToBlockBody(new CodeStringDescriptor(((ASTJavaStatement)n).processVariableReferences(this)));
			}
		}
		// close out the state block and add the tuple return
		CodeStringDescriptor stateTuple = compileStateTupleAndClass();
		if (stateTuple != null)
			block.addToBlockBody(stateTuple);
		block.addToBlockBody(new CodeStringDescriptor("}"));
		block.addToBlockBody(new CodeStringDescriptor("throw new AblRuntimeError(\"State WME Test failed for behaviorID \" + __$behaviorID);"));
		behUnit.writeStateWME(block, beh);
		
		block = compileSensorActivationFactory(ASTTestExpression.STATE_CONDITION);
		if (block != null)
			behUnit.writeStateWMESensorActivation(block, beh);
	}
}
