/* Generated By:JJTree: Do not edit this line. ASTReinforcementSignals.java */

package abl.compiler;

import jd.*;
import java.util.*;

public class ASTReinforcementSignals extends AblParseNode
{
	public ASTReinforcementSignals(int id)
	{
		super(id);
	}
	
	public ASTReinforcementSignals(AblParser p, int id)
	{
		super(p, id);
	}
	
    AblScopeMaintainer getEnclosingBehaviorScope() { 
		return ((ASTBehaviorDefinition)jjtGetParent()).getEnclosingBehaviorScope();
    }
	
	private CodeBlockDescriptor compileSensorActivationFactory(int testType) {
		AblParseNode n;
		ASTTestExpression test = null;
		List testList = new LinkedList();
		
		for (int i = 0; i < jjtGetNumChildren(); i++) {
			// Loop through children nodes looking for a test of type testType
			n = (AblParseNode) jjtGetChild(i);
			if ((n.id == JJTTESTEXPRESSION)
				&& ((ASTTestExpression) n).getTestType() == testType)
				// Found the test type we're looking for
				testList.add(n);
		}
		int x = 0;
		if (testList.size() > 0) {
			int behaviorID = ((ASTBehaviorDefinition) jjtGetParent()).getID();
			CodeBlockDescriptor factorySwitchCase =
				new CodeBlockDescriptor("case " + behaviorID + ": {", "}");
			ListIterator testIter;
			testIter = testList.listIterator();
			while (testIter.hasNext()) {
				// A test of type testType has been defined on this behavior
				test = (ASTTestExpression)testIter.next();
				CodeBlockDescriptor sensorArray =
					test.compileSensorActivationFactory();
				if (sensorArray != null) {
					factorySwitchCase.addToBlockBody(new CodeStringDescriptor("class Activation" + x + " {"));
					factorySwitchCase.addToBlockBody(new CodeStringDescriptor("SensorActivation[] doActivation() {"));
					factorySwitchCase.addToBlockBody(sensorArray);
					factorySwitchCase.addToBlockBody(new CodeStringDescriptor("}"));
					factorySwitchCase.addToBlockBody(new CodeStringDescriptor("}"));
					x += 1;
				}
			}
			final int numActivations = x;
			for (x = 0; x < numActivations; ++x) {
				factorySwitchCase.addToBlockBody(new CodeStringDescriptor("SensorActivation[] __$activation"+x+" = (new Activation"+x+"()).doActivation();"));
			}
			factorySwitchCase.addToBlockBody(new CodeStringDescriptor("SensorActivation[] __$allActivations = new SensorActivation["));
			for (x = 0; x < numActivations; ++x) {
				String addBlock;
				if (x > 0)
					addBlock = " + ";
				else
					addBlock = "   ";
				addBlock += "__$activation"+x+".length";
				factorySwitchCase.addToBlockBody(new CodeStringDescriptor(addBlock));
			}
			factorySwitchCase.addToBlockBody(new CodeStringDescriptor("];"));
			factorySwitchCase.addToBlockBody(new CodeStringDescriptor("int index = 0;"));
			for (x = 0; x < numActivations; ++x) {
				factorySwitchCase.addToBlockBody(new CodeStringDescriptor("for(int k = 0; k < __$activation"+x+".length; ++k) {"));
				factorySwitchCase.addToBlockBody(new CodeStringDescriptor(" __$allActivations[index] = __$activation"+x+"[k];"));
				factorySwitchCase.addToBlockBody(new CodeStringDescriptor(" index += 1;"));
				factorySwitchCase.addToBlockBody(new CodeStringDescriptor("}"));
			}
			factorySwitchCase.addToBlockBody(new CodeStringDescriptor("return __$allActivations;"));
			return factorySwitchCase;
		}
		return null;
	}

	void compileToJava() throws CompileException
	{	
		CodeBlockDescriptor block;
		final ASTBehaviorDefinition beh = (ASTBehaviorDefinition) jjtGetParent();
		final int behaviorID = beh.getID();
		block = new CodeBlockDescriptor("case " + behaviorID + ": {", "");
		block.addToBlockBody(new CodeStringDescriptor("// " + beh.getUniqueName()));

		final ASTBehaviorUnit behUnit = ASTBehaviorUnit.getBehaviorUnit();
		behUnit.writeReinforcementTest(block, (ASTBehaviorDefinition) jjtGetParent());

		CodeBlockDescriptor mainBlock;
		mainBlock = new CodeBlockDescriptor("// run actual test", "}");

		AblParseNode n;
		for (int i = 0; i < jjtGetNumChildren(); i++) {
			// Loop through children nodes looking for steps.
			n = (AblParseNode) jjtGetChild(i);
			if (n.id == JJTTESTEXPRESSION)
			{
				ASTTestExpression test = (ASTTestExpression)n;
				block = new CodeBlockDescriptor("class test" + i + "{", "boolean doTest()");
				behUnit.writeReinforcementTest(block, (ASTBehaviorDefinition) jjtGetParent());

				test.compileToJava();

				block = new CodeBlockDescriptor("}", "");
				behUnit.writeReinforcementTest(block, (ASTBehaviorDefinition) jjtGetParent());

				mainBlock.addToBlockBody(new CodeStringDescriptor("test" + i + " instance" + i + " = new test" + i + "();"));
				mainBlock.addToBlockBody(new CodeStringDescriptor("if (instance" + i + ".doTest())"));
				mainBlock.addToBlockBody(new CodeStringDescriptor("   return " + test.getSignalValue().dumpTokens() + ";"));
			}
		}

		mainBlock.addToBlockBody(new CodeStringDescriptor("return 0.0;"));
		behUnit.writeReinforcementTest(mainBlock, (ASTBehaviorDefinition) jjtGetParent());

		block = compileSensorActivationFactory(ASTTestExpression.REINFORCEMENT_TEST);
		if (block != null)
			behUnit.writeReinforcementTestSensorActivation(block, beh);
	}
}
