/* Generated By:JJTree: Do not edit this line. ASTModifyStep.java */

package abl.compiler;

import jd.*;
import abl.runtime.Step;

// note: most of this code is adapted from ASTGoalStep
//       a future modification could lift the parallel-behavior runtime modification out of GoalStep
public class ASTModifyStep extends ArgumentStep implements AblDebuggerConstants
{
	public int fromIndex = -1;
	public int toIndex = -1;
	public boolean toAfter = false;
	public ASTJavaName inBehavior = null;
	private int childStepID = -4;
	private String childStepFactory = null;

    // Enum constants for goal execution type
    public static final short MOVESTEP = 0;
    public static final short DELETESTEP = 1;
    public static final short ADDSTEP = 2;

    public short modifyType = MOVESTEP;
	
	private static final ASTBehaviorDefinition blankBeh = new ASTBehaviorDefinition(JJTBEHAVIORDEFINITION);

	public ASTModifyStep(int id)
	{
		super(id);
//System.out.println("ASTModifyStep(int id)");
	}

	public ASTModifyStep(AblParser p, int id)
	{
		super(p, id);
//System.out.println("ASTModifyStep(AblParser p, int id)");
	}

	// this is an adaptation of the equivalent method for ASTGoalStep
	// and it binds the target behavior as an argument, since it will be dynamic at runtime
    private CodeBlockDescriptor compileModifyStepExecute() throws CompileException
    {
        // create block, it will get thrown away if not used
        final CodeBlockDescriptor block = new CodeBlockDescriptor("case " + stepID + ": {", "}");
        block.addToBlockBody(new CodeStringDescriptor("// " + getUniqueName()));
		
		int argCount = 1;
		block.addToBlockBody(new CodeStringDescriptor("final Object[] args = new Object[" + argCount + "];"));

		AblScopeMaintainer scope = (ASTBehaviorDefinition)jjtGetParent();
		String targetTypeName = inBehavior.lookupVariableType(scope);
		if (inBehavior.isVariableReference(scope)) {
			if (targetTypeName.equals("SequentialBehaviorWME")) 
			{
				// check if the type of rerootParent is MultiStepBehaviorWME
				block.addToBlockBody(new CodeStringDescriptor("args[0] = " + 
										          inBehavior.getVariableReference(scope) + ";"));
			}
			else
				// Illegal type
				throw new CompileException(getFirstLineNumber(), "Attempt to modify step in " + inBehavior.dumpTokens() + " with type " 
				+ targetTypeName + 
				". Modify target must be a SequentialBehaviorWME (or subtype).");
		}
		else
			// Not a variable reference
			throw new CompileException(getFirstLineNumber(), "Modify step target " + inBehavior.dumpTokens() + " is not a declared variable");
		
        block.addToBlockBody(new CodeStringDescriptor("return args;"));
        return block;
    }

	// this compiles the ModifyStep instantiation code for the step factory
	// the instantiated ModifyStep does the work at runtime of modifying the target behavior's steps
    private CodeBlockDescriptor compileStepFactory() throws CompileException
    {
        CodeBlockDescriptor stepFactory = new CodeBlockDescriptor("case " + stepID + ": {", "}");
        
        stepFactory.addToBlockBody(new CodeStringDescriptor("// " + getUniqueName()));
        
        final CodeSequenceDescriptor propertyTableInit = compilePropertyTable();
        if (propertyTableInit != null)
            stepFactory.addToBlockBody(propertyTableInit);
        
        if (Abl.debugLevel == GUI_DEBUGGER)
            // construct debug versions of steps
            stepFactory.addToBlockBody(new CodeStringDescriptor("return new ModifyStepDebug(" + 
            standardConstructorArguments()
			+ ", (short)" + modifyType	// what kind of modification to perform
			+ ", " + childStepID		// which step to insert (if being added)
			+ ", " + fromIndex			// where the step will come from (if being moved or deleted)
			+ ", " + toIndex			// where the step will go (if being moved or added)
			+ ", " + childStepFactory	// step factory method from which to acquire the step
			+ ");"));
        else
            stepFactory.addToBlockBody(new CodeStringDescriptor("return new ModifyStep(" + 
            standardConstructorArguments()
			+ ", (short)" + modifyType	// what kind of modification to perform
			+ ", " + childStepID		// which step to insert (if being added)
			+ ", " + fromIndex			// where the step will come from (if being moved or deleted)
			+ ", " + toIndex			// where the step will go (if being moved or added)
			+ ", " + childStepFactory	// step factory method from which to acquire the step
			+ ");"));
        
        return stepFactory;
    }

    void compileToJava() throws CompileException 
    {
        final ASTBehaviorUnit behaviorUnitNode = ASTBehaviorUnit.getBehaviorUnit();
        final ASTBehaviorDefinition behaviorParent = (ASTBehaviorDefinition)jjtGetParent();

		initStep(Step.MODIFY);
		
		blankBeh.behaviorName = getUniqueName() + "_Sub";

		// compile the inner step if there is one (only ADDSTEP has one)
		switch (this.modifyType)
		{
			// this switch is mostly for debug purposes
			// the only case that really does something is ADDSTEP
		default:
			throw new CompileException(this.getFirstLineNumber(), "Invalid modifyType for ASTModifyStep");
		case MOVESTEP:
			System.out.print("ASTModifyStep.MOVESTEP ");
			System.out.print(((ASTJavaName)jjtGetChild(0)).getName());	// "from"
			System.out.print(" " + fromIndex + " ");
			System.out.print(((ASTJavaName)jjtGetChild(1)).getName());	// "before/after"
			System.out.print(" " + toIndex + " ");
			System.out.print(((ASTJavaName)jjtGetChild(2)).getName());	// "in"
			System.out.print(" " + inBehavior.getName() + "\n");
			break;
		case DELETESTEP:
			System.out.print("ASTModifyStep.DELETESTEP ");
			System.out.print(((ASTJavaName)jjtGetChild(0)).getName());	// "from"
			System.out.print(" " + fromIndex + " ");
			System.out.print(((ASTJavaName)jjtGetChild(1)).getName());	// "in"
			System.out.print(" " + inBehavior.getName() + "\n");
			break;
		case ADDSTEP:
			System.out.print("ASTModifyStep.ADDSTEP ");
			System.out.print(((ASTJavaName)jjtGetChild(0)).getName());	// "before/after"
			System.out.print(" " + fromIndex + " ");
			System.out.print(((ASTJavaName)jjtGetChild(1)).getName());	// "in"
			System.out.print(" " + inBehavior.getName() + " ");			// behaviorWME
			GenericStep realStep = (GenericStep)jjtGetChild(3);
			System.out.print(realStep.dumpTokens());					// step code
			// now we compile the child step in the context of a "blank behavior"
			realStep.jjtSetParent(blankBeh);
			realStep.compileToJava();
			// after the step has been compiled,
			// we can record where it was placed so it can be referenced
			// and can thus be inserted into a behavior at runtime by the ModifyStep instance
			childStepID = realStep.stepID;
			childStepFactory = realStep.getStepFactoryMethod_rField();
			if (childStepFactory == null)
				childStepFactory = "__$stepFactory0_rfield";
			childStepFactory = getBehavingEntityField(childStepFactory);
			System.out.print(" (" + childStepID + ", " + childStepFactory + ")");
			System.out.print("\n");
			break;
		}

		CodeBlockDescriptor modifyExecute = compileModifyStepExecute();
		// Only write the execute case if the goal step has arguments. 
		if (modifyExecute != null)
			behaviorUnitNode.writeArgumentStepExecute(modifyExecute, this);
		
		if (hasSuccessTest) {
			compileSuccessTest();
		}
		
		// fixme: when step sharing is implemented, writeStepFactory won't even be implemented. Will need to call
		// some new method on ASTBehaviorDefinition to get the name of the factory reflection field. 
		
		// Compile the step factory at the end since the factory references the class and method names of the 
		// other step parts (e.g. success test, sensor factories, execute).
		behaviorUnitNode.writeStepFactory(compileStepFactory(), this);
		
		// Add the step id and factory method to the parent's list of steps.
		behaviorParent.addStep(stepID, getStepFactoryMethod_rField());
	}
}
