/* Parse node for the java statements which appear in mental acts. The
   main use for ASTJavaStatement is to map variable references
   appearing in statements into the appropriate scope. */

package abl.compiler;

public class ASTJavaStatement extends AblParseNode {
    ASTJavaStatement(int id) {
	super(id);
    }
    
    ASTJavaStatement(AblParser p, int id) {
	super(p, id);
    }

    /* Returns a String representation of the Java statement with variable references converted into appropriate scope
       references. */
    String processVariableReferences(AblScopeMaintainer scope) {
	processVariableRefHelper(scope);
	return prettyPrintTokens();
    }

    /* Recursive helper function called by
       processVariableReferences(). Changes any JavaNames() in the
       tree to reflect the appropriate scope reference. */
    void processVariableRefHelper(AblScopeMaintainer scope) {
		AblParseNode n;
		for(int i = 0; i < jjtGetNumChildren(); i++) {
			// Loop through child nodes looking for JavaNames
			
			n = (AblParseNode)jjtGetChild(i);
			if (n.id == JJTJAVANAME) {
				// A name was found. Might be a variable.
				ASTJavaName jName = (ASTJavaName)n;
				try { 
					jName.setJavaNameImage(jName.getVariableReference(scope));
				} catch (ScopeException e) {
				/* Currently doesn't produce an error for references
				to variables which are not declared in the global
				or behavior scope. This is because the code looks
				at all JavaNames appearing in the
				JavaStatement. This includes references to types as
				well as variables. Eventually need to modify the
				grammar so that all and only the variable
				references are checked by
					processVariableReferences(). */
					
					// if this is an invocation of a special method, rewrite it
					jName.rewriteSpecialMethods();
				}
			}
			else if (n.id == JJTJAVASTATEMENT) {
				((ASTJavaStatement)n).processVariableRefHelper(scope); 
			}
			else if (n.id == JJTCONDITIONALEXPRESSION) {
				((ASTConditionalExpression)n).processVariableReferences(scope);
			}
		}
    }
}






