package abl.compiler;

import jd.*;
import abl.runtime.Step;

public class ASTFailStep extends GenericStep implements AblDebuggerConstants {
    ASTFailStep(int id) {
	super(id);
    }
    
    ASTFailStep(AblParser p, int id) {
	super(p, id);
    }

    private CodeBlockDescriptor compileStepFactory() throws CompileException
    {
	CodeBlockDescriptor stepFactory = new CodeBlockDescriptor("case " + stepID + ": {", "}");
	
	stepFactory.addToBlockBody(new CodeStringDescriptor("// " + getUniqueName()));

	final CodeSequenceDescriptor propertyTableInit = compilePropertyTable();
	if (propertyTableInit != null)
	    stepFactory.addToBlockBody(propertyTableInit);

	if (!((ASTBehaviorDefinition)jjtGetParent()).isJoint() && teamEffectOnly == true)
	    throw new CompileException(getFirstLineNumber(), "a step of a non-joint behavior was annotated with team_effect_only");
	
	if (effectOnly && teamEffectOnly)
	    throw new CompileException(getFirstLineNumber(), "a step can't be annotated as both effect_only and team_effect_only");

	StringBuffer argString = new StringBuffer(500);
	argString.append(stepID + ", __$behaviorParent, " + ignoreFailure + ", " + effectOnly + ", " + teamEffectOnly + 
			 ", " + "(short)" + priority + ", " + "(short)" + priorityModifier + ", " + getPost() + ", ");

	if (getPostMemory() != null)
	    argString.append("\"" + getPostMemory() + "\"" + ", ");
	else
	    argString.append("null" + ", ");
	
	if (hasProperties())
	    argString.append("__$propertyTable");
	else
	    argString.append("null");

	if (Abl.debugLevel == GUI_DEBUGGER)
	    // construct debug versions of steps
	    stepFactory.addToBlockBody(new CodeStringDescriptor("return new FailStepDebug(" + argString.toString() + ");"));
	else
	    stepFactory.addToBlockBody(new CodeStringDescriptor("return new FailStep(" + argString.toString() + ");"));


	return stepFactory;
    }

    void compileToJava() throws CompileException 
    {
	final ASTBehaviorUnit behaviorUnitNode = ASTBehaviorUnit.getBehaviorUnit();
	final ASTBehaviorDefinition behaviorParent = (ASTBehaviorDefinition)jjtGetParent();

	if (hasModifiers()) {
	    // compile specific factories for wait steps with modifiers (typically success tests and/or user properties)
	    initStep(Step.FAIL);
	    
	    // Compile the step factory at the end since the factory references the class and method names of the 
	    // other step parts (e.g. success test, sensor factories, execute).
	    behaviorUnitNode.writeStepFactory(compileStepFactory(), this);

	}
	else {
	    // wait steps without modifiers share the default wait step
	    initStep(ASTBehaviorUnit.DEFAULT_FAIL_STEP);
	}

	// Add the step id and factory method to the parent's list of steps.
	behaviorParent.addStep(stepID, getStepFactoryMethod_rField());	
    }
    
}
