package abl.compiler;
import java.util.HashSet;
import java.util.Set;

import jd.*;

public class ASTConditionalExpression extends TestNode implements AblParserTreeConstants {
    // fixme: remove?
    // Constants indicating whether behavior scope variables should be treated as locals
    // (for PRECONDITIONS and CONTEXT_CONDITIONS).
    // private static final int LOCAL_AND_GLOBAL = 0; 
    // private static final int BEHAVIOR_AND_GLOBAL = 1;

    ASTConditionalExpression(int id) {
        super(id);
    }

    ASTConditionalExpression(AblParser p, int id) {
        super(p, id);
    }

    // fixme: come back to this code to fix it for preconditons, context conditons. May not want to make the 
    // BEHAVIOR_AND_GLOBAL and LOCAL_AND_GLOBAL distinction any more since all references to behavior scope
    // variables is now done through a variable frame. Try commenting out this distinction and see what happens.
    /* public void processVariableReferences(AblScopeMaintainer scope)
    {
    if ((AblParserTreeConstants.jjtNodeName[((SimpleNode)jjtGetParent()).id].equals("JavaStatement")) ||
        (AblParserTreeConstants.jjtNodeName[((SimpleNode)jjtGetParent()).id].equals("VariableInitializer"))) {
        // Parent is a JavaStatement - since statements can't appear in conditions, must be a mental step.
        processVariableRefHelper(scope, BEHAVIOR_AND_GLOBAL);
    }
    else if (AblParserTreeConstants.jjtNodeName[((SimpleNode)jjtGetParent()).id].equals("TestExpression")) {
        // The parent is a TestExpression. How to process variable refs depends on the kind of test expression.
        int testType = ((ASTTestExpression)jjtGetParent()).getTestType();
        if ((testType == ASTTestExpression.PRECONDITION) || 
    	(testType == ASTTestExpression.CONTEXT_CONDITION))
    	processVariableRefHelper(scope, LOCAL_AND_GLOBAL);
        else
    	processVariableRefHelper(scope, BEHAVIOR_AND_GLOBAL);
    }
    } */

    void processVariableReferences(AblScopeMaintainer scope) {
        // rewrite the behavior scope references for everything except precondition variables.
        boolean rewriteBehaviorScopeRefs = !((((SimpleNode) jjtGetParent()).id == JJTTESTEXPRESSION) && (((ASTTestExpression) jjtGetParent()).getTestType() == ASTTestExpression.PRECONDITION));
        processVariableReferences(scope, rewriteBehaviorScopeRefs);
    }

    private void processVariableReferences(AblScopeMaintainer scope, boolean rewriteBehaviorScopeRefs) {
        AblParseNode n;
        for (int i = 0; i < jjtGetNumChildren(); i++) {
            // Loop through child nodes looking for JavaNames

            n = (AblParseNode) jjtGetChild(i);
            if (n.id == JJTJAVANAME) {
                // A name was found. Might be a variable.
                ASTJavaName jName = (ASTJavaName) n;
                int scopeType = scope.lookupVariableScope(jName.getName());
                try {
                    if (rewriteBehaviorScopeRefs || !(scopeType == AblScopeMaintainer.BEHAVIOR_SCOPE))
                        jName.setJavaNameImage(jName.getVariableReference(scope));
                } catch (ScopeException e) {
                    /* Currently doesn't produce an error for references
                               to variables which are not declared in the global
                               or behavior scope. This is because the code looks
                               at all JavaNames appearing in the
                               JavaStatement. This includes references to types as
                               well as variables. Eventually need to modify the
                               grammar so that all and only the variable
                               references are checked by
                               processVariableReferences(). */

                    // if this is an invocation of a special method, rewrite it
                    jName.rewriteSpecialMethods();
                }
            } else if (n.id == JJTCONDITIONALEXPRESSION) {
                ((ASTConditionalExpression) n).processVariableReferences(scope, rewriteBehaviorScopeRefs);
            }
        }
    }

	// Returns a set of the variables that appear as LValues and are also explicitly declared behavior scope variables 
	Set<String> getBoundVariables() {
		final Set<String> boundVariables = new HashSet<String>(); // Use HashSet for efficient no-duplicates collection. 
		AblParseNode node;

		for (int i = 0; i < jjtGetNumChildren(); i++) {
			// Loop through all the child nodes looking for JavaNames 

			node = (AblParseNode) jjtGetChild(i);
			if (node.id == JJTJAVANAME) {
				// A name was found - might be a variable 
				final ASTJavaName jName = (ASTJavaName)node; 
				final AblScopeMaintainer scope = ((AblParseNode) jjtGetParent()).getEnclosingBehaviorScope();
				final int scopeType = scope.lookupVariableScope(jName.getName());
				if ((scopeType == AblScopeMaintainer.BEHAVIOR_SCOPE) && jName.isLValue()) {
					boundVariables.add(jName.getName());
				}
			}
			else if (node.id == JJTCONDITIONALEXPRESSION) {
				// Recursively getBoundVariables()
				boundVariables.addAll(((ASTConditionalExpression) node).getBoundVariables());
			}
		}

		return boundVariables;
	}
	
	// Gets the enclosing behavior scope. The parent of an ASTConditionalExpression is always a ASTTestExpression or another ASTConditionalExpression
	AblScopeMaintainer getEnclosingBehaviorScope() {
		final AblParseNode n = (AblParseNode)jjtGetParent();
		assert (n.id == JJTCONDITIONALEXPRESSION) || (n.id == JJTTESTEXPRESSION);
		return n.getEnclosingBehaviorScope();
	}

	// Returns a set of FieldDescriptors for references to explicitly declared variables. 
	final Set<FieldDescriptor> getExplicitlyDeclaredVariableReferences() {
		final Set<FieldDescriptor> declaredVariableReferences = new HashSet<FieldDescriptor>();
		for (int i = 0; i < jjtGetNumChildren(); i++) {
			// Loop through all the child nodes looking for JavaNames 

			final AblParseNode node = (AblParseNode) jjtGetChild(i);
			if (node.id == JJTJAVANAME) {
				// A name was found - might be a variable 
				final ASTJavaName jName = (ASTJavaName)node; 
				final AblScopeMaintainer scope = ((AblParseNode) jjtGetParent()).getEnclosingBehaviorScope();
				final int scopeType = scope.lookupVariableScope(jName.getName());
				// fixme: do I need to also add global variables? Do some experiments with global variable references in preconditions. 
				if ((scopeType == AblScopeMaintainer.BEHAVIOR_SCOPE)) {
					final FieldDescriptor variable = scope.lookupVariable(jName.getName());
					declaredVariableReferences.add(variable);
				}
			}
			else if (node.id == JJTCONDITIONALEXPRESSION) {
				// Recursively getExplicitlyDeclaredVariableReferences()
				declaredVariableReferences.addAll(((ASTConditionalExpression) node).getExplicitlyDeclaredVariableReferences());
			}
		}
		
		return declaredVariableReferences;		
	}
	
    JavaCodeDescriptor compileToJava() throws CompileException {
        CodeBlockDescriptor ifTest = new CodeBlockDescriptor("if (", ")");
        AblScopeMaintainer scope = ((ASTTestExpression) jjtGetParent()).getEnclosingBehaviorScope();
        processVariableReferences(scope);
        ifTest.addToBlockBody(new CodeStringDescriptor(prettyPrintTokens()));
        CodeBlockDescriptor ifBody = new CodeBlockDescriptor("{", "}");

        if (((ASTTestExpression) jjtGetParent()).hasNextTest())
            ifBody.addToBlockBody(((ASTTestExpression) jjtGetParent()).compileNextTest());
        else {
            // fixme: Consolidate with identical code in ASTWMETest
            // No more tests

            // If the test is a precondition, add code to copy variables in _variableTable. 
            if (((ASTTestExpression) jjtGetParent()).getTestType() == ASTTestExpression.PRECONDITION)
                 ((ASTTestExpression) jjtGetParent()).compileOutgoingVariables(ifBody);

            // Return true 
            ifBody.addToBlockBody(new CodeStringDescriptor("return true;"));
        }

        CodeBlockDescriptor test = new CodeBlockDescriptor();
        test.addToBlockBody(ifTest);
        test.addToBlockBody(ifBody);

        return test;
    }
}
