/* Generated By:JJTree: Do not edit this line. ASTAnonymousStep.java */

package abl.compiler;

public class ASTAnonymousStep
    extends GenericStep
    implements AblDebuggerConstants {

	/* The behavior type: sequential, parallel. */
	private String behaviorType = null;

    public ASTAnonymousStep(int id) {
        super(id);
    }

    public ASTAnonymousStep(AblParser p, int id) {
        super(p, id);
    }

	void setBehaviorType(String behaviorTypeToSet) {
		if ((behaviorTypeToSet.equals("sequential"))
			|| (behaviorTypeToSet.equals("parallel")))
			behaviorType = behaviorTypeToSet;
		else
			throw new CompileError(
				"Attempt to set illegal behavior type: " + behaviorTypeToSet);
	}

	String getBehaviorType() {
		return behaviorType;
	}

    void compileToJava() throws CompileException 
    {
	    final ASTBehaviorUnit behaviorUnitNode = ASTBehaviorUnit.getBehaviorUnit();
        ASTBehaviorDefinition parentBehavior = (ASTBehaviorDefinition)jjtGetParent();

//System.out.println("Anonymous Step Compiling, parent name '" +parentBehavior.behaviorName+ "'");

        // create a new behavior to do the work here
        int newBehId = behaviorUnitNode.getUniqueBehaviorID();
		ASTBehaviorDefinition newBehavior = new ASTBehaviorDefinition(JJTBEHAVIORDEFINITION);
        newBehavior.behaviorName = "AnonymousStep" + Integer.toString(newBehId);
        newBehavior.setBehaviorType(behaviorType);
        newBehavior.isNestedScope = true;
        newBehavior.jjtSetParent(parentBehavior);

		AblParseNode n;

        // Attach all child nodes to the new behavior
		for (int i = 0; i < jjtGetNumChildren(); i++) {
			// Loop through children nodes looking for steps.
			n = (AblParseNode) jjtGetChild(i);
            newBehavior.jjtAddChild(n, i);
            n.jjtSetParent(newBehavior);
		}
        newBehavior.compileToJava();

        ASTGoalStep goalStep = new ASTGoalStep(JJTGOALSTEP, this);
        
        
        // have it link to the existing parent behavior
        goalStep.jjtSetParent(parentBehavior);
        // tell it to call the new behavior
        goalStep.goalName = newBehavior.behaviorName;
        goalStep.setNestedScope(true);
        // compile away, as if it were parsed right out of the code
        goalStep.compileToJava();
    }
}
