/* Parse node for action registration. Always has a single child ASTJavaName node which stores the name of the concrete 
 PrimitiveAction class. */

package abl.compiler;

import java.util.*;

public class ASTActionRegistration extends AblParseNode {
	
	/* Linked list of argument types taken by the action. */
	private List<String> argumentTypes = new ArrayList<String>();
	
	/* Name of the registered action. */
	public String actionName;
	
	public ASTActionRegistration(int id) {
		super(id);
	}
	
	public ASTActionRegistration(AblParser p, int id) {
		super(p, id);
	}
	
	// Public accessor for adding argument types. 
	public void addArgumentType(String argType) {
		argumentTypes.add(argType);
	}
	
	// Public get accessor for the argumentTypes LinkedList.
	public List<String> getArgumentTypes() {
		return argumentTypes;
	}
	
	// Public get accessor for getting the name of the concrete PrimitiveAction class. 
	public String getPrimitiveAction() {
		return ((AblParseNode)jjtGetChild(0)).dumpTokens();
	}
	
}
