/* Parse tree node for ABL variable declarations. */

package abl.compiler;

import jd.FieldDescriptor;

public class ASTAblVariableDecl extends AblParseNode {

    public ASTAblVariableDecl(int id) {
        super(id);
    }

    public ASTAblVariableDecl(AblParser p, int id) {
        super(p, id);
    }

    public String getType() {
        AblParseNode n;

        for (int i = 0; i < jjtGetNumChildren(); i++) {
            n = (AblParseNode) jjtGetChild(i);
            if (n.id == JJTJAVATYPE)
                return n.dumpTokens();
        }
        throw new CompileError("A AblVariableDecl node is missing its JavaType child.");
    }

    // Returns a FieldDescriptor describing this variable declaration. 
    public FieldDescriptor[] getFieldDescriptors() {
		int numVariables = 0;
        AblParseNode n;
		
		for (int k = 0; k < jjtGetNumChildren(); k++) {
            n = (AblParseNode) jjtGetChild(k);
            if (n.id == JJTVARIABLEDECLARATORID)
                numVariables += 1;
		}
        FieldDescriptor newFields[] = new FieldDescriptor[numVariables];

		String varType = null;
		int currentVarIdx = -1;
        for (int i = 0; i < jjtGetNumChildren(); i++) {
            n = (AblParseNode) jjtGetChild(i);
            if (n.id == JJTJAVATYPE)
                varType = n.dumpTokens();
            else if (n.id == JJTVARIABLEDECLARATORID)
			{
				if (varType == null)
					throw new CompileError("Variable Declaration without type: " + n.dumpTokens());
				currentVarIdx += 1;
                newFields[currentVarIdx] = new FieldDescriptor();
                newFields[currentVarIdx].fieldType = varType;
                newFields[currentVarIdx].addFieldName(n.dumpTokens());
			}
            else if (n.id == JJTVARIABLEINITIALIZER)
                // Currently assumes that only the last variable in a
                // list of declared variables will have an initializer
                // (this is an assumption of FieldDescriptor. If
                // multiple variables in the lis have initializers,
                // the last initializer will overwrite
                // them. Eventually fix this.
                newFields[currentVarIdx].initializer = n.prettyPrintTokens();
            else
                throw new CompileError("Unexpected child node of ASTAblVariableDecl");
        }
        return newFields;
    }

    // Returns a FieldDescriptor describing this variable
    // declaration. Processes any variable references in initializers
    // relative to the scope argument.
    public FieldDescriptor[] getFieldDescriptors(AblScopeMaintainer scope) throws ScopeException {
        // Look for a variable initializer
        AblParseNode n;
        for (int i = 0; i < jjtGetNumChildren(); i++) {
            n = (AblParseNode) jjtGetChild(i);
            if (n.id == JJTVARIABLEINITIALIZER) {
                // There is a variable initializer. Process any variable references.
                 ((ASTVariableInitializer) n).processVariableReferences(scope);
            }
        }

        return getFieldDescriptors();
    }
}
