/*
 * Decompiled with CFR 0.152.
 */
package wm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import wm.WME;
import wm.WMEFieldEditor;
import wm.WmeReflectionError;
import wm.WorkingMemory;
import wm.WorkingMemoryError;
import wm.WorkingMemoryException;

public class WorkingMemoryDebugger
extends JPanel {
    private WorkingMemory wmBeingDebugged = null;
    private JTree wmTree = null;
    private JCheckBox wmUpdateTreeButton = null;
    private JPopupMenu classNodePopup;
    private JPopupMenu wmeNodePopup;
    private JPopupMenu noNodePopup;
    private WME selectedWME;
    private String selectedClass;
    private static final int wmeEditButtonContainerHeight = 47;
    private static final int labelAndFieldHeight = 21;
    private static final int minimumEditFieldWidth = 20;
    private static final int labelFieldHSeparation = 20;

    public WorkingMemoryDebugger(WorkingMemory wm) {
        this.wmBeingDebugged = wm;
        wm.setWMDebugger(this);
        this.wmTree = new JTree(this.wmBeingDebugged.getWMTreeModel());
        this.wmTree.setCellRenderer(new WMCellRenderer());
        this.wmTree.setRootVisible(false);
        this.wmUpdateTreeButton = new JCheckBox("Continuously update working memory");
        this.wmUpdateTreeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WorkingMemoryDebugger.this.wmUpdateTreeButton.isSelected()) {
                    WorkingMemoryDebugger.this.update();
                }
            }
        });
        JScrollPane WMTreeView = new JScrollPane(this.wmTree);
        WMTreeView.getViewport().setScrollMode(2);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.wmUpdateTreeButton);
        this.add(WMTreeView);
        this.setBorder(BorderFactory.createTitledBorder("Working Memory"));
        PopupMenuActionListener popupMenuActionListener = new PopupMenuActionListener();
        this.classNodePopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Add...");
        menuItem.addActionListener(popupMenuActionListener);
        this.classNodePopup.add(menuItem);
        menuItem = new JMenuItem("Delete all");
        menuItem.addActionListener(popupMenuActionListener);
        this.classNodePopup.add(menuItem);
        this.wmeNodePopup = new JPopupMenu();
        menuItem = new JMenuItem("Modify...");
        menuItem.addActionListener(popupMenuActionListener);
        this.wmeNodePopup.add(menuItem);
        menuItem = new JMenuItem("Delete");
        menuItem.addActionListener(popupMenuActionListener);
        this.wmeNodePopup.add(menuItem);
        this.noNodePopup = new JPopupMenu();
        menuItem = new JMenuItem("Add WME...");
        menuItem.addActionListener(popupMenuActionListener);
        this.noNodePopup.add(menuItem);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 4) == 4) {
                    TreePath selectedNodePath = WorkingMemoryDebugger.this.wmTree.getPathForLocation(e.getX(), e.getY());
                    if (selectedNodePath != null) {
                        WorkingMemory.WMTreeNode clickedNode = (WorkingMemory.WMTreeNode)selectedNodePath.getLastPathComponent();
                        if (clickedNode.getIsClassNode()) {
                            WorkingMemoryDebugger.this.selectedClass = (String)clickedNode.getUserObject();
                            WorkingMemoryDebugger.this.classNodePopup.show(e.getComponent(), e.getX(), e.getY());
                        } else {
                            WorkingMemoryDebugger.this.selectedWME = (WME)clickedNode.getUserObject();
                            WorkingMemoryDebugger.this.wmeNodePopup.show(e.getComponent(), e.getX(), e.getY());
                        }
                    } else {
                        WorkingMemoryDebugger.this.noNodePopup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        };
        this.wmTree.addMouseListener(ml);
    }

    private LinkedList getAllLeafPaths(TreeNode node, DefaultTreeModel model) {
        LinkedList<TreePath> pathList = new LinkedList<TreePath>();
        int childCount = node.getChildCount();
        if (childCount == 0) {
            pathList.add(new TreePath(model.getPathToRoot(node)));
            return pathList;
        }
        int i = 0;
        while (i < childCount) {
            pathList.addAll(this.getAllLeafPaths(node.getChildAt(i), model));
            ++i;
        }
        return pathList;
    }

    public void update() {
        DefaultTreeModel wmTreeModel = this.wmBeingDebugged.getWMTreeModel();
        this.wmTree.setModel(wmTreeModel);
    }

    public void updateIfMonitoring() {
        if (this.wmUpdateTreeButton.isSelected()) {
            this.update();
        }
    }

    public void clearWMView() {
        this.wmTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
    }

    class AddWMEDialog
    extends EditWMEDialog {
        AddWMEDialog(Class wmeClass) {
            super(wmeClass);
            this.okButton.addActionListener(new WMEActionListener((EditWMEDialog)this, wmeClass));
        }
    }

    class ChooseWMEDialog
    extends JDialog {
        ChooseWMEDialog me = this;

        ChooseWMEDialog() {
            this.setModal(true);
            JPanel contentPane = new JPanel();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            this.setContentPane(contentPane);
            JLabel chooseWMELabel = new JLabel("Enter the fully qualified name of a WME");
            chooseWMELabel.setAlignmentX(0.0f);
            chooseWMELabel.setHorizontalAlignment(2);
            String[] menuItems = new String[]{"facade.characters.wmedef.DAWME", "facade.characters.wmedef.PlayerGestureWME"};
            final JComboBox<String> wmeNameChooser = new JComboBox<String>(menuItems);
            wmeNameChooser.setEditable(true);
            wmeNameChooser.setSelectedItem("");
            ((JTextField)wmeNameChooser.getEditor().getEditorComponent()).getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke("ENTER"));
            JPanel buttonContainer = new JPanel();
            buttonContainer.setLayout(new BoxLayout(buttonContainer, 0));
            buttonContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JButton okButton = new JButton("OK");
            okButton.setDefaultCapable(true);
            this.getRootPane().setDefaultButton(okButton);
            JButton cancelButton = new JButton("Cancel");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Class<?> requestedWMEClass = Class.forName((String)wmeNameChooser.getSelectedItem());
                        Class<?> wmeSuperclass = Class.forName("wm.WME");
                        if (wmeSuperclass.isAssignableFrom(requestedWMEClass)) {
                            ChooseWMEDialog.this.me.dispose();
                            new AddWMEDialog(requestedWMEClass).setVisible(true);
                        } else {
                            JOptionPane.showMessageDialog(ChooseWMEDialog.this.me, "Class " + wmeNameChooser.getSelectedItem() + " is not a WME");
                        }
                    }
                    catch (ClassNotFoundException exception) {
                        JOptionPane.showMessageDialog(ChooseWMEDialog.this.me, "Class file for WME " + wmeNameChooser.getSelectedItem() + " not found");
                    }
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChooseWMEDialog.this.me.dispose();
                }
            });
            buttonContainer.add(okButton);
            buttonContainer.add(cancelButton);
            contentPane.add(chooseWMELabel);
            contentPane.add(wmeNameChooser);
            contentPane.add(buttonContainer);
            this.pack();
        }
    }

    class DefaultFieldEditor
    extends JTextField
    implements WMEFieldEditor {
        DefaultFieldEditor() {
        }

        @Override
        public String getFieldValue() {
            return this.getText();
        }

        @Override
        public void setFieldValue(String s) {
            this.setText(s);
        }
    }

    class EditWMEDialog
    extends JDialog {
        JButton okButton;
        JButton cancelButton;
        JPanel contentPane;
        JPanel labelsAndFields;
        JScrollPane labelsAndFieldsView;
        JPanel labelContainer;
        JPanel fieldContainer;
        JPanel buttonContainer;
        String[] wmeFieldNames;
        Class[] wmeFieldTypes;
        final EditWMEDialog me = this;

        EditWMEDialog(Class wmeClass) {
            this.setModal(true);
            try {
                Constructor c = wmeClass.getConstructor(null);
                WME wme = (WME)c.newInstance(null);
                this.initializeDialog(wme);
            }
            catch (Exception e) {
                throw new WmeReflectionError(e);
            }
        }

        EditWMEDialog(WME wme) {
            this.setModal(true);
            this.initializeDialog(wme);
        }

        protected void initializeDialog(WME wme) {
            this.setTitle("Modify WME of class " + wme.getClass().getName());
            this.contentPane = new JPanel();
            this.setContentPane(this.contentPane);
            this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
            this.labelsAndFields = new JPanel();
            this.labelsAndFields.setLayout(new BoxLayout(this.labelsAndFields, 0));
            this.labelsAndFields.setBorder(BorderFactory.createEtchedBorder());
            this.labelsAndFieldsView = new JScrollPane(this.labelsAndFields);
            this.labelsAndFieldsView.getViewport().setScrollMode(2);
            this.labelContainer = new JPanel();
            this.labelContainer.setLayout(new BoxLayout(this.labelContainer, 1));
            this.labelContainer.setAlignmentY(0.0f);
            this.fieldContainer = new JPanel();
            this.fieldContainer.setLayout(new BoxLayout(this.fieldContainer, 1));
            this.fieldContainer.setAlignmentY(0.0f);
            this.buttonContainer = new JPanel();
            this.buttonContainer.setLayout(new BoxLayout(this.buttonContainer, 0));
            this.buttonContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add(this.labelsAndFieldsView);
            this.labelsAndFields.add(this.labelContainer);
            this.labelsAndFields.add(Box.createHorizontalStrut(20));
            this.labelsAndFields.add(this.fieldContainer);
            this.getContentPane().add(this.buttonContainer);
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditWMEDialog.this.me.dispose();
                }
            });
            this.buttonContainer.add(Box.createHorizontalGlue());
            this.buttonContainer.add(this.okButton);
            this.buttonContainer.add(Box.createHorizontalStrut(10));
            this.buttonContainer.add(this.cancelButton);
            int buttonContainerWidth = this.buttonContainer.getMinimumSize().width;
            this.buttonContainer.setMinimumSize(new Dimension(buttonContainerWidth, 47));
            buttonContainerWidth = this.buttonContainer.getMaximumSize().width;
            this.buttonContainer.setMaximumSize(new Dimension(buttonContainerWidth, 47));
            buttonContainerWidth = this.buttonContainer.getPreferredSize().width;
            this.buttonContainer.setPreferredSize(new Dimension(buttonContainerWidth, 47));
            int labelContainerHeight = 0;
            int labelContainerWidth = 0;
            int fieldContainerHeight = 0;
            int fieldContainerWidth = 0;
            this.wmeFieldTypes = wme._getFieldTypes();
            this.wmeFieldNames = wme._getFieldNames();
            int i = 0;
            while (i < this.wmeFieldNames.length) {
                JComponent fieldEditor;
                JLabel dialogLabel = new JLabel(this.wmeFieldNames[i]);
                Dimension labelSize = dialogLabel.getPreferredSize();
                labelSize.height = 21;
                dialogLabel.setMinimumSize(labelSize);
                dialogLabel.setMaximumSize(labelSize);
                dialogLabel.setPreferredSize(labelSize);
                labelContainerHeight += dialogLabel.getPreferredSize().height;
                if (dialogLabel.getPreferredSize().width > labelContainerWidth) {
                    labelContainerWidth = dialogLabel.getPreferredSize().width;
                }
                dialogLabel.setAlignmentY(0.0f);
                this.labelContainer.add(dialogLabel);
                try {
                    String getEditorMethodName = "_get" + WME.uppercaseFirstCharacter(this.wmeFieldNames[i]) + "Editor";
                    Method fieldEditorMethod = wme.getClass().getMethod(getEditorMethodName, null);
                    fieldEditor = (JComponent)fieldEditorMethod.invoke((Object)wme, null);
                }
                catch (Exception e) {
                    fieldEditor = new DefaultFieldEditor();
                }
                Dimension fieldEditorSize = fieldEditor.getPreferredSize();
                fieldEditorSize.height = 21;
                fieldEditor.setPreferredSize(fieldEditorSize);
                fieldEditorSize = fieldEditor.getMaximumSize();
                fieldEditorSize.height = 21;
                fieldEditor.setMaximumSize(fieldEditorSize);
                fieldEditor.setAlignmentY(0.0f);
                fieldContainerHeight += dialogLabel.getPreferredSize().height;
                if (fieldEditor.getPreferredSize().width > fieldContainerWidth) {
                    fieldContainerWidth = fieldEditor.getPreferredSize().width;
                }
                this.fieldContainer.add(fieldEditor);
                ++i;
            }
            this.labelContainer.setPreferredSize(new Dimension(labelContainerWidth, labelContainerHeight));
            this.labelContainer.setMinimumSize(new Dimension(labelContainerWidth, labelContainerHeight));
            this.fieldContainer.setPreferredSize(new Dimension(fieldContainerWidth, fieldContainerHeight));
            this.fieldContainer.setMinimumSize(new Dimension(fieldContainerWidth, fieldContainerHeight));
            int minimumViewWidth = this.labelContainer.getMinimumSize().width + this.fieldContainer.getMinimumSize().width + 20;
            int minimumViewHeight = 63;
            this.labelsAndFieldsView.setMinimumSize(new Dimension(minimumViewWidth, 63));
            this.pack();
        }
    }

    class ModifyWMEDialog
    extends EditWMEDialog {
        ModifyWMEDialog(WME wmeToModify) {
            super(wmeToModify.getClass());
            this.okButton.addActionListener(new WMEActionListener((EditWMEDialog)this, wmeToModify));
            try {
                int i = 0;
                while (i < this.wmeFieldTypes.length) {
                    Method getMethod = wmeToModify._getGetMethod(this.wmeFieldNames[i]);
                    if (this.wmeFieldTypes[i] == Boolean.TYPE) {
                        Boolean tempBoolean = (Boolean)getMethod.invoke((Object)wmeToModify, null);
                        ((WMEFieldEditor)((Object)this.fieldContainer.getComponent(i))).setFieldValue(tempBoolean.toString());
                    } else if (this.wmeFieldTypes[i] == Byte.TYPE) {
                        Byte tempByte = (Byte)getMethod.invoke((Object)wmeToModify, null);
                        ((WMEFieldEditor)((Object)this.fieldContainer.getComponent(i))).setFieldValue(tempByte.toString());
                    } else if (this.wmeFieldTypes[i] == Integer.TYPE) {
                        Integer tempInteger = (Integer)getMethod.invoke((Object)wmeToModify, null);
                        ((WMEFieldEditor)((Object)this.fieldContainer.getComponent(i))).setFieldValue(tempInteger.toString());
                    } else if (this.wmeFieldTypes[i] == Long.TYPE) {
                        Long tempLong = (Long)getMethod.invoke((Object)wmeToModify, null);
                        ((WMEFieldEditor)((Object)this.fieldContainer.getComponent(i))).setFieldValue(tempLong.toString());
                    } else if (this.wmeFieldTypes[i] == Short.TYPE) {
                        Short tempShort = (Short)getMethod.invoke((Object)wmeToModify, null);
                        ((WMEFieldEditor)((Object)this.fieldContainer.getComponent(i))).setFieldValue(tempShort.toString());
                    } else if (this.wmeFieldTypes[i] == Float.TYPE) {
                        Float tempFloat = (Float)getMethod.invoke((Object)wmeToModify, null);
                        ((WMEFieldEditor)((Object)this.fieldContainer.getComponent(i))).setFieldValue(tempFloat.toString());
                    } else if (this.wmeFieldTypes[i] == Double.TYPE) {
                        Double tempDouble = (Double)getMethod.invoke((Object)wmeToModify, null);
                        ((WMEFieldEditor)((Object)this.fieldContainer.getComponent(i))).setFieldValue(tempDouble.toString());
                    } else if (this.wmeFieldTypes[i] == Character.TYPE) {
                        Character tempCharacter = (Character)getMethod.invoke((Object)wmeToModify, null);
                        ((WMEFieldEditor)((Object)this.fieldContainer.getComponent(i))).setFieldValue(tempCharacter.toString());
                    } else if (this.wmeFieldTypes[i].getName().equals("java.lang.String")) {
                        String tempString = (String)getMethod.invoke((Object)wmeToModify, null);
                        ((WMEFieldEditor)((Object)this.fieldContainer.getComponent(i))).setFieldValue(tempString);
                    } else {
                        Object o = getMethod.invoke((Object)wmeToModify, null);
                        if (o != null) {
                            String tempString = o.toString();
                            ((WMEFieldEditor)((Object)this.fieldContainer.getComponent(i))).setFieldValue(tempString);
                        } else {
                            ((WMEFieldEditor)((Object)this.fieldContainer.getComponent(i))).setFieldValue("null");
                        }
                        ((JTextField)this.fieldContainer.getComponent(i)).setEditable(false);
                    }
                    ++i;
                }
            }
            catch (IllegalAccessException e) {
                throw new WmeReflectionError(e);
            }
            catch (InvocationTargetException e) {
                throw new WmeReflectionError(e);
            }
            catch (NoSuchFieldException e) {
                throw new WmeReflectionError(e);
            }
        }
    }

    class PopupMenuActionListener
    implements ActionListener {
        PopupMenuActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            if (action.equals("Delete")) {
                WorkingMemoryDebugger.this.wmBeingDebugged.deleteWME(WorkingMemoryDebugger.this.selectedWME);
            } else if (action.equals("Delete all")) {
                WorkingMemoryDebugger.this.wmBeingDebugged.deleteAllWMEClass(WorkingMemoryDebugger.this.selectedClass);
            } else if (action.equals("Add...")) {
                WME sampleWME = (WME)WorkingMemoryDebugger.this.wmBeingDebugged.lookupWME(WorkingMemoryDebugger.this.selectedClass).get(0);
                Class<?> tempClass = sampleWME.getClass();
                new AddWMEDialog(tempClass).setVisible(true);
            } else if (action.equals("Modify...")) {
                new ModifyWMEDialog(WorkingMemoryDebugger.this.selectedWME).setVisible(true);
            } else if (action.equals("Add WME...")) {
                new ChooseWMEDialog().setVisible(true);
            }
            if (!WorkingMemoryDebugger.this.wmUpdateTreeButton.isSelected()) {
                WorkingMemoryDebugger.this.update();
            }
        }
    }

    protected class WMCellRenderer
    extends JTextPane
    implements TreeCellRenderer {
        private final DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();

        public WMCellRenderer() {
            this.setContentType("text/html");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (expanded) {
                Icon nodeIcon = this.defaultRenderer.getOpenIcon();
            } else if (leaf) {
                Icon nodeIcon = this.defaultRenderer.getLeafIcon();
            } else {
                Icon nodeIcon = this.defaultRenderer.getClosedIcon();
            }
            Color backgroundColor = sel ? this.defaultRenderer.getBackgroundSelectionColor() : this.defaultRenderer.getBackgroundNonSelectionColor();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() != null) {
                this.setDocument(this.getEditorKit().createDefaultDocument());
                if (node.getUserObject().getClass().getName().equals("java.lang.String")) {
                    this.setText("<font size = \"-1\" face=\"Helvetica, Arial, sans-serif\">" + (String)node.getUserObject());
                } else {
                    this.setText(((WME)node.getUserObject()).toString_HTML());
                }
            }
            this.setBackground(backgroundColor);
            return this;
        }
    }

    class WMEActionListener
    implements ActionListener {
        static final int ADD_WME = 0;
        static final int MODIFY_WME = 1;
        private int actionToPerform;
        private WME wmeToModify;
        private EditWMEDialog dialog;

        WMEActionListener(EditWMEDialog d, WME wme) {
            this.actionToPerform = 1;
            this.wmeToModify = wme;
            this.dialog = d;
        }

        WMEActionListener(EditWMEDialog d, Class wmeClass) {
            this.actionToPerform = 0;
            this.dialog = d;
            try {
                Constructor c = wmeClass.getConstructor(null);
                this.wmeToModify = (WME)c.newInstance(null);
            }
            catch (NoSuchMethodException exception) {
                throw new WmeReflectionError(exception.getMessage());
            }
            catch (InstantiationException exception) {
                throw new WmeReflectionError(exception.getMessage());
            }
            catch (IllegalAccessException exception) {
                throw new WmeReflectionError(exception.getMessage());
            }
            catch (InvocationTargetException exception) {
                throw new WmeReflectionError(exception.getMessage());
            }
        }

        private void modifyWME() {
            WME newWME;
            try {
                newWME = (WME)this.wmeToModify.getClass().getConstructor(null).newInstance(null);
                newWME.assign(this.wmeToModify);
            }
            catch (Exception e) {
                throw new WmeReflectionError(e);
            }
            boolean errorOccurred = false;
            try {
                int i = 0;
                while (i < this.dialog.wmeFieldTypes.length) {
                    String editFieldString = ((WMEFieldEditor)((Object)this.dialog.fieldContainer.getComponent(i))).getFieldValue();
                    String fieldName = ((JLabel)this.dialog.labelContainer.getComponent(i)).getText();
                    try {
                        Object[] setArgs;
                        Method wmeSetMethod = this.wmeToModify._getSetMethod(fieldName, this.dialog.wmeFieldTypes[i]);
                        if (this.dialog.wmeFieldTypes[i] == Boolean.TYPE) {
                            if (editFieldString.equals("true") || editFieldString.equals("false")) {
                                setArgs = new Object[]{new Boolean(editFieldString)};
                                wmeSetMethod.invoke((Object)newWME, setArgs);
                            } else {
                                throw new IllegalWMEFieldValueException(editFieldString, this.dialog.wmeFieldTypes[i]);
                            }
                        }
                        try {
                            if (this.dialog.wmeFieldTypes[i] == Byte.TYPE) {
                                setArgs = new Object[]{new Byte(editFieldString)};
                                wmeSetMethod.invoke((Object)newWME, setArgs);
                            }
                            if (this.dialog.wmeFieldTypes[i] == Integer.TYPE) {
                                setArgs = new Object[]{new Integer(editFieldString)};
                                wmeSetMethod.invoke((Object)newWME, setArgs);
                            }
                            if (this.dialog.wmeFieldTypes[i] == Long.TYPE) {
                                setArgs = new Object[]{new Long(editFieldString)};
                                wmeSetMethod.invoke((Object)newWME, setArgs);
                            }
                            if (this.dialog.wmeFieldTypes[i] == Short.TYPE) {
                                setArgs = new Object[]{new Short(editFieldString)};
                                wmeSetMethod.invoke((Object)newWME, setArgs);
                            }
                            if (this.dialog.wmeFieldTypes[i] == Float.TYPE) {
                                setArgs = new Object[]{new Float(editFieldString)};
                                wmeSetMethod.invoke((Object)newWME, setArgs);
                            }
                            if (this.dialog.wmeFieldTypes[i] == Double.TYPE) {
                                setArgs = new Object[]{new Double(editFieldString)};
                                wmeSetMethod.invoke((Object)newWME, setArgs);
                            }
                        }
                        catch (NumberFormatException exception) {
                            throw new IllegalWMEFieldValueException(editFieldString, this.dialog.wmeFieldTypes[i]);
                        }
                        if (this.dialog.wmeFieldTypes[i] == Character.TYPE) {
                            char[] charArray = editFieldString.toCharArray();
                            if (charArray.length == 1) {
                                Object[] setArgs2 = new Object[]{new Character(charArray[0])};
                                wmeSetMethod.invoke((Object)newWME, setArgs2);
                            } else {
                                throw new IllegalWMEFieldValueException(editFieldString, this.dialog.wmeFieldTypes[i]);
                            }
                        }
                        if (this.dialog.wmeFieldTypes[i].getName().equals("java.lang.String")) {
                            setArgs = new Object[]{editFieldString};
                            wmeSetMethod.invoke((Object)newWME, setArgs);
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    ++i;
                }
                if (this.actionToPerform == 1) {
                    WorkingMemoryDebugger.this.wmBeingDebugged.modifyWME(this.wmeToModify, newWME);
                } else if (this.actionToPerform == 0) {
                    WorkingMemoryDebugger.this.wmBeingDebugged.addWME(newWME);
                }
                this.dialog.dispose();
            }
            catch (InvocationTargetException exception) {
                throw new WmeReflectionError(exception);
            }
            catch (IllegalAccessException exception) {
                throw new WmeReflectionError(exception);
            }
            catch (WorkingMemoryException exception) {
                throw new WorkingMemoryError(exception.getMessage());
            }
            catch (IllegalWMEFieldValueException exception) {
                JOptionPane.showMessageDialog(this.dialog, "Field value " + exception.fieldValue + " is not a valid " + exception.fieldType);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.modifyWME();
        }

        class IllegalWMEFieldValueException
        extends Exception {
            public String fieldValue;
            public Class fieldType;

            public IllegalWMEFieldValueException(String fieldValue, Class fieldType) {
                this.fieldValue = fieldValue;
                this.fieldType = fieldType;
            }
        }
    }
}

