/*
 * Decompiled with CFR 0.152.
 */
package wm;

import abl.runtime.AblNamedPropertySupport;
import abl.runtime.BehaviorWME;
import abl.runtime.CollectionBehaviorWME;
import abl.runtime.FailStepWME;
import abl.runtime.GoalStepWME;
import abl.runtime.MentalStepWME;
import abl.runtime.ParallelBehaviorWME;
import abl.runtime.PrimitiveStepWME;
import abl.runtime.SequentialBehaviorWME;
import abl.runtime.StepWME;
import abl.runtime.SucceedStepWME;
import abl.runtime.WaitStepWME;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import wm.IncompatibleWmeClassException;
import wm.NonexistentWmeException;
import wm.TimeStampedWME;
import wm.TransientWME;
import wm.WME;
import wm.WmeReflectionError;
import wm.WorkingMemoryDebugger;

public class WorkingMemory {
    protected Hashtable memory = new Hashtable();
    protected WorkingMemoryDebugger workingMemoryDebugger = null;
    private static Hashtable workingMemoryRegistry = new Hashtable();
    private static final Class goalStepWME = GoalStepWME.class;
    private static final Class primitiveStepWME = PrimitiveStepWME.class;
    private static final Class mentalStepWME = MentalStepWME.class;
    private static final Class waitStepWME = WaitStepWME.class;
    private static final Class failStepWME = FailStepWME.class;
    private static final Class succeedStepWME = SucceedStepWME.class;
    private static final Class collectionBehaviorWME = CollectionBehaviorWME.class;
    private static final Class parallelBehaviorWME = ParallelBehaviorWME.class;
    private static final Class sequentialBehaviorWME = SequentialBehaviorWME.class;
    private static final Class stepWME = StepWME.class;
    private static final Class behaviorWME = BehaviorWME.class;

    public WorkingMemory() {
    }

    public WorkingMemory(String name) {
        workingMemoryRegistry.put(name, this);
    }

    public static WorkingMemory lookupRegisteredMemory(String name) {
        return (WorkingMemory)workingMemoryRegistry.get(name);
    }

    public static String wmeShortName(WME w) {
        String longName = w.getClass().getName();
        return longName.substring(longName.lastIndexOf(46) + 1);
    }

    public static String wmeShortName(String wmeName) {
        if (wmeName.indexOf(46) != -1) {
            return wmeName.substring(wmeName.lastIndexOf(46) + 1);
        }
        return wmeName;
    }

    public static List<String> wmeShortNames(WME w) {
        LinkedList<String> classNameList = new LinkedList<String>();
        Class<?> currentClass = w.getClass();
        String longName = currentClass.getName();
        while (!WorkingMemory.wmeShortName(longName).equals("WME")) {
            classNameList.add(WorkingMemory.wmeShortName(longName));
            currentClass = currentClass.getSuperclass();
            longName = currentClass.getName();
        }
        return classNameList;
    }

    public TreeMap<String, Integer> getMemoryUsage() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (Object keyObject : new ArrayList(this.memory.keySet())) {
            String key = (String)keyObject;
            Object value = this.memory.get(key);
            if (value == null) continue;
            if (value instanceof LinkedList) {
                map.put(key, ((LinkedList)value).size());
                continue;
            }
            if (!(value instanceof ReflectionWMEEntry)) continue;
            map.put(key, ((ReflectionWMEEntry)value).wmeList.size());
        }
        return map;
    }

    public synchronized void addWME(WME w) {
        assert (w != null);
        if (WorkingMemory.isReflectionWME(w)) {
            this.addReflectionWME(w);
        } else {
            try {
                if (w instanceof TimeStampedWME && ((TimeStampedWME)w).getTimestamp() == 0L) {
                    ((TimeStampedWME)w).setTimestamp(System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                throw new WmeReflectionError(e);
            }
            List<String> classNameList = WorkingMemory.wmeShortNames(w);
            for (String wmeClassName : classNameList) {
                if (!this.memory.containsKey(wmeClassName)) {
                    LinkedList<WME> newList = new LinkedList<WME>();
                    newList.add(w);
                    this.memory.put(wmeClassName, newList);
                    continue;
                }
                LinkedList oldList = (LinkedList)this.memory.get(wmeClassName);
                oldList.add(w);
            }
        }
        if (this.workingMemoryDebugger != null) {
            this.workingMemoryDebugger.updateIfMonitoring();
        }
    }

    public synchronized void addWMEs(List wmeList) {
        assert (wmeList != null);
        Iterator iter = wmeList.iterator();
        while (iter.hasNext()) {
            this.addWME((WME)iter.next());
        }
    }

    public static void addWME(String memoryName, WME w) {
        WorkingMemory wm = WorkingMemory.lookupRegisteredMemory(memoryName);
        wm.addWME(w);
    }

    public static void addWMEs(String memoryName, List wmeList) {
        WorkingMemory wm = WorkingMemory.lookupRegisteredMemory(memoryName);
        wm.addWMEs(wmeList);
    }

    public synchronized void modifyWME(WME wmeToModify, WME wmeWithNewValues) throws IncompatibleWmeClassException, NonexistentWmeException {
        assert (!WorkingMemory.isReflectionWME(WorkingMemory.wmeShortName(wmeToModify)));
        if (!WorkingMemory.wmeShortName(wmeToModify).equals(WorkingMemory.wmeShortName(wmeWithNewValues))) {
            throw new IncompatibleWmeClassException();
        }
        String wmeClass = WorkingMemory.wmeShortName(wmeToModify);
        if (!this.memory.containsKey(wmeClass)) {
            throw new NonexistentWmeException();
        }
        LinkedList wmeList = (LinkedList)this.memory.get(wmeClass);
        if (!wmeList.contains(wmeToModify)) {
            throw new NonexistentWmeException();
        }
        wmeToModify.assign(wmeWithNewValues);
        if (this.workingMemoryDebugger != null) {
            this.workingMemoryDebugger.updateIfMonitoring();
        }
    }

    public static void modifyWME(String memoryName, WME wmeToModify, WME wmeWithNewValues) throws IncompatibleWmeClassException, NonexistentWmeException {
        WorkingMemory wm = WorkingMemory.lookupRegisteredMemory(memoryName);
        wm.modifyWME(wmeToModify, wmeWithNewValues);
    }

    public synchronized void deleteWME(WME wmeToDelete) {
        String wmeClass = WorkingMemory.wmeShortName(wmeToDelete);
        if (WorkingMemory.isReflectionWME(wmeClass)) {
            this.deleteReflectionWME(wmeToDelete);
        } else {
            List<String> classNameList = WorkingMemory.wmeShortNames(wmeToDelete);
            for (String wmeClassName : classNameList) {
                if (!this.memory.containsKey(wmeClassName)) continue;
                LinkedList wmeList = (LinkedList)this.memory.get(wmeClassName);
                if (wmeList.contains(wmeToDelete)) {
                    wmeList.remove(wmeToDelete);
                }
                if (wmeList.size() != 0) continue;
                this.memory.remove(wmeClassName);
            }
        }
        if (this.workingMemoryDebugger != null) {
            this.workingMemoryDebugger.updateIfMonitoring();
        }
    }

    public static void deleteWME(String memoryName, WME wmeToDelete) {
        WorkingMemory wm = WorkingMemory.lookupRegisteredMemory(memoryName);
        wm.deleteWME(wmeToDelete);
    }

    public synchronized void deleteAllWMEClass(String wmeClassName) {
        if (WorkingMemory.isReflectionWME(wmeClassName)) {
            this.deleteAllReflectionWMEClass(wmeClassName);
        } else if (this.memory.containsKey(wmeClassName)) {
            LinkedList wmeList = (LinkedList)this.memory.get(wmeClassName);
            ListIterator wmeListIter = wmeList.listIterator();
            HashSet<String> listsToClear = new HashSet<String>();
            while (wmeListIter.hasNext()) {
                WME currWME = (WME)wmeListIter.next();
                List<String> classNames = WorkingMemory.wmeShortNames(currWME);
                boolean isSuperclass = false;
                for (String className : classNames) {
                    if (!isSuperclass && className.equals(wmeClassName)) {
                        isSuperclass = true;
                    }
                    if (!isSuperclass) {
                        listsToClear.add(className);
                        continue;
                    }
                    if (className.equals(wmeClassName) || !this.memory.containsKey(className)) continue;
                    ((LinkedList)this.memory.get(className)).remove(currWME);
                }
                wmeListIter.remove();
            }
            for (String clearList : listsToClear) {
                if (!this.memory.containsKey(clearList)) continue;
                ((LinkedList)this.memory.get(clearList)).clear();
            }
        }
        if (this.workingMemoryDebugger != null) {
            this.workingMemoryDebugger.updateIfMonitoring();
        }
    }

    public static void deleteAllWMEClass(String memoryName, String wmeClassName) {
        WorkingMemory wm = WorkingMemory.lookupRegisteredMemory(memoryName);
        wm.deleteAllWMEClass(wmeClassName);
    }

    protected synchronized void deleteReflectionWME(WME w) {
        assert (WorkingMemory.isReflectionWME(w));
        String wmeClassName = WorkingMemory.wmeShortName(w);
        ReflectionWMEEntry entry = (ReflectionWMEEntry)this.memory.get(wmeClassName);
        assert (entry != null) : wmeClassName;
        entry.deleteWME(w);
        if (entry.getWMEList().size() == 0) {
            this.memory.remove(wmeClassName);
        }
    }

    protected synchronized void deleteAllReflectionWMEClass(String wmeClassName) {
        assert (this.memory.get(wmeClassName) != null);
        this.memory.remove(wmeClassName);
    }

    public synchronized LinkedList lookupWME(String wmeClassName) {
        LinkedList wmeList;
        if (WorkingMemory.isReflectionWME(wmeClassName)) {
            ReflectionWMEEntry entry = (ReflectionWMEEntry)this.memory.get(wmeClassName);
            if (entry == null) {
                return new LinkedList();
            }
            wmeList = entry.getWMEList();
        } else {
            wmeList = (LinkedList)this.memory.get(wmeClassName);
        }
        if (wmeList == null) {
            return new LinkedList();
        }
        return (LinkedList)wmeList.clone();
    }

    public static LinkedList lookupWME(String memoryName, String wmeClassName) {
        WorkingMemory wm = WorkingMemory.lookupRegisteredMemory(memoryName);
        return wm.lookupWME(wmeClassName);
    }

    public synchronized List lookupReflectionWMEBySignature(String wmeClassName, String signature) {
        assert (wmeClassName.equals("GoalStepWME") || wmeClassName.equals("SequentialBehaviorWME") || wmeClassName.equals("ParallelBehaviorWME") || wmeClassName.equals("CollectionBehaviorWME"));
        ReflectionWMEEntry entry = (ReflectionWMEEntry)this.memory.get(wmeClassName);
        if (entry == null) {
            return new LinkedList();
        }
        return (LinkedList)entry.lookupWMEBySignature(signature).clone();
    }

    public static List lookupReflectionWMEBySignature(String memoryName, String wmeClassName, String signature) {
        WorkingMemory wm = WorkingMemory.lookupRegisteredMemory(memoryName);
        return wm.lookupReflectionWMEBySignature(wmeClassName, signature);
    }

    public synchronized List lookupReflectionWMEByUserProperty(String wmeClassName, String userPropertyName) {
        assert (WorkingMemory.isReflectionWME(wmeClassName));
        ReflectionWMEEntry entry = (ReflectionWMEEntry)this.memory.get(wmeClassName);
        if (entry == null) {
            return new LinkedList();
        }
        return (LinkedList)entry.lookupWMEByProperty(userPropertyName).clone();
    }

    public static List lookupReflectionWMEByUserProperty(String memoryName, String wmeClassName, String userPropertyName) {
        WorkingMemory wm = WorkingMemory.lookupRegisteredMemory(memoryName);
        return wm.lookupReflectionWMEByUserProperty(wmeClassName, userPropertyName);
    }

    protected synchronized void addReflectionWME(WME w) {
        assert (WorkingMemory.isReflectionWME(w));
        String wmeClassName = WorkingMemory.wmeShortName(w);
        if (!this.memory.containsKey(wmeClassName)) {
            ReflectionWMEEntry entry = new ReflectionWMEEntry();
            entry.addWME(w);
            this.memory.put(wmeClassName, entry);
        } else {
            ReflectionWMEEntry entry = (ReflectionWMEEntry)this.memory.get(wmeClassName);
            entry.addWME(w);
        }
    }

    public static boolean isReflectionWME(String wmeClassName) {
        return wmeClassName.equals("GoalStepWME") || wmeClassName.equals("PrimitiveStepWME") || wmeClassName.equals("MentalStepWME") || wmeClassName.equals("WaitStepWME") || wmeClassName.equals("FailStepWME") || wmeClassName.equals("SucceedStepWME") || wmeClassName.equals("CollectionBehaviorWME") || wmeClassName.equals("ParallelBehaviorWME") || wmeClassName.equals("SequentialBehaviorWME");
    }

    public static boolean isReflectionWME(WME wme) {
        Class<?> wmeClass = wme.getClass();
        return WorkingMemory.isReflectionWME(WorkingMemory.wmeShortName(wmeClass.getName()));
    }

    public static boolean isReflectionWME(Class wmeClass) {
        return WorkingMemory.isReflectionWME(WorkingMemory.wmeShortName(wmeClass.getName()));
    }

    public synchronized WME findNext(String wmeClassName, long timestamp) {
        try {
            assert (Class.forName("wm.TimeStampedWME").isAssignableFrom(Class.forName(wmeClassName)));
        }
        catch (Exception e) {
            throw new WmeReflectionError(e);
        }
        LinkedList wmeList = this.lookupWME(WorkingMemory.wmeShortName(wmeClassName));
        if (wmeList.size() == 0) {
            return null;
        }
        Object[] wmeArray = wmeList.toArray(new TimeStampedWME[wmeList.size()]);
        Arrays.sort(wmeArray);
        int i = 0;
        while (i < wmeArray.length) {
            if (((TimeStampedWME)wmeArray[i]).getTimestamp() > timestamp) {
                return wmeArray[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized WME findPrev(String wmeClassName, long timestamp) {
        try {
            assert (Class.forName("wm.TimeStampedWME").isAssignableFrom(Class.forName(wmeClassName)));
        }
        catch (Exception e) {
            throw new WmeReflectionError(e);
        }
        LinkedList wmeList = this.lookupWME(WorkingMemory.wmeShortName(wmeClassName));
        if (wmeList.size() == 0) {
            return null;
        }
        Object[] wmeArray = wmeList.toArray(new TimeStampedWME[wmeList.size()]);
        Arrays.sort(wmeArray);
        int i = wmeArray.length - 1;
        while (i >= 0) {
            if (((TimeStampedWME)wmeArray[i]).getTimestamp() < timestamp) {
                return wmeArray[i];
            }
            --i;
        }
        return null;
    }

    public synchronized WME findFirst(String wmeClassName) {
        try {
            assert (Class.forName("wm.TimeStampedWME").isAssignableFrom(Class.forName(wmeClassName)));
        }
        catch (Exception e) {
            throw new WmeReflectionError(e);
        }
        LinkedList wmeList = this.lookupWME(WorkingMemory.wmeShortName(wmeClassName));
        if (wmeList.size() == 0) {
            return null;
        }
        Object[] wmeArray = wmeList.toArray(new TimeStampedWME[wmeList.size()]);
        Arrays.sort(wmeArray);
        return wmeArray[0];
    }

    public synchronized WME findLast(String wmeClassName) {
        try {
            assert (Class.forName("wm.TimeStampedWME").isAssignableFrom(Class.forName(wmeClassName)));
        }
        catch (Exception e) {
            throw new WmeReflectionError(e);
        }
        LinkedList wmeList = this.lookupWME(WorkingMemory.wmeShortName(wmeClassName));
        if (wmeList.size() == 0) {
            return null;
        }
        Object[] wmeArray = wmeList.toArray(new TimeStampedWME[wmeList.size()]);
        Arrays.sort(wmeArray);
        return wmeArray[wmeArray.length - 1];
    }

    public synchronized List findAll(String wmeClassName, long beginTimestamp, long endTimestamp) {
        try {
            assert (Class.forName("wm.TimeStampedWME").isAssignableFrom(Class.forName(wmeClassName)));
        }
        catch (Exception e) {
            throw new WmeReflectionError(e);
        }
        LinkedList wmeList = this.lookupWME(WorkingMemory.wmeShortName(wmeClassName));
        if (wmeList.size() == 0) {
            return new Vector();
        }
        Object[] wmeArray = wmeList.toArray(new TimeStampedWME[wmeList.size()]);
        Arrays.sort(wmeArray);
        Vector<Object> returnList = new Vector<Object>();
        int i = 0;
        while (i < wmeArray.length) {
            if (((TimeStampedWME)wmeArray[i]).getTimestamp() >= beginTimestamp && ((TimeStampedWME)wmeArray[i]).getTimestamp() <= endTimestamp) {
                returnList.add(wmeArray[i]);
            }
            if (((TimeStampedWME)wmeArray[i]).getTimestamp() > endTimestamp) break;
            ++i;
        }
        return returnList;
    }

    public synchronized int countWMEBefore(String wmeClassName, long timestamp) {
        try {
            assert (Class.forName("wm.TimeStampedWME").isAssignableFrom(Class.forName(wmeClassName)));
        }
        catch (Exception e) {
            throw new WmeReflectionError(e);
        }
        LinkedList wmeList = this.lookupWME(WorkingMemory.wmeShortName(wmeClassName));
        if (wmeList.size() == 0) {
            return 0;
        }
        Object[] wmeArray = wmeList.toArray(new TimeStampedWME[wmeList.size()]);
        Arrays.sort(wmeArray);
        int count = 0;
        int i = 0;
        while (i < wmeArray.length) {
            if (((TimeStampedWME)wmeArray[i]).getTimestamp() < timestamp) {
                ++count;
            }
            if (((TimeStampedWME)wmeArray[i]).getTimestamp() >= timestamp) break;
            ++i;
        }
        return count;
    }

    public synchronized int countWMEAfter(String wmeClassName, long timestamp) {
        try {
            assert (Class.forName("wm.TimeStampedWME").isAssignableFrom(Class.forName(wmeClassName)));
        }
        catch (Exception e) {
            throw new WmeReflectionError(e);
        }
        LinkedList wmeList = this.lookupWME(WorkingMemory.wmeShortName(wmeClassName));
        if (wmeList.size() == 0) {
            return 0;
        }
        Object[] wmeArray = wmeList.toArray(new TimeStampedWME[wmeList.size()]);
        Arrays.sort(wmeArray);
        int count = 0;
        int i = wmeArray.length - 1;
        while (i >= 0) {
            if (((TimeStampedWME)wmeArray[i]).getTimestamp() > timestamp) {
                ++count;
            }
            if (((TimeStampedWME)wmeArray[i]).getTimestamp() <= timestamp) break;
            --i;
        }
        return count;
    }

    public synchronized int countWMEBetween(String wmeClassName, long beginTimestamp, long endTimestamp) {
        try {
            assert (Class.forName("wm.TimeStampedWME").isAssignableFrom(Class.forName(wmeClassName)));
        }
        catch (Exception e) {
            throw new WmeReflectionError(e);
        }
        LinkedList wmeList = this.lookupWME(WorkingMemory.wmeShortName(wmeClassName));
        if (wmeList.size() == 0) {
            return 0;
        }
        Object[] wmeArray = wmeList.toArray(new TimeStampedWME[wmeList.size()]);
        Arrays.sort(wmeArray);
        int count = 0;
        int i = 0;
        while (i < wmeArray.length) {
            if (((TimeStampedWME)wmeArray[i]).getTimestamp() >= beginTimestamp && ((TimeStampedWME)wmeArray[i]).getTimestamp() <= endTimestamp) {
                ++count;
            }
            if (((TimeStampedWME)wmeArray[i]).getTimestamp() > endTimestamp) break;
            ++i;
        }
        return count;
    }

    public synchronized DefaultTreeModel getWMTreeModel() {
        Enumeration keyEnumerator = this.memory.keys();
        DefaultTreeModel WMTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("working memory root"));
        DefaultMutableTreeNode WMRoot = (DefaultMutableTreeNode)WMTreeModel.getRoot();
        while (keyEnumerator.hasMoreElements()) {
            String wmeClassName = (String)keyEnumerator.nextElement();
            LinkedList wmeList = WorkingMemory.isReflectionWME(wmeClassName) ? ((ReflectionWMEEntry)this.memory.get(wmeClassName)).getWMEList() : (LinkedList)this.memory.get(wmeClassName);
            if (wmeList.isEmpty()) continue;
            ListIterator wmeListIter = wmeList.listIterator();
            WMTreeNode wmeClassNode = new WMTreeNode(wmeClassName, true);
            WMRoot.add(wmeClassNode);
            while (wmeListIter.hasNext()) {
                WMTreeNode wmeNode = new WMTreeNode(wmeListIter.next(), false);
                wmeClassNode.add(wmeNode);
            }
        }
        return WMTreeModel;
    }

    public WorkingMemoryDebugger getWMDebugInterface() {
        return new WorkingMemoryDebugger(this);
    }

    void setWMDebugger(WorkingMemoryDebugger wmd) {
        assert (this.workingMemoryDebugger == null);
        this.workingMemoryDebugger = wmd;
    }

    public synchronized void markTransientWMEs() {
        Enumeration keys = this.memory.keys();
        while (keys.hasMoreElements()) {
            List wmes;
            String key = (String)keys.nextElement();
            if (WorkingMemory.isReflectionWME(key) || (wmes = (List)this.memory.get(key)).isEmpty() || !((WME)wmes.get(0)).isTransient()) continue;
            Iterator iter = wmes.iterator();
            while (iter.hasNext()) {
                ((TransientWME)iter.next()).mark();
            }
        }
    }

    public synchronized void deleteMarkedTransientWMEs() {
        Enumeration keys = this.memory.keys();
        while (keys.hasMoreElements()) {
            Vector wmes;
            String key = (String)keys.nextElement();
            if (WorkingMemory.isReflectionWME(key) || (wmes = new Vector((List)this.memory.get(key))).isEmpty() || !((WME)wmes.get(0)).isTransient()) continue;
            for (TransientWME tWME : wmes) {
                if (!tWME.getMarked()) continue;
                this.deleteWME(tWME);
            }
        }
    }

    protected class ReflectionWMEEntry {
        private final LinkedList wmeList = new LinkedList();
        private final Hashtable signatureTable = new Hashtable();
        private final Hashtable propertyTable = new Hashtable();

        public void addWME(WME w) {
            String name = WorkingMemory.wmeShortName(w);
            if (name.equals("GoalStepWME")) {
                this.addGoalStepWME((GoalStepWME)w);
            } else if (name.equals("WaitStepWME")) {
                this.addWaitStepWME((WaitStepWME)w);
            } else if (name.equals("MentalStepWME")) {
                this.addMentalStepWME((MentalStepWME)w);
            } else if (name.equals("PrimitiveStepWME")) {
                this.addPrimitiveStepWME((PrimitiveStepWME)w);
            } else if (name.equals("FailStepWME")) {
                this.addFailStepWME((FailStepWME)w);
            } else if (name.equals("SucceedStepWME")) {
                this.addSucceedStepWME((SucceedStepWME)w);
            } else if (name.equals("CollectionBehaviorWME") || name.equals("ParallelBehaviorWME") || name.equals("SequentialBehaviorWME")) {
                this.addBehaviorWME((BehaviorWME)w);
            }
        }

        public void deleteWME(WME w) {
            String name = WorkingMemory.wmeShortName(w);
            if (name.equals("GoalStepWME")) {
                this.deleteGoalStepWME((GoalStepWME)w);
            } else if (name.equals("WaitStepWME")) {
                this.deleteWaitStepWME((WaitStepWME)w);
            } else if (name.equals("MentalStepWME")) {
                this.deleteMentalStepWME((MentalStepWME)w);
            } else if (name.equals("PrimitiveStepWME")) {
                this.deletePrimitiveStepWME((PrimitiveStepWME)w);
            } else if (name.equals("FailStepWME")) {
                this.deleteFailStepWME((FailStepWME)w);
            } else if (name.equals("SucceedStepWME")) {
                this.deleteSucceedStepWME((SucceedStepWME)w);
            } else if (name.equals("CollectionBehaviorWME") || name.equals("ParallelBehaviorWME") || name.equals("SequentialBehaviorWME")) {
                this.deleteBehaviorWME((BehaviorWME)w);
            }
        }

        public void addGoalStepWME(GoalStepWME w) {
            this.wmeList.add(w);
            this.indexBySignature(w, w.getSignature());
            this.indexByUserProperties(w, w.getAllDefinedProperties());
        }

        public void addWaitStepWME(WaitStepWME w) {
            this.wmeList.add(w);
            this.indexByUserProperties(w, w.getAllDefinedProperties());
        }

        public void addMentalStepWME(MentalStepWME w) {
            this.wmeList.add(w);
            this.indexByUserProperties(w, w.getAllDefinedProperties());
        }

        public void addPrimitiveStepWME(PrimitiveStepWME w) {
            this.wmeList.add(w);
            this.indexByUserProperties(w, w.getAllDefinedProperties());
        }

        public void addFailStepWME(FailStepWME w) {
            this.wmeList.add(w);
            this.indexByUserProperties(w, w.getAllDefinedProperties());
        }

        public void addSucceedStepWME(SucceedStepWME w) {
            this.wmeList.add(w);
            this.indexByUserProperties(w, w.getAllDefinedProperties());
        }

        public void addBehaviorWME(BehaviorWME w) {
            this.wmeList.add(w);
            this.indexBySignature(w, w.getSignature());
            this.indexByUserProperties(w, w.getAllDefinedProperties());
        }

        public void deleteGoalStepWME(GoalStepWME w) {
            this.wmeList.remove(w);
            this.deleteFromSignatureTable(w, w.getSignature());
            this.deleteFromUserPropertiesTable(w, w.getAllDefinedProperties());
        }

        public void deleteWaitStepWME(WaitStepWME w) {
            this.wmeList.remove(w);
            this.deleteFromUserPropertiesTable(w, w.getAllDefinedProperties());
        }

        public void deleteMentalStepWME(MentalStepWME w) {
            this.wmeList.remove(w);
            this.deleteFromUserPropertiesTable(w, w.getAllDefinedProperties());
        }

        public void deletePrimitiveStepWME(PrimitiveStepWME w) {
            this.wmeList.remove(w);
            this.deleteFromUserPropertiesTable(w, w.getAllDefinedProperties());
        }

        public void deleteFailStepWME(FailStepWME w) {
            this.wmeList.remove(w);
            this.deleteFromUserPropertiesTable(w, w.getAllDefinedProperties());
        }

        public void deleteSucceedStepWME(SucceedStepWME w) {
            this.wmeList.remove(w);
            this.deleteFromUserPropertiesTable(w, w.getAllDefinedProperties());
        }

        public void deleteBehaviorWME(BehaviorWME w) {
            this.wmeList.remove(w);
            this.deleteFromSignatureTable(w, w.getSignature());
            this.deleteFromUserPropertiesTable(w, w.getAllDefinedProperties());
        }

        private void indexBySignature(WME w, String signature) {
            LinkedList<WME> sigList = (LinkedList<WME>)this.signatureTable.get(signature);
            if (sigList == null) {
                sigList = new LinkedList<WME>();
                sigList.add(w);
                this.signatureTable.put(signature, sigList);
            } else {
                sigList.add(w);
            }
        }

        private void indexByUserProperties(WME w, List propertyList) {
            for (AblNamedPropertySupport.UserProperty property : propertyList) {
                String propertyName = property.getName();
                LinkedList<WME> indexedPropList = (LinkedList<WME>)this.propertyTable.get(propertyName);
                if (indexedPropList == null) {
                    indexedPropList = new LinkedList<WME>();
                    indexedPropList.add(w);
                    this.propertyTable.put(propertyName, indexedPropList);
                    continue;
                }
                indexedPropList.add(w);
            }
        }

        private void deleteFromSignatureTable(WME w, String signature) {
            List sigList = (List)this.signatureTable.get(signature);
            assert (sigList != null && sigList.size() > 0 && sigList.contains(w));
            sigList.remove(w);
            if (sigList.size() == 0) {
                this.signatureTable.remove(signature);
            }
        }

        private void deleteFromUserPropertiesTable(WME w, List propertyList) {
            for (AblNamedPropertySupport.UserProperty property : propertyList) {
                String propertyName = property.getName();
                List indexedPropList = (List)this.propertyTable.get(propertyName);
                assert (indexedPropList != null && indexedPropList.size() > 0 && indexedPropList.contains(w));
                indexedPropList.remove(w);
            }
        }

        public LinkedList lookupWMEBySignature(String signature) {
            LinkedList list = (LinkedList)this.signatureTable.get(signature);
            if (list == null) {
                list = new LinkedList();
            }
            return list;
        }

        public LinkedList lookupWMEByProperty(String propertyName) {
            LinkedList list = (LinkedList)this.propertyTable.get(propertyName);
            if (list == null) {
                list = new LinkedList();
            }
            return list;
        }

        public LinkedList getWMEList() {
            return this.wmeList;
        }
    }

    class WMTreeNode
    extends DefaultMutableTreeNode {
        private boolean isClassNode;

        WMTreeNode(Object nodeObject, boolean cn) {
            super(nodeObject);
            this.isClassNode = false;
            this.isClassNode = cn;
        }

        WMTreeNode(String nodeObject) {
            super(nodeObject);
            this.isClassNode = false;
        }

        boolean getIsClassNode() {
            return this.isClassNode;
        }
    }
}

