/*
 * Decompiled with CFR 0.152.
 */
package wm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComboBox;
import wm.WME;
import wm.WMEFieldEditor;

public abstract class TimeStampedWME
extends WME
implements Comparable {
    private long timestamp;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("MM.dd.yyyy hh:mm:ss:S a");
    private static final String[] menuItems = new String[]{"Set current time"};

    public TimeStampedWME(long timestamp) {
        this.timestamp = timestamp;
    }

    public TimeStampedWME() {
        this.timestamp = 0L;
    }

    public synchronized long getTimestamp() {
        return this.timestamp;
    }

    public synchronized void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public synchronized String formatTimestamp() {
        return formatter.format(new Date(this.getTimestamp()));
    }

    public WMEFieldEditor _getTimestampEditor() {
        return new TimestampEditor();
    }

    public int compareTo(Object o) {
        TimeStampedWME wmeToCompare = (TimeStampedWME)o;
        if (this.getTimestamp() < wmeToCompare.getTimestamp()) {
            return -1;
        }
        if (this.getTimestamp() > wmeToCompare.getTimestamp()) {
            return 1;
        }
        return 0;
    }

    private class TimestampEditor
    extends JComboBox
    implements WMEFieldEditor {
        TimestampEditor() {
            super(menuItems);
            this.setEditable(true);
            if (TimeStampedWME.this.getTimestamp() != 0L) {
                this.setSelectedItem(TimeStampedWME.this.formatTimestamp());
            } else {
                this.setSelectedItem("");
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TimestampEditor.this.setFieldValue(Long.toString(System.currentTimeMillis()));
                }
            });
        }

        @Override
        public String getFieldValue() {
            try {
                return Long.toString(formatter.parse(this.getSelectedItem().toString()).getTime());
            }
            catch (ParseException e) {
                System.err.println("Parse error: " + e.getMessage() + " in TimestampEditor.getTimeValue(). Returning null.");
                return null;
            }
        }

        @Override
        public void setFieldValue(String s) {
            this.setSelectedItem(formatter.format(new Date(Long.parseLong(s))));
        }
    }
}

