/*
 * Decompiled with CFR 0.152.
 */
package macro;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import macro.SimpleMacroError;
import macro.SimpleMacroException;

public class SimpleMacro {
    public final int maxArguments = 20;
    private static final char macroAppendChar = '@';
    private boolean macroDefined = false;
    private String[] arguments = new String[20];
    private int numberOfArguments = 0;
    private String macroName;
    private String macroBody;
    private static final boolean slashSlashComments = true;
    private static final boolean slashStarComments = true;
    private static final char singleLineCommentChar = '#';

    public SimpleMacro(String macroDefnString) {
        StringReader stringToRead = new StringReader(macroDefnString);
        try {
            StreamTokenizer macroDefnTokens = new StreamTokenizer(stringToRead);
            macroDefnTokens.slashSlashComments(true);
            macroDefnTokens.slashStarComments(true);
            macroDefnTokens.eolIsSignificant(true);
            macroDefnTokens.nextToken();
            if (!macroDefnTokens.sval.equals("definemacro")) {
                throw new SimpleMacroError("Macro " + macroDefnString + " doesn't start with 'definemacro'");
            }
            macroDefnTokens.nextToken();
            this.macroName = macroDefnTokens.sval;
            macroDefnTokens.nextToken();
            if (macroDefnTokens.ttype != 40) {
                throw new SimpleMacroError("Error finding beginning of argument list in " + macroDefnString);
            }
            int previousTokenType = 40;
            macroDefnTokens.nextToken();
            while (macroDefnTokens.ttype != 41) {
                if (macroDefnTokens.ttype != 44 && macroDefnTokens.ttype == -3 && (previousTokenType == 44 || previousTokenType == 40)) {
                    this.arguments[this.numberOfArguments++] = macroDefnTokens.sval;
                    previousTokenType = -3;
                } else if (macroDefnTokens.ttype == 44 && previousTokenType == -3) {
                    previousTokenType = 44;
                } else if (macroDefnTokens.ttype != 41) {
                    throw new SimpleMacroError("Error parsing the argument list of macro " + macroDefnString);
                }
                macroDefnTokens.nextToken();
            }
            StringBuffer macroRead = new StringBuffer();
            int charRead = stringToRead.read();
            while (charRead != -1) {
                macroRead.append((char)charRead);
                charRead = stringToRead.read();
            }
            this.macroBody = macroRead.toString();
            this.macroDefined = true;
        }
        catch (IOException e) {
            throw new SimpleMacroError("IO error occurred while reading macro " + macroDefnString + ". Error: " + e.getMessage());
        }
    }

    public SimpleMacro(File macroDefnFile) {
        FileReader fileToRead = null;
        try {
            try {
                fileToRead = new FileReader(macroDefnFile);
                StreamTokenizer macroDefnTokens = new StreamTokenizer(fileToRead);
                macroDefnTokens.slashSlashComments(true);
                macroDefnTokens.slashStarComments(true);
                macroDefnTokens.eolIsSignificant(true);
                macroDefnTokens.nextToken();
                if (!macroDefnTokens.sval.equals("definemacro")) {
                    throw new SimpleMacroError("Macro definition file " + macroDefnFile.getAbsolutePath() + " doesn't start with 'definemacro'");
                }
                macroDefnTokens.nextToken();
                this.macroName = macroDefnTokens.sval;
                macroDefnTokens.nextToken();
                if (macroDefnTokens.ttype != 40) {
                    throw new SimpleMacroError("Error finding beginning of argument list in " + macroDefnFile.getAbsolutePath());
                }
                int previousTokenType = 40;
                macroDefnTokens.nextToken();
                while (macroDefnTokens.ttype != 41) {
                    if (macroDefnTokens.ttype != 44 && macroDefnTokens.ttype == -3 && (previousTokenType == 44 || previousTokenType == 40)) {
                        this.arguments[this.numberOfArguments++] = macroDefnTokens.sval;
                        previousTokenType = -3;
                    } else if (macroDefnTokens.ttype == 44 && previousTokenType == -3) {
                        previousTokenType = 44;
                    } else if (macroDefnTokens.ttype != 41) {
                        throw new SimpleMacroError("Error parsing the argument list of macro definition file " + macroDefnFile.getAbsolutePath());
                    }
                    macroDefnTokens.nextToken();
                }
                StringBuffer macroRead = new StringBuffer();
                int charRead = fileToRead.read();
                while (charRead != -1) {
                    macroRead.append((char)charRead);
                    charRead = fileToRead.read();
                }
                this.macroBody = macroRead.toString();
                this.macroDefined = true;
            }
            catch (FileNotFoundException e) {
                throw new SimpleMacroError("Macro definition file " + macroDefnFile.getAbsolutePath() + " not found.");
            }
            catch (IOException e) {
                throw new SimpleMacroError("IO error occurred while reading macro definition file " + macroDefnFile.getAbsolutePath() + ". Error: " + e.getMessage());
            }
        }
        finally {
            try {
                if (fileToRead != null) {
                    fileToRead.close();
                }
            }
            catch (IOException e) {
                throw new SimpleMacroError("Error closing macro definition file " + macroDefnFile.getAbsolutePath());
            }
        }
    }

    private int argLookup(String s) {
        int i = 0;
        while (i < this.arguments.length) {
            if (s.equals(this.arguments[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String expand(String[] expansionArgs) throws SimpleMacroException {
        StringReader macroReader = null;
        try {
            if (expansionArgs == null ? this.numberOfArguments != 0 : expansionArgs.length != this.numberOfArguments) {
                throw new SimpleMacroException("The number of expansion arguments for macro " + this.macroName + " does not equal the number of macro arguments.");
            }
            if (!this.macroDefined) {
                throw new SimpleMacroException("Macro not defined.");
            }
            String LINE_SEP = System.getProperty("line.separator");
            StringBuffer expandedMacro = new StringBuffer();
            macroReader = new StringReader(this.macroBody);
            StreamTokenizer macroTokens = new StreamTokenizer(macroReader);
            macroTokens.slashSlashComments(true);
            macroTokens.slashStarComments(true);
            macroTokens.eolIsSignificant(true);
            macroTokens.ordinaryChar(32);
            macroTokens.ordinaryChar(9);
            macroTokens.ordinaryChar(34);
            macroTokens.ordinaryChar(39);
            macroTokens.ordinaryChar(46);
            macroTokens.wordChars(48, 57);
            int argIndex = -1;
            int tokenType = macroTokens.nextToken();
            while (tokenType != -1) {
                if (tokenType == -3) {
                    argIndex = this.argLookup(macroTokens.sval);
                    if (argIndex != -1) {
                        expandedMacro.append(expansionArgs[argIndex]);
                    } else {
                        expandedMacro.append(macroTokens.sval);
                    }
                } else if (tokenType == 10) {
                    expandedMacro.append(LINE_SEP);
                } else if (tokenType == 35) {
                    expandedMacro.append("// ");
                } else {
                    expandedMacro.append((char)macroTokens.ttype);
                }
                tokenType = macroTokens.nextToken();
            }
            int i = 0;
            while (i < expandedMacro.length()) {
                if (expandedMacro.charAt(i) == '@') {
                    expandedMacro.deleteCharAt(i);
                }
                ++i;
            }
            String eol = System.getProperty("line.separator");
            if (expandedMacro.substring(0, eol.length()) == eol) {
                String string = expandedMacro.substring(eol.length(), expandedMacro.length());
                return string;
            }
            String string = expandedMacro.toString();
            return string;
        }
        catch (IOException e) {
            throw new SimpleMacroException("Error occurred while reading tokens during expand of macro " + this.macroName + ". Error: " + e.getMessage());
        }
        finally {
            if (macroReader != null) {
                macroReader.close();
            }
        }
    }

    public String toString() {
        StringWriter tempBuf = new StringWriter();
        PrintWriter tempPrint = new PrintWriter(tempBuf);
        tempPrint.println("Macro name: " + this.macroName);
        tempPrint.print("Arguments: ");
        int i = 0;
        while (i < this.numberOfArguments) {
            tempPrint.print(String.valueOf(this.arguments[i]) + " ");
            ++i;
        }
        tempPrint.println("");
        tempPrint.println("Macro body:");
        tempPrint.print(this.macroBody);
        return tempBuf.toString();
    }
}

