/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.io.StringWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import jd.CodeBlockDescriptor;
import jd.FieldDescriptor;
import jd.JavaDescriptorError;
import jd.MethodArgDescriptor;
import jd.MethodArglistDescriptor;

public class MethodDescriptor
extends CodeBlockDescriptor {
    private LinkedList methodModifiers = new LinkedList();
    private MethodArglistDescriptor methodArguments = new MethodArglistDescriptor();
    private HashSet localVarNames = new HashSet();
    public String methodName;

    public void addModifier(String s) {
        this.methodModifiers.add(s);
    }

    public void addArgument(MethodArgDescriptor a) {
        this.methodArguments.addArgument(a);
    }

    public void addArgument(String argumentType, String argumentName) {
        MethodArgDescriptor a = new MethodArgDescriptor();
        a.argType = argumentType;
        a.argName = argumentName;
        this.methodArguments.addArgument(a);
    }

    public void addLocalVariableDecl(FieldDescriptor field) {
        this.addToBlockBody(field);
        String[] fieldNames = field.getFieldNames();
        int j = 0;
        while (j < fieldNames.length) {
            if (this.localVarNames.contains(fieldNames[j])) {
                throw new JavaDescriptorError("Variable " + fieldNames[j] + " multiply defined in MethodDescriptor " + this.methodName);
            }
            this.localVarNames.add(fieldNames[j]);
            ++j;
        }
    }

    @Override
    public String toString(int nestLevel) {
        this.blockHeader = String.valueOf(this.methodSignatureString()) + " {";
        this.blockFooter = "}";
        return super.toString(nestLevel);
    }

    protected String methodSignatureString() {
        StringWriter tempBuffer = new StringWriter();
        ListIterator iter = this.methodModifiers.listIterator();
        while (iter.hasNext()) {
            tempBuffer.write(String.valueOf((String)iter.next()) + " ");
        }
        tempBuffer.write(this.methodName);
        tempBuffer.write(this.methodArguments.toString());
        return tempBuffer.toString();
    }

    @Override
    public void setBlockHeader(String headerToSet) {
        throw new JavaDescriptorError("setBlockHeader() should not be called on a MethodDescriptor.");
    }

    @Override
    public void setBlockFooter(String footerToSet) {
        throw new JavaDescriptorError("setBlockFooter() should not be called on a MethodDescriptor.");
    }
}

