/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.util.LinkedList;
import jd.CodeStringDescriptor;
import jd.JavaDescriptorError;

public class FieldDescriptor
extends CodeStringDescriptor {
    public String fieldType = null;
    private LinkedList fieldNames = new LinkedList();
    private LinkedList fieldModifiers = new LinkedList();
    public String initializer = null;

    public void addFieldModifier(String s) {
        this.fieldModifiers.add(s.intern());
    }

    public void addFieldModifiers(String[] s) {
        int i = 0;
        while (i < s.length) {
            this.addFieldModifier(s[i].intern());
            ++i;
        }
    }

    public void addFieldName(String s) {
        this.fieldNames.add(s.intern());
    }

    public String[] getFieldNames() {
        Object[] objArray = this.fieldNames.toArray();
        String[] fNames = new String[objArray.length];
        System.arraycopy(objArray, 0, fNames, 0, objArray.length);
        return fNames;
    }

    public int hashCode() {
        int hashValue = this.fieldType.hashCode();
        int i = 0;
        while (i < this.fieldNames.size()) {
            hashValue += this.fieldNames.get(i).hashCode();
            ++i;
        }
        return hashValue;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FieldDescriptor fieldDescriptorToCompare = (FieldDescriptor)obj;
        if (fieldDescriptorToCompare.fieldType != this.fieldType) {
            return false;
        }
        String[] fieldNamesToCompare = fieldDescriptorToCompare.getFieldNames();
        if (fieldNamesToCompare.length != this.fieldNames.size()) {
            return false;
        }
        int i = 0;
        while (i < fieldNamesToCompare.length) {
            int j = 0;
            while (j < this.fieldNames.size()) {
                if (fieldNamesToCompare[i] == (String)this.fieldNames.get(j)) break;
                ++j;
            }
            if (j >= this.fieldNames.size()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String toString(int nestLevel) {
        this.codeString = this.fieldDeclarationString();
        return super.toString(nestLevel);
    }

    protected String fieldDeclarationString() {
        StringBuffer tempBuffer = new StringBuffer();
        tempBuffer.append(FieldDescriptor.delimitedList(this.fieldModifiers.toArray(), " "));
        if (this.fieldModifiers.size() != 0) {
            tempBuffer.append(" ");
        }
        tempBuffer.append(String.valueOf(this.fieldType) + " ");
        tempBuffer.append(FieldDescriptor.delimitedList(this.fieldNames.toArray(), ", "));
        if (this.initializer != null) {
            tempBuffer.append(" = " + this.initializer);
        }
        tempBuffer.append(";");
        return tempBuffer.toString();
    }

    @Override
    public void setCodeString(String codeStringToSet) {
        throw new JavaDescriptorError("setCodeString() should not be called on a FieldDescriptor.");
    }
}

