/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.ListIterator;
import jd.NestableCodeDescriptor;

public class CodeBlockDescriptor
extends NestableCodeDescriptor {
    protected String blockHeader;
    protected String blockFooter;
    protected LinkedList blockBody = new LinkedList();

    public CodeBlockDescriptor() {
        this.blockHeader = null;
        this.blockFooter = null;
    }

    public CodeBlockDescriptor(String headerToSet, String footerToSet) {
        this.blockHeader = headerToSet;
        this.blockFooter = footerToSet;
    }

    public void setBlockHeader(String headerToSet) {
        this.blockHeader = headerToSet;
    }

    public void setBlockFooter(String footerToSet) {
        this.blockFooter = footerToSet;
    }

    public void addToBlockBody(NestableCodeDescriptor n) {
        this.blockBody.add(n);
    }

    public void addToBlockBody(NestableCodeDescriptor[] n) {
        int i = 0;
        while (i < n.length) {
            this.blockBody.add(n[i]);
            ++i;
        }
    }

    @Override
    public String toString(int nestLevel) {
        StringWriter tempBuffer = new StringWriter(1024);
        PrintWriter tempPrinter = new PrintWriter(tempBuffer);
        if (this.blockHeader != null) {
            tempPrinter.print(CodeBlockDescriptor.leadingTabs(nestLevel));
            tempPrinter.println(this.blockHeader);
        }
        ListIterator iter = this.blockBody.listIterator();
        while (iter.hasNext()) {
            NestableCodeDescriptor descriptor = (NestableCodeDescriptor)iter.next();
            if (descriptor.getClass().getName().equals("jd.CodeSequenceDescriptor")) {
                tempPrinter.println(descriptor.toString(nestLevel));
                continue;
            }
            tempPrinter.println(descriptor.toString(nestLevel + 1));
        }
        if (this.blockFooter != null) {
            tempPrinter.print(CodeBlockDescriptor.leadingTabs(nestLevel));
            tempPrinter.println(this.blockFooter);
        }
        return tempBuffer.toString();
    }
}

