/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import jd.BlanklineDescriptor;
import jd.CodeBlockDescriptor;
import jd.CodeStringDescriptor;
import jd.FieldDescriptor;
import jd.JavaDescriptorError;
import jd.MethodDescriptor;
import jd.NestableCodeDescriptor;

public class ClassDescriptor
extends CodeBlockDescriptor {
    public String packageName;
    private LinkedList imports = new LinkedList();
    public String className;
    private LinkedList classModifiers = new LinkedList();
    private LinkedList fieldMembers = new LinkedList();
    private LinkedList methodMembers = new LinkedList();
    private Vector staticBlocks = new Vector();
    public String extendsClass;
    private LinkedList interfaces = new LinkedList();
    private int nestLevel = 0;

    public void addPackageImport(String importPackage) {
        this.imports.add(importPackage);
    }

    public void addField(FieldDescriptor f) {
        this.fieldMembers.add(f);
    }

    public void addField(String[] fieldModifiers, String typeName, String fieldName, String initializer) {
        FieldDescriptor f = new FieldDescriptor();
        f.fieldType = typeName;
        f.addFieldName(fieldName);
        f.addFieldModifiers(fieldModifiers);
        f.initializer = initializer;
        this.fieldMembers.add(f);
    }

    public FieldDescriptor[] getFields() {
        LinkedList<FieldDescriptor> fieldArray = new LinkedList<FieldDescriptor>();
        ListIterator iter = this.fieldMembers.listIterator();
        while (iter.hasNext()) {
            FieldDescriptor currentField = (FieldDescriptor)iter.next();
            String[] fieldNames = currentField.getFieldNames();
            String fieldType = currentField.fieldType;
            FieldDescriptor tempField = new FieldDescriptor();
            int j = 0;
            while (j < fieldNames.length) {
                tempField.fieldType = fieldType;
                tempField.addFieldName(fieldNames[j]);
                ++j;
            }
            fieldArray.add(tempField);
        }
        Object[] objArray = fieldArray.toArray();
        FieldDescriptor[] fdArray = new FieldDescriptor[objArray.length];
        System.arraycopy(objArray, 0, fdArray, 0, objArray.length);
        return fdArray;
    }

    public void addMethod(MethodDescriptor m) {
        this.methodMembers.add(m);
    }

    public void addClassModifier(String s) {
        this.classModifiers.add(s);
    }

    public void addInterface(String s) {
        this.interfaces.add(s);
    }

    public void addStaticBlock(CodeStringDescriptor desc) {
        CodeBlockDescriptor staticBlock = new CodeBlockDescriptor();
        staticBlock.setBlockHeader("static {");
        staticBlock.addToBlockBody(desc);
        staticBlock.setBlockFooter("}");
        this.staticBlocks.add(staticBlock);
    }

    @Override
    public String toString(int nestLevel) {
        StringWriter tempWriter = new StringWriter();
        PrintWriter tempPrinter = new PrintWriter(tempWriter);
        if (this.className == null) {
            throw new JavaDescriptorError("Attempt to call toString(int) on an instance of ClassDescriptor without a specified class name");
        }
        if (this.packageName != null) {
            tempPrinter.println("package " + this.packageName + ";");
            tempPrinter.println();
        }
        if (this.imports.size() != 0) {
            ListIterator iter = this.imports.listIterator();
            while (iter.hasNext()) {
                tempPrinter.println("import " + (String)iter.next() + ";");
            }
            tempPrinter.println();
        }
        tempWriter.write(ClassDescriptor.delimitedList(this.classModifiers.toArray(), " "));
        if (this.classModifiers.size() != 0) {
            tempWriter.write(" ");
        }
        tempWriter.write("class " + this.className);
        if (this.extendsClass != null) {
            tempWriter.write(" extends " + this.extendsClass);
        }
        if (this.interfaces.size() != 0) {
            tempWriter.write(" implements " + ClassDescriptor.delimitedList(this.interfaces.toArray(), ", "));
        }
        tempWriter.write(" {");
        this.blockHeader = tempWriter.toString();
        this.blockFooter = "}";
        this.blockBody.clear();
        this.blockBody.addAll(this.fieldMembers);
        this.blockBody.add(new BlanklineDescriptor());
        this.blockBody.addAll(this.staticBlocks);
        this.blockBody.add(new BlanklineDescriptor());
        this.blockBody.addAll(this.methodMembers);
        return super.toString(nestLevel);
    }

    @Override
    public void setBlockHeader(String headerToSet) {
        throw new JavaDescriptorError("setBlockHeader() should not be called on a ClassDescriptor.");
    }

    @Override
    public void setBlockFooter(String footerToSet) {
        throw new JavaDescriptorError("setBlockFooter() should not be called on a ClassDescriptor.");
    }

    @Override
    public void addToBlockBody(NestableCodeDescriptor n) {
        throw new JavaDescriptorError("addToBlockBody() should not be called on a ClassDescriptor.");
    }

    private void writeToFileHelper(File directory, String codeToWrite) {
        try {
            PrintStream classStream = new PrintStream(new FileOutputStream(new File(directory, String.valueOf(this.className) + ".java")));
            classStream.print(codeToWrite);
            classStream.close();
        }
        catch (IOException e) {
            throw new JavaDescriptorError("Error writing " + this.className + ".java", e);
        }
    }

    public boolean writeToFile(File directory) {
        BufferedReader classReader;
        String newJavaCode = this.toString();
        try {
            classReader = new BufferedReader(new FileReader(new File(directory, String.valueOf(this.className) + ".java")));
        }
        catch (FileNotFoundException e) {
            this.writeToFileHelper(directory, newJavaCode);
            return true;
        }
        StringBuffer javaCode = new StringBuffer(8000);
        try {
            int c = classReader.read();
            while (c != -1) {
                javaCode.append((char)c);
                c = classReader.read();
            }
            classReader.close();
        }
        catch (IOException e) {
            throw new JavaDescriptorError("Error reading " + this.className + ".java", e);
        }
        if (!javaCode.toString().equals(newJavaCode)) {
            this.writeToFileHelper(directory, newJavaCode);
            return true;
        }
        return false;
    }

    public void writeNestedClassToStream(PrintStream stream) {
        this.addClassModifier("static");
        stream.print(this.toString());
    }
}

