/*
 * Decompiled with CFR 0.152.
 */
package eisbot.proxy.wmes.unit;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.Game;
import eisbot.proxy.JNIBWAPI;
import eisbot.proxy.model.Player;
import eisbot.proxy.model.Unit;
import eisbot.proxy.wmes.PlayerWME;
import eisbot.proxy.wmes.UnitTypeWME;
import eisbot.proxy.wmes.unit.AllyUnitWME;
import eisbot.proxy.wmes.unit.EnemyUnitWME;
import eisbot.proxy.wmes.unit.GeyserWME;
import eisbot.proxy.wmes.unit.MineralWME;
import eisbot.proxy.wmes.unit.NeutralEggWME;
import eisbot.proxy.wmes.unit.NeutralUnitWME;
import eisbot.proxy.wmes.unit.PlayerUnitWME;
import eisbot.proxy.wmes.unit.protoss.AssimilatorWME;
import eisbot.proxy.wmes.unit.protoss.CannonWME;
import eisbot.proxy.wmes.unit.protoss.CarrierWME;
import eisbot.proxy.wmes.unit.protoss.CitadelWME;
import eisbot.proxy.wmes.unit.protoss.CyberneticsCoreWME;
import eisbot.proxy.wmes.unit.protoss.DragoonWME;
import eisbot.proxy.wmes.unit.protoss.FleetBeaconWME;
import eisbot.proxy.wmes.unit.protoss.ForgeWME;
import eisbot.proxy.wmes.unit.protoss.GatewayWME;
import eisbot.proxy.wmes.unit.protoss.NexusWME;
import eisbot.proxy.wmes.unit.protoss.ObservatoryWME;
import eisbot.proxy.wmes.unit.protoss.ObserverWME;
import eisbot.proxy.wmes.unit.protoss.ProbeWME;
import eisbot.proxy.wmes.unit.protoss.PylonWME;
import eisbot.proxy.wmes.unit.protoss.RoboticsFacilityWME;
import eisbot.proxy.wmes.unit.protoss.ScoutWME;
import eisbot.proxy.wmes.unit.protoss.StargateWME;
import eisbot.proxy.wmes.unit.protoss.ZealotWME;
import java.util.ArrayList;
import java.util.HashMap;
import wm.WME;

public class UnitWME
extends WME {
    protected int ID = -1;
    private int playerID;
    protected UnitTypeWME type;
    int width;
    int height;
    protected int x;
    private int realX;
    private int realCenterX;
    protected int y;
    private int realY;
    private int realCenterY;
    private int hitPoints;
    private int shields;
    private int energy;
    private int orderTimer;
    protected int mineCount = 0;
    private int buildTimer;
    private int trainTimer;
    private int researchTimer;
    private int upgradeTimer;
    int target;
    int orderTarget;
    int targetX;
    int targetY;
    int targetRealX;
    int targetRealY;
    boolean active = false;
    boolean burrowed;
    boolean cloaked;
    boolean powered;
    int interceptorCount;
    int attackTargetX;
    int attackTargetY;
    int spawnFrame = 0;
    int lastMoved = 0;
    private int groundCooldown;
    private int airCooldown;
    private int order;
    private boolean lifted;
    private int resources;
    private int addonID;

    public static ArrayList<UnitWME> getUnits(Game game, JNIBWAPI bwapi, HashMap<Integer, UnitTypeWME> types, int playerID, PlayerWME[] players1) {
        ArrayList<UnitWME> units = new ArrayList<UnitWME>();
        for (Unit u : bwapi.getAllUnits()) {
            int ID = u.getID();
            UnitWME unit = game.getUnitByID(ID);
            int pID = u.getPlayerID();
            int type = u.getTypeID();
            Player player = bwapi.getPlayer(pID);
            boolean newUnit = false;
            if (unit != null && unit.getTypeID() != type) {
                unit = null;
            }
            if (unit == null) {
                if (player.isSelf()) {
                    newUnit = true;
                    switch (type) {
                        case 157: {
                            unit = new AssimilatorWME();
                            break;
                        }
                        case 162: {
                            unit = new CannonWME();
                            break;
                        }
                        case 164: {
                            unit = new CyberneticsCoreWME();
                            break;
                        }
                        case 66: {
                            unit = new DragoonWME();
                            break;
                        }
                        case 166: {
                            unit = new ForgeWME();
                            break;
                        }
                        case 160: {
                            unit = new GatewayWME();
                            break;
                        }
                        case 154: {
                            for (UnitWME nexus : game.getUnits()) {
                                if (!(nexus instanceof NexusWME)) continue;
                                ((NexusWME)nexus).clearNewest();
                            }
                            unit = new NexusWME();
                            ((NexusWME)unit).setNewest();
                            break;
                        }
                        case 64: {
                            unit = new ProbeWME();
                            break;
                        }
                        case 156: {
                            unit = new PylonWME();
                            break;
                        }
                        case 65: {
                            unit = new ZealotWME();
                            break;
                        }
                        case 155: {
                            unit = new RoboticsFacilityWME();
                            break;
                        }
                        case 159: {
                            unit = new ObservatoryWME();
                            break;
                        }
                        case 84: {
                            unit = new ObserverWME();
                            break;
                        }
                        case 163: {
                            unit = new CitadelWME();
                            break;
                        }
                        case 167: {
                            unit = new StargateWME();
                            break;
                        }
                        case 169: {
                            unit = new FleetBeaconWME();
                            break;
                        }
                        case 72: {
                            unit = new CarrierWME();
                            break;
                        }
                        case 70: {
                            unit = new ScoutWME();
                            break;
                        }
                        default: {
                            unit = new PlayerUnitWME();
                            break;
                        }
                    }
                } else if (type == UnitTypeWME.UnitType.Resource_Mineral_Field.ordinal()) {
                    unit = new MineralWME();
                } else if (type == UnitTypeWME.UnitType.Resource_Vespene_Geyser.ordinal()) {
                    unit = new GeyserWME();
                } else if (player.isEnemy()) {
                    unit = new EnemyUnitWME();
                } else if (player.isAlly()) {
                    unit = new AllyUnitWME();
                } else if (player.isNeutral()) {
                    unit = new NeutralUnitWME();
                    if (type == 36) {
                        unit = new NeutralEggWME();
                    }
                }
            }
            unit.ID = ID;
            unit.playerID = pID;
            unit.type = types.get(type);
            unit.realX = u.getX() - bwapi.getUnitType(type).getDimensionLeft() - 1;
            unit.realY = u.getY() - bwapi.getUnitType(type).getDimensionUp() - 1;
            unit.realCenterX = u.getX();
            unit.realCenterY = u.getY();
            unit.hitPoints = u.getHitPoints();
            unit.shields = u.getShield();
            unit.energy = u.getEnergy();
            unit.buildTimer = u.getRemainingBuildTimer();
            unit.trainTimer = u.getRemainingTrainTime();
            unit.researchTimer = u.getRemainingResearchTime();
            unit.upgradeTimer = u.getRemainingUpgradeTime();
            unit.orderTimer = u.getOrderTimer();
            unit.order = u.getOrderID();
            unit.lifted = u.isLifted();
            unit.resources = u.getResources();
            unit.addonID = u.getAddOnID();
            unit.mineCount = u.getSpiderMineCount();
            unit.target = u.getTargetUnitID();
            unit.orderTarget = u.getOrderTargetID();
            if (unit.type != null) {
                units.add(unit);
            }
            unit.active = u.getRemainingBuildTimer() == 0 && u.isCompleted();
            unit.groundCooldown = u.getGroundWeaponCooldown();
            unit.airCooldown = u.getAirWeaponCooldown();
            unit.targetRealX = u.getTargetX();
            unit.targetX = u.getTargetX() / 32;
            unit.targetRealY = u.getTargetY();
            unit.targetY = u.getTargetY() / 32;
            unit.burrowed = u.isBurrowed();
            unit.cloaked = u.isCloaked();
            unit.powered = !u.isUnpowered();
            unit.interceptorCount = u.getInterceptorCount();
            unit.width = 2 * bwapi.getUnitType(type).getDimensionLeft();
            unit.height = 2 * bwapi.getUnitType(type).getDimensionUp();
            if (unit.getIsBuilding() || unit.getIsResource()) {
                unit.x = (unit.realX + 1) / 32;
                unit.y = (unit.realY + 1) / 32;
            } else {
                unit.x = unit.realCenterX / 32;
                unit.y = unit.realCenterY / 32;
            }
            if (!newUnit || !(unit instanceof PlayerUnitWME)) continue;
            ((PlayerUnitWME)unit).setPreviousHealth();
        }
        for (NeutralUnitWME unit : game.getNeutralUnits()) {
            if (!unit.isBlockage()) continue;
            units.add(unit);
        }
        return units;
    }

    public int getInterceptorCount() {
        return this.interceptorCount;
    }

    public int getAttackTargetX() {
        return this.attackTargetX;
    }

    public void setAttackTargetX(int attackTargetX) {
        this.attackTargetX = attackTargetX;
    }

    public int getAttackTargetY() {
        return this.attackTargetY;
    }

    public void setAttackTargetY(int attackTargetY) {
        this.attackTargetY = attackTargetY;
    }

    public int getLastMoved() {
        return this.lastMoved;
    }

    public int getSpawnFrame() {
        return this.spawnFrame;
    }

    public void setSpawnFrame(int spawnFrame) {
        this.spawnFrame = spawnFrame;
    }

    public int getNearestEnemy() {
        double closest = Double.MAX_VALUE;
        for (EnemyUnitWME enemy : ABLStarCraftBot.getGame().getEnemyUnits()) {
            double dx = Math.abs(enemy.x - this.x);
            double dy = Math.abs(enemy.y - this.y);
            double dist = Math.sqrt(dx * dx + dy * dy);
            double x = Math.abs(2);
            if (!(dist < closest)) continue;
            closest = dist;
        }
        return (int)closest;
    }

    public void setLastMoved(int frame) {
        this.lastMoved = frame;
    }

    public boolean getPowered() {
        return this.powered;
    }

    public boolean getBurrowedOrCloaked() {
        return this.burrowed || this.cloaked;
    }

    public boolean getBurrowed() {
        return this.burrowed;
    }

    public boolean getCloaked() {
        return this.cloaked;
    }

    public int getTargetX() {
        return this.targetX;
    }

    public int getTargetRealX() {
        return this.targetRealX;
    }

    public int getTargetY() {
        return this.targetY;
    }

    public int getTargetRealY() {
        return this.targetRealY;
    }

    public int getGroundCooldown() {
        return this.groundCooldown;
    }

    public int getAirCooldown() {
        return this.airCooldown;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean getIsSpellCaster() {
        return this.type.isSpellCaster();
    }

    public int getTarget() {
        return this.target;
    }

    public int getOrderTarget() {
        return this.orderTarget;
    }

    public boolean getIsResource() {
        return this.type != null ? this.type.getIsResource() : false;
    }

    public boolean getIsBuilding() {
        return this.type != null ? this.type.getIsBuilding() : false;
    }

    public int getMineCount() {
        return this.mineCount;
    }

    public int getAddonID() {
        return this.addonID;
    }

    public boolean getIsBuilt() {
        return this.buildTimer == 0;
    }

    public double distance(double x, double y) {
        return Math.sqrt(Math.pow((double)this.x - x, 2.0) + Math.pow((double)this.y - y, 2.0));
    }

    public double distance(UnitWME unit) {
        double dx = unit.x - this.x;
        double dy = unit.y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public int getID() {
        return this.ID;
    }

    public boolean getIsWorker() {
        return this.type.isWorker();
    }

    public boolean getIsCenter() {
        return this.type.isCenter();
    }

    public boolean getIsFarm() {
        return this.type.isFarm();
    }

    public boolean getIsAirborne() {
        return this.getIsFlyer() || this.getIsBuilding() && this.getIsLifted();
    }

    public boolean getIsFlyer() {
        return this.type.isFlyer();
    }

    public boolean getIsLifted() {
        return this.lifted;
    }

    public int getPlayerID() {
        return this.playerID;
    }

    public UnitTypeWME getType() {
        return this.type;
    }

    public int getTypeID() {
        return this.type != null ? this.type.getId() : -1;
    }

    public int getX() {
        return this.x;
    }

    public int getRealX() {
        return this.realX;
    }

    public int getRealCenterX() {
        return this.realCenterX;
    }

    public int getY() {
        return this.y;
    }

    public int getRealY() {
        return this.realY;
    }

    public int getRealCenterY() {
        return this.realCenterY;
    }

    public int getHitPoints() {
        return this.hitPoints;
    }

    public int getShields() {
        return this.shields;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrderTimer() {
        return this.orderTimer;
    }

    public int getBuildTimer() {
        return this.buildTimer;
    }

    public int getTrainTimer() {
        return this.trainTimer;
    }

    public int getResearchTimer() {
        return this.researchTimer;
    }

    public int getUpgradeTimer() {
        return this.upgradeTimer;
    }

    public int getResources() {
        return this.resources;
    }

    @Override
    public String toString() {
        return "ID:" + this.ID + " player:" + this.playerID + " type:" + this.type.getName() + " x:" + this.x + " y:" + this.y + " hitPoints:" + this.hitPoints + " shields:" + this.shields + " enemy:" + this.energy + " orderTimer:" + this.orderTimer + " order:" + this.order + " resource:" + this.resources;
    }
}

