/*
 * Decompiled with CFR 0.152.
 */
package eisbot.proxy.wmes.unit;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.wmes.AllMineralsWME;
import eisbot.proxy.wmes.unit.UnitWME;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;

public class PlayerUnitWME
extends UnitWME {
    int task = WorkerTask.IDLE.ordinal();
    int rally;
    int squadron;
    int supportUnit;
    boolean spawnedGoal;
    boolean cantProduce;
    boolean hasTask;
    boolean hasDanced;
    private PlayerUnitWME nexus;
    private HashSet<Integer> workers = new HashSet();
    private int targetWorkers = 3;
    int previousHealth;

    public void setPreviousHealth() {
        this.previousHealth = this.getHealth();
    }

    public int getPreviousHealth() {
        return this.previousHealth;
    }

    public int getHealth() {
        return this.getHitPoints() + this.getShields();
    }

    public boolean getTakenDamage() {
        return this.getHealth() < this.getPreviousHealth();
    }

    public boolean getTakenHeavyDamage() {
        return this.getHealth() < this.getPreviousHealth() - 15;
    }

    public int getTask() {
        return this.task;
    }

    public PlayerUnitWME getNexus() {
        return this.nexus;
    }

    public void setNexus(PlayerUnitWME nexus) {
        this.nexus = nexus;
    }

    public int getTargetWorkers() {
        return this.targetWorkers;
    }

    public void setTargetWorkers(int targetWorkers) {
        this.targetWorkers = targetWorkers;
    }

    public int getNumWorkers() {
        return this.workers.size();
    }

    public void freeWorker(int workerID) {
        this.workers.remove(workerID);
    }

    public boolean getIsAssigned(int workerID) {
        return this.workers.contains(workerID);
    }

    public void addWorker(int workerID) {
        this.workers.add(workerID);
    }

    public ArrayList<Integer> getWorkerList() {
        return new ArrayList<Integer>(this.workers);
    }

    public void setTask(int status) {
        this.task = status;
    }

    public void setRally() {
        ++this.rally;
    }

    public boolean getRallySet() {
        return this.rally > 2;
    }

    public int getSquadronID() {
        return this.squadron;
    }

    public void setSquadronID(int squadronID) {
        this.squadron = squadronID;
    }

    public int getSupportUnit() {
        return this.supportUnit;
    }

    public void setSupportUnit(int supportUnit) {
        this.supportUnit = supportUnit;
    }

    public boolean getSpawnedGoal() {
        return this.spawnedGoal;
    }

    public void spawnedGoal() {
        this.spawnedGoal = true;
    }

    public boolean getHasTask() {
        return this.hasTask;
    }

    public void hasTask() {
        this.hasTask = true;
    }

    public boolean getHasDanced() {
        return this.hasDanced;
    }

    public void hasDanced() {
        this.hasDanced = true;
    }

    public void clearTask() {
        this.hasDanced = false;
    }

    public void cantProduce() {
        this.cantProduce = true;
    }

    public boolean getCanProduce() {
        return !this.cantProduce;
    }

    public int getMiningWorkers() {
        LinkedList wmes = ABLStarCraftBot.getBehavingEntity().lookupWME("AllMineralsWME");
        if (wmes.isEmpty()) {
            return 0;
        }
        AllMineralsWME minerals = (AllMineralsWME)wmes.get(0);
        return minerals.getNumWorkers(this.ID);
    }

    public double getSaturation() {
        LinkedList wmes = ABLStarCraftBot.getBehavingEntity().lookupWME("AllMineralsWME");
        if (wmes.isEmpty()) {
            return 0.0;
        }
        AllMineralsWME minerals = (AllMineralsWME)wmes.get(0);
        return minerals.getSaturation(this.ID);
    }

    public boolean getSaturated() {
        return this.getSaturation() >= 1.0;
    }

    public static enum FighterTask {
        IDLE,
        GUARD,
        ATTACK,
        FLEE,
        REGROUP,
        GATHER,
        EGG;

    }

    public static enum WorkerTask {
        IDLE,
        MINING,
        GAS,
        CONSTRUCTING,
        SCOUTING,
        DEFEND;

    }
}

