/*
 * Decompiled with CFR 0.152.
 */
package eisbot.proxy.wmes;

import eisbot.proxy.JNIBWAPI;
import eisbot.proxy.model.Region;
import eisbot.proxy.wmes.ChokePointWME;
import eisbot.proxy.wmes.MapWME;
import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;
import wm.WME;

public class RegionWME
extends WME {
    private int centerX;
    private int centerY;
    private int id;
    private ArrayList<Point> points = new ArrayList();
    private Polygon polygon;
    private int numPoints;
    private int[] x;
    private int[] y;
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;
    private int searchDistance = -1;
    private WME searchTarget = null;
    private ChokePointWME next = null;
    private List<ChokePointWME> chokePoints = new ArrayList<ChokePointWME>();

    public static ArrayList<RegionWME> getRegions(MapWME map, JNIBWAPI bwapi) {
        ArrayList<RegionWME> locations = new ArrayList<RegionWME>();
        for (Region r : bwapi.getMap().getRegions()) {
            RegionWME region = new RegionWME();
            region.id = r.getID();
            region.centerX = r.getCenterX();
            region.centerY = r.getCenterY();
            region.numPoints = r.getCoordinates().length / 2;
            region.x = new int[region.numPoints];
            region.y = new int[region.numPoints];
            region.xmax = 0;
            region.ymax = 0;
            region.xmin = Integer.MAX_VALUE;
            region.ymin = Integer.MAX_VALUE;
            int i = 0;
            while (i < region.numPoints) {
                region.x[i] = r.getCoordinates()[2 * i];
                region.y[i] = r.getCoordinates()[2 * i + 1];
                region.points.add(new Point(region.x[i], region.y[i]));
                if (region.x[i] < region.xmin) {
                    region.xmin = region.x[i];
                }
                if (region.x[i] > region.xmax) {
                    region.xmax = region.x[i];
                }
                if (region.y[i] < region.ymin) {
                    region.ymin = region.y[i];
                }
                if (region.y[i] > region.ymax) {
                    region.ymax = region.y[i];
                }
                ++i;
            }
            region.x[region.x.length - 1] = region.x[0];
            region.y[region.y.length - 1] = region.y[0];
            region.polygon = new Polygon(region.x, region.y, region.numPoints);
            locations.add(region);
        }
        return locations;
    }

    public boolean contains(int realX, int realY) {
        return this.polygon.contains(new Point(realX, realY));
    }

    public ArrayList<Point> getPoints() {
        return this.points;
    }

    public int getCenterX() {
        return this.centerX / 32;
    }

    public int getCenterY() {
        return this.centerY / 32;
    }

    public List<ChokePointWME> getChokePoints() {
        return this.chokePoints;
    }

    public int getMaxTileX() {
        return this.xmax / 32;
    }

    public int getMinTileX() {
        return this.xmin / 32;
    }

    public int getMaxTileY() {
        return this.ymax / 32;
    }

    public int getMinTileY() {
        return this.ymin / 32;
    }

    public int getID() {
        return this.id;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public int[] getPointsX() {
        return this.x;
    }

    public int[] getPointsY() {
        return this.y;
    }

    public int getRealCenterX() {
        return this.centerX;
    }

    public int getRealCenterY() {
        return this.centerY;
    }
}

