/*
 * Decompiled with CFR 0.152.
 */
package eisbot.proxy.wmes;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.StarCraftConstants;
import eisbot.proxy.JNIBWAPI;
import eisbot.proxy.model.Player;
import eisbot.proxy.wmes.BaseLocationWME;
import eisbot.proxy.wmes.ChokePointWME;
import eisbot.proxy.wmes.StartingLocationWME;
import eisbot.proxy.wmes.TechTypeWME;
import eisbot.proxy.wmes.UnitTypeWME;
import eisbot.proxy.wmes.UpgradeTypeWME;
import eisbot.proxy.wmes.unit.UnitWME;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import wm.WME;

public class PlayerWME
extends WME {
    private int playerID;
    private int minerals;
    private int mineralHold;
    private int gas;
    private int gasHold;
    private int supplyUsed;
    private int supplyTotal;
    private String name;
    private StarCraftConstants.Race race;
    private int raceID;
    private int type;
    private boolean ally;
    private boolean[] hasResearched = new boolean[47];
    private boolean[] isResearching = new boolean[47];
    private int[] upgradeLevel = new int[63];
    private boolean[] isUpgrading = new boolean[63];

    public static ArrayList<PlayerWME> getPlayers(JNIBWAPI bwapi) {
        ArrayList<PlayerWME> players = new ArrayList<PlayerWME>();
        for (Player p : bwapi.getPlayers()) {
            PlayerWME player = new PlayerWME();
            player.playerID = p.getID();
            player.raceID = p.getRaceID();
            player.race = StarCraftConstants.Race.values()[player.raceID];
            player.name = "Player:" + p.getID();
            player.type = p.getTypeID();
            player.ally = p.isAlly();
            players.add(player);
        }
        return players;
    }

    public void update(JNIBWAPI bwapi) {
        this.minerals = bwapi.getSelf().getMinerals();
        this.gas = bwapi.getSelf().getGas();
        this.supplyUsed = bwapi.getSelf().getSupplyUsed();
        this.supplyTotal = bwapi.getSelf().getSupplyTotal();
        int index = 0;
        Object[] objectArray = bwapi.getSelf().getUpgradeLevels();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            int level = objectArray[n2];
            this.upgradeLevel[index++] = level;
            ++n2;
        }
        index = 0;
        boolean[] blArray = bwapi.getSelf().getUpgradesInProgress();
        objectArray = blArray;
        n = blArray.length;
        n2 = 0;
        while (n2 < n) {
            int upgrading = objectArray[n2];
            this.isUpgrading[index++] = upgrading;
            ++n2;
        }
        index = 0;
        boolean[] blArray2 = bwapi.getSelf().getResearchCompleted();
        objectArray = blArray2;
        n = blArray2.length;
        n2 = 0;
        while (n2 < n) {
            int researched = objectArray[n2];
            this.hasResearched[index++] = researched;
            ++n2;
        }
        index = 0;
        boolean[] blArray3 = bwapi.getSelf().getResearchInProgress();
        objectArray = blArray3;
        n = blArray3.length;
        n2 = 0;
        while (n2 < n) {
            int researching = objectArray[n2];
            this.isResearching[index++] = researching;
            ++n2;
        }
    }

    public int getNumBuildings() {
        int count = 0;
        for (UnitWME unit : ABLStarCraftBot.getGame().getUnits()) {
            if (unit.getPlayerID() != this.playerID || !unit.getIsBuilding()) continue;
            ++count;
        }
        return count;
    }

    public int getProtossArmySize() {
        int count = 0;
        for (UnitWME unit : ABLStarCraftBot.getGame().getUnits()) {
            if (unit.getPlayerID() != this.playerID || unit.getTypeID() != 65 && unit.getTypeID() != 66 && unit.getTypeID() != 67 && unit.getTypeID() != 61) continue;
            ++count;
        }
        return count;
    }

    public Point getRandomPylon() {
        ArrayList<UnitWME> pylons = new ArrayList<UnitWME>();
        for (UnitWME unit : ABLStarCraftBot.getGame().getUnits()) {
            if (unit.getPlayerID() != this.playerID || unit.getTypeID() != 156) continue;
            pylons.add(unit);
        }
        Collections.shuffle(pylons);
        if (pylons.size() > 0) {
            return new Point(((UnitWME)pylons.get(0)).getX(), ((UnitWME)pylons.get(0)).getY());
        }
        return null;
    }

    public boolean canAffordTechType(int typeID) {
        TechTypeWME type = TechTypeWME.getType(typeID);
        return this.minerals >= type.getMineralsCost() && this.gas > -type.getGasCost();
    }

    public boolean canAffordUpgradeType(int typeID) {
        UpgradeTypeWME type = UpgradeTypeWME.getType(typeID);
        return this.minerals >= type.getMineralsBase() && this.gas > -type.getGasBase();
    }

    public boolean[] getResearched() {
        return this.hasResearched;
    }

    public int[] getUpgrades() {
        return this.upgradeLevel;
    }

    public int upgradeLevel(UpgradeTypeWME.UpgradeType type) {
        return this.upgradeLevel[type.ordinal()];
    }

    public boolean isUpgrading(UpgradeTypeWME.UpgradeType type) {
        return this.isUpgrading[type.ordinal()];
    }

    public boolean hasResearched(TechTypeWME.TechType type) {
        return this.hasResearched[type.ordinal()];
    }

    public boolean isResearching(TechTypeWME.TechType type) {
        return this.isResearching[type.ordinal()];
    }

    public boolean getUpgradingVehicleWeapons() {
        return this.isUpgrading[UpgradeTypeWME.UpgradeType.Terran_Vehicle_Weapons.ordinal()];
    }

    public int getVehicleWeaponsLevel() {
        return this.upgradeLevel[UpgradeTypeWME.UpgradeType.Terran_Vehicle_Weapons.ordinal()];
    }

    public boolean getUpgradingVehicleArmor() {
        return this.isUpgrading[UpgradeTypeWME.UpgradeType.Terran_Vehicle_Plating.ordinal()];
    }

    public int getVehicleArmorLevel() {
        return this.upgradeLevel[UpgradeTypeWME.UpgradeType.Terran_Vehicle_Plating.ordinal()];
    }

    public boolean getIsResearchingSiege() {
        return this.isResearching[TechTypeWME.TechType.Tank_Siege_Mode.ordinal()];
    }

    public boolean getHasResearchedSiege() {
        return this.hasResearched[TechTypeWME.TechType.Tank_Siege_Mode.ordinal()];
    }

    public boolean getIsResearchingMines() {
        return this.isResearching[TechTypeWME.TechType.Spider_Mines.ordinal()];
    }

    public boolean getHasResearchedMines() {
        return this.hasResearched[TechTypeWME.TechType.Spider_Mines.ordinal()];
    }

    public boolean getUpgradedDragoonRange() {
        return this.upgradeLevel[UpgradeTypeWME.UpgradeType.Singularity_Charge.ordinal()] > 0;
    }

    public boolean getUpgradingDragoonRange() {
        return this.isUpgrading[UpgradeTypeWME.UpgradeType.Singularity_Charge.ordinal()];
    }

    public boolean getUpgradedCarrierCapacity() {
        return this.upgradeLevel[UpgradeTypeWME.UpgradeType.Carrier_Capacity.ordinal()] > 0;
    }

    public boolean getUpgradingCarrierCapacity() {
        return this.isUpgrading[UpgradeTypeWME.UpgradeType.Carrier_Capacity.ordinal()];
    }

    public boolean getUpgradedZealotLegs() {
        return this.upgradeLevel[UpgradeTypeWME.UpgradeType.Leg_Enhancements.ordinal()] > 0;
    }

    public boolean getUpgradingZealotLegs() {
        return this.isUpgrading[UpgradeTypeWME.UpgradeType.Leg_Enhancements.ordinal()];
    }

    public int getWeaponLevel() {
        return this.upgradeLevel[UpgradeTypeWME.UpgradeType.Protoss_Ground_Weapons.ordinal()];
    }

    public boolean getUpgradingWeapons() {
        return this.isUpgrading[UpgradeTypeWME.UpgradeType.Protoss_Ground_Weapons.ordinal()];
    }

    public int getArmorLevel() {
        return this.upgradeLevel[UpgradeTypeWME.UpgradeType.Protoss_Armor.ordinal()];
    }

    public boolean getUpgradingArmor() {
        return this.isUpgrading[UpgradeTypeWME.UpgradeType.Protoss_Armor.ordinal()];
    }

    public boolean isAlly() {
        return this.ally;
    }

    public int getMinerals() {
        return this.minerals - this.mineralHold;
    }

    public int getGas() {
        return this.gas - this.gasHold;
    }

    public void addResourceHold(int minerals, int gas) {
        this.mineralHold += minerals;
        this.gasHold += gas;
    }

    public void removeResourceHold(int minerals, int gas) {
        this.mineralHold -= minerals;
        this.gasHold -= gas;
    }

    public int getSupplyUsed() {
        return this.supplyUsed;
    }

    public int getSupplyTotal() {
        return this.supplyTotal;
    }

    public int getPlayerID() {
        return this.playerID;
    }

    public String getRace() {
        return this.race.toString();
    }

    public StarCraftConstants.Race getPlayerRace() {
        return this.race;
    }

    public int getRaceID() {
        return this.raceID;
    }

    public Point getExpoLocation(int tileX, int tileY) {
        double distance = Double.MAX_VALUE;
        int x = 0;
        int y = 0;
        for (ChokePointWME location : ABLStarCraftBot.getGame().getChokePoints()) {
            int dy;
            int dx = tileX - location.getX() / 32;
            double d = Math.sqrt(dx * dx + (dy = tileY - location.getY() / 32) * dy);
            if (!(d < distance)) continue;
            distance = d;
            x = location.getX() / 32;
            y = location.getY() / 32;
        }
        distance = Double.MAX_VALUE;
        Point closest = null;
        for (BaseLocationWME location : ABLStarCraftBot.getGame().getBaseLocations()) {
            int dy;
            int dx = x - location.getX();
            double d = Math.sqrt(dx * dx + (dy = y - location.getY()) * dy);
            if (!(d < distance)) continue;
            distance = d;
            closest = new Point(location.getX(), location.getY());
        }
        return closest;
    }

    public ArrayList<UnitWME> getUnits() {
        ArrayList<UnitWME> myUnits = new ArrayList<UnitWME>();
        ArrayList<UnitWME> allUnits = ABLStarCraftBot.getGame().getUnits();
        for (UnitWME unit : allUnits) {
            if (unit.getPlayerID() != this.playerID) continue;
            myUnits.add(unit);
        }
        return myUnits;
    }

    public int getNumObservers() {
        int count = 0;
        ArrayList<UnitWME> allUnits = ABLStarCraftBot.getGame().getUnits();
        for (UnitWME unit : allUnits) {
            if (unit.getPlayerID() != this.playerID || !unit.getType().equals(UnitTypeWME.Protoss_Observer)) continue;
            ++count;
        }
        return count;
    }

    public StartingLocationWME getStartingLocation() {
        ArrayList<UnitWME> playerUnits = this.getUnits();
        ArrayList<StartingLocationWME> startingLocations = ABLStarCraftBot.getGame().getStartingLocations();
        for (UnitWME unit : playerUnits) {
            if (!unit.getIsCenter()) continue;
            int i = 0;
            for (StartingLocationWME start : startingLocations) {
                if (start.getX() == unit.getX() && start.getY() == unit.getY()) {
                    return start;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "mins:" + this.minerals + " gas:" + this.gas + " supplyUsed:" + this.supplyUsed + " supplyTotal:" + this.supplyTotal;
    }
}

