/*
 * Decompiled with CFR 0.152.
 */
package eisbot.proxy.wmes;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.Game;
import eisbot.abl.StarCraftConstants;
import eisbot.proxy.JNIBWAPI;
import eisbot.proxy.filter.ParticleWME;
import eisbot.proxy.types.UnitType;
import eisbot.proxy.wmes.BaseLocationWME;
import eisbot.proxy.wmes.ChokePointWME;
import eisbot.proxy.wmes.RegionWME;
import eisbot.proxy.wmes.StartingLocationWME;
import eisbot.proxy.wmes.UnitTypeWME;
import eisbot.proxy.wmes.unit.GeyserWME;
import eisbot.proxy.wmes.unit.MineralWME;
import eisbot.proxy.wmes.unit.PlayerUnitWME;
import eisbot.proxy.wmes.unit.UnitWME;
import eisbot.proxy.wmes.unit.protoss.GroundUnitWME;
import eisbot.proxy.wmes.unit.protoss.NexusWME;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeMap;
import wm.WME;

public class MapWME
extends WME {
    int buildingX = 0;
    int buildingY = 0;
    LinkedList<Point> scoutLocations = new LinkedList();
    LinkedList<Point> startLocations = new LinkedList();
    private String mapName;
    private int mapWidth;
    private int mapHeight;
    private int[][] height;
    private boolean[][] buildable;
    private boolean[][] walkable;
    private int leaderX;
    private int leaderY;
    private long lastInvoked;

    public void drawLocations(JNIBWAPI bwapi, Game game, int drawBuildLocations, boolean drawPylons) {
        Point location2;
        int tileWidth = 4;
        int tileHeight = 3;
        if (drawBuildLocations > 1) {
            tileHeight = 2;
        }
        if (drawBuildLocations == 2) {
            tileWidth = 3;
        }
        if (drawBuildLocations == 3) {
            tileWidth = 2;
        }
        if (drawPylons) {
            ArrayList<Point> buildLocations = game.getMap().getBuildLocations(game, tileWidth, tileHeight, -1);
            for (Point location2 : buildLocations) {
                bwapi.drawBox(location2.x * 32, location2.y * 32, (location2.x + tileWidth) * 32, (location2.y + tileHeight) * 32, 133, false, false);
            }
        }
        ArrayList<Point> expandLocations = game.getMap().getExpansionLocations(game, false);
        for (Point location2 : expandLocations) {
            bwapi.drawBox(location2.x * 32, location2.y * 32, (location2.x + 4) * 32, (location2.y + 3) * 32, 153, false, false);
        }
        location2 = game.getMap().getNextExpansion(game, true);
        if (location2 != null) {
            bwapi.drawBox(location2.x * 32, location2.y * 32, (location2.x + 4) * 32, (location2.y + 3) * 32, 72 + (int)(Math.random() * 32.0), false, false);
        }
        if ((location2 = game.getMap().getNextGeyser(game)) != null) {
            bwapi.drawBox(location2.x * 32, location2.y * 32, (location2.x + 4) * 32, (location2.y + 2) * 32, 55 + (int)(Math.random() * 2.0), false, false);
        }
        for (UnitWME expo : this.getExpos(game)) {
            ArrayList<Point> pylons = game.getMap().getPylonChokepoint(game, expo, -1);
            for (Point pLocation : pylons) {
                bwapi.drawBox(pLocation.x * 32, pLocation.y * 32, (pLocation.x + 2) * 32, (pLocation.y + 2) * 32, 16 + (int)(Math.random() * 2.0), false, false);
            }
            pylons = game.getMap().getFirstPylons(game, expo, -1);
            for (Point pLocation : pylons) {
                bwapi.drawBox(pLocation.x * 32, pLocation.y * 32, (pLocation.x + 2) * 32, (pLocation.y + 2) * 32, 32 + (int)(Math.random() * 2.0), false, false);
            }
            pylons = game.getMap().getDefensePylons(game, expo, -1);
            for (Point pLocation : pylons) {
                bwapi.drawBox(pLocation.x * 32, pLocation.y * 32, (pLocation.x + 2) * 32, (pLocation.y + 2) * 32, 114 + (int)(Math.random() * 2.0), false, false);
            }
            pylons = game.getMap().getPylonBoundary(game, expo, -1);
            for (Point pLocation : pylons) {
                bwapi.drawBox(pLocation.x * 32, pLocation.y * 32, (pLocation.x + 2) * 32, (pLocation.y + 2) * 32, 48 + (int)(Math.random() * 2.0), false, false);
            }
            location2 = game.getMap().getPylonOpenSpace(game, expo, -1);
            if (location2 == null) continue;
            bwapi.drawBox(location2.x * 32, location2.y * 32, (location2.x + 2) * 32, (location2.y + 2) * 32, 140 + (int)(Math.random() * 2.0), false, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean findBuildingLocation(int type, int workerID, int workerX, int workerY) {
        Point location = null;
        if (type == 156) {
            ArrayList<Point> locations = this.getFirstPylons(ABLStarCraftBot.getGame(), null, workerID);
            locations.addAll(this.getPylonChokepoint(ABLStarCraftBot.getGame(), null, workerID));
            for (UnitWME unitWME : ABLStarCraftBot.getGame().getPlayerUnits()) {
                if (unitWME.getTypeID() != UnitType.UnitTypes.Protoss_Nexus.ordinal()) continue;
                locations.add(this.getPylonOpenSpace(ABLStarCraftBot.getGame(), unitWME, workerID));
            }
            if (locations.size() > 0) {
                location = locations.get(0);
            }
        } else if (type == 154) {
            location = this.getNextExpansion(ABLStarCraftBot.getGame(), true);
        } else if (type == 157) {
            location = this.getNextGeyser(ABLStarCraftBot.getGame());
        } else {
            void var7_13;
            int width = 4;
            int n = 3;
            if (UnitTypeWME.getType(type) != null) {
                width = UnitTypeWME.getType(type).getTileWidth();
                int n2 = UnitTypeWME.getType(type).getTileHeight();
            }
            if (type == 160) {
                ++var7_13;
                ++width;
            }
            ArrayList<Point> locations = this.getBuildLocations(ABLStarCraftBot.getGame(), width, (int)var7_13, workerID);
            double closest = Double.MAX_VALUE;
            for (Point point : locations) {
                double dx = point.x - workerX;
                double dy = point.y - workerY;
                double distance = dx * dx + dy * dy;
                if (!(distance < closest)) continue;
                closest = distance;
                location = point;
            }
        }
        if (location != null) {
            this.buildingX = location.x;
            this.buildingY = location.y;
            return true;
        }
        return false;
    }

    public Point choosePylonLocation(int nexus, int purpose) {
        UnitWME expo = ABLStarCraftBot.getGame().getUnitByID(nexus);
        if (expo == null) {
            return null;
        }
        ArrayList<Object> pylons = new ArrayList();
        switch (purpose) {
            case 0: {
                pylons = this.getFirstPylons(ABLStarCraftBot.getGame(), expo, -1);
                break;
            }
            case 1: {
                Point pylon = this.getPylonOpenSpace(ABLStarCraftBot.getGame(), expo, -1);
                if (pylon == null) break;
                pylons.add(pylon);
                break;
            }
            case 2: {
                pylons = this.getDefensePylons(ABLStarCraftBot.getGame(), expo, -1);
                break;
            }
            case 3: {
                pylons = this.getPylonChokepoint(ABLStarCraftBot.getGame(), expo, -1);
                break;
            }
            case 4: {
                pylons = this.getPylonBoundary(ABLStarCraftBot.getGame(), expo, -1);
            }
        }
        if (pylons.size() > 0) {
            return (Point)pylons.get(0);
        }
        return null;
    }

    public int getBuildingX() {
        return this.buildingX;
    }

    public int getBuildingY() {
        return this.buildingY;
    }

    public Point getNextScoutLocation() {
        Game game = ABLStarCraftBot.getGame();
        if (this.scoutLocations.size() == 0) {
            block0: for (BaseLocationWME location : game.getBaseLocations()) {
                for (PlayerUnitWME unit : game.getPlayerUnits()) {
                    if (Math.abs(unit.getX() - location.getX()) <= 6 && Math.abs(unit.getY() - location.getY()) <= 6) continue block0;
                }
                this.scoutLocations.add(new Point(location.getX(), location.getY()));
            }
        }
        if (this.scoutLocations.size() == 0) {
            return new Point(this.getMapWidth() / 2, this.getMapHeight() / 2);
        }
        return this.scoutLocations.remove();
    }

    public Point getNextStartLocation() {
        Game game = ABLStarCraftBot.getGame();
        if (this.startLocations.size() == 0) {
            block0: for (StartingLocationWME location : game.getStartingLocations()) {
                for (PlayerUnitWME unit : game.getPlayerUnits()) {
                    if (Math.abs(unit.getX() - location.getX()) <= 6 && Math.abs(unit.getY() - location.getY()) <= 6) continue block0;
                }
                this.startLocations.add(new Point(location.getX(), location.getY()));
            }
        }
        if (this.startLocations.size() == 0) {
            return new Point(this.getMapWidth() / 2, this.getMapHeight() / 2);
        }
        return this.startLocations.remove();
    }

    public boolean isLocationClear(int type, int x, int y, int workerID) {
        boolean[] occupied = new boolean[this.mapHeight * this.mapWidth];
        for (UnitWME unit : ABLStarCraftBot.getGame().getUnits()) {
            if (unit.getID() == workerID || unit.getTypeID() == 188) continue;
            int width = 4;
            int height = 3;
            if (unit.getType() != null) {
                width = unit.getType().getTileWidth();
                height = unit.getType().getTileHeight();
            }
            int w = 0;
            while (w < width) {
                int h = 0;
                while (h < height) {
                    int index = (unit.getY() + h) * this.mapWidth + unit.getX() + w;
                    if (index >= 0 && index < occupied.length) {
                        occupied[index] = true;
                    }
                    ++h;
                }
                ++w;
            }
        }
        UnitTypeWME unitType = ABLStarCraftBot.getGame().getUnitTypes().get(type);
        if (unitType == null) {
            return false;
        }
        int w = 0;
        while (w < unitType.getTileWidth()) {
            int h = 0;
            while (h < unitType.getTileHeight()) {
                int index = (y + h) * this.mapWidth + x + w;
                if (index >= 0 && index < occupied.length && occupied[index]) {
                    return false;
                }
                ++h;
            }
            ++w;
        }
        return true;
    }

    public ArrayList<Point> getFirstPylons(Game game, UnitWME nexus, int probeID) {
        ArrayList<UnitWME> expos = new ArrayList<UnitWME>();
        ArrayList<Point> points = new ArrayList<Point>();
        if (nexus != null) {
            expos.add(nexus);
        } else {
            for (UnitWME unitWME : game.getPlayerUnits()) {
                if (unitWME.getTypeID() != UnitType.UnitTypes.Protoss_Nexus.ordinal()) continue;
                expos.add(unitWME);
            }
        }
        Collections.sort(expos, new Comparator<UnitWME>(){

            @Override
            public int compare(UnitWME o1, UnitWME o2) {
                return o1.getID() - o2.getID();
            }
        });
        boolean[] blArray = new boolean[this.mapHeight * this.mapWidth];
        for (UnitWME unit : game.getUnits()) {
            if (unit.getID() == probeID) continue;
            int width = 4;
            int height = 3;
            if (unit.getType() != null) {
                width = unit.getType().getTileWidth();
                height = unit.getType().getTileHeight();
            }
            int w = 0;
            while (w < width) {
                int h = 0;
                while (h < height) {
                    int index = (unit.getY() + h) * this.mapWidth + unit.getX() + w;
                    if (index >= 0 && index < blArray.length) {
                        blArray[index] = true;
                    }
                    ++h;
                }
                ++w;
            }
        }
        block4: for (UnitWME expo : expos) {
            int tx = 0;
            int ty = 0;
            int count = 0;
            for (MineralWME mins : game.getMinerals()) {
                if (Math.abs(expo.getX() - mins.getX()) >= 10 || Math.abs(expo.getY() - mins.getY()) >= 10) continue;
                ++count;
                tx += mins.getX();
                ty += mins.getY();
            }
            if (count == 0) {
                return new ArrayList<Point>();
            }
            tx /= count;
            ty /= count;
            tx = expo.getX() + (expo.getX() - tx);
            ty = expo.getY() + (expo.getY() - ty);
            int i = 0;
            while (i < 3) {
                int x = -i;
                while (x <= i) {
                    int y = -i;
                    while (y <= i) {
                        if ((Math.abs(x) == i || Math.abs(y) == i) && tx + x + 1 < this.mapWidth && tx + x >= 0 && ty + y + 1 < this.mapHeight && ty >= 0 && this.buildable[ty + y][tx + x] && this.buildable[ty + y + 1][tx + x] && this.buildable[ty + y][tx + x + 1] && this.buildable[ty + y + 1][tx + x + 1] && !blArray[(ty + y) * this.mapWidth + tx + x] && !blArray[(ty + y + 1) * this.mapWidth + tx + x] && !blArray[(ty + y) * this.mapWidth + tx + x + 1] && !blArray[(ty + y + 1) * this.mapWidth + tx + x + 1]) {
                            for (UnitWME unitWME : game.getPlayerUnits()) {
                                if (unitWME.getTypeID() == UnitType.UnitTypes.Protoss_Pylon.ordinal() && Math.abs(unitWME.getX() - (tx + x)) < 8 && Math.abs(unitWME.getY() - (ty + y)) < 8) continue block4;
                            }
                            points.add(new Point(tx + x, ty + y));
                            continue block4;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++i;
            }
        }
        return points;
    }

    public ArrayList<Point> getDefensePylons(Game game, UnitWME nexus, int probeID) {
        ArrayList<UnitWME> expos = new ArrayList<UnitWME>();
        ArrayList<Point> points = new ArrayList<Point>();
        if (nexus != null) {
            expos.add(nexus);
        } else {
            for (UnitWME unitWME : game.getPlayerUnits()) {
                if (unitWME.getTypeID() != UnitType.UnitTypes.Protoss_Nexus.ordinal()) continue;
                expos.add(unitWME);
            }
        }
        Collections.sort(expos, new Comparator<UnitWME>(){

            @Override
            public int compare(UnitWME o1, UnitWME o2) {
                return o1.getID() - o2.getID();
            }
        });
        boolean[] blArray = new boolean[this.mapHeight * this.mapWidth];
        for (UnitWME unit : game.getUnits()) {
            if (unit.getID() == probeID) continue;
            int w = 0;
            while (w < unit.getType().getTileWidth()) {
                int h = 0;
                while (h < unit.getType().getTileHeight()) {
                    int index = (unit.getY() + h) * this.mapWidth + unit.getX() + w;
                    if (index >= 0 && index < blArray.length) {
                        blArray[index] = true;
                    }
                    ++h;
                }
                ++w;
            }
        }
        block4: for (UnitWME expo : expos) {
            int tx = 0;
            int ty = 0;
            int count = 0;
            RegionWME homeRegion = null;
            for (RegionWME region : game.getRegions()) {
                if (!region.contains(32 * expo.getX(), 32 * expo.getY())) continue;
                homeRegion = region;
                break;
            }
            if (homeRegion == null) continue;
            for (MineralWME mins : game.getMinerals()) {
                if (Math.abs(expo.getX() - mins.getX()) >= 10 || Math.abs(expo.getY() - mins.getY()) >= 10) continue;
                ++count;
                tx += mins.getX();
                ty += mins.getY();
                int minX = Math.min(mins.getX(), expo.getX());
                int n = Math.max(mins.getX(), expo.getX());
                int minY = Math.min(mins.getY(), expo.getY());
                int maxY = Math.max(mins.getY(), expo.getY());
                int x = minX;
                while (x <= n) {
                    int y = minY;
                    while (y <= maxY) {
                        if (x < this.mapWidth && y < this.mapHeight) {
                            blArray[y * this.mapWidth + x] = true;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            if (count == 0) continue;
            tx /= count;
            ty /= count;
            tx += (tx - expo.getX()) / 2;
            ty += (ty - expo.getY()) / 2;
            int i = 0;
            while (i < 9) {
                int x = -i;
                while (x <= i) {
                    int y = -i;
                    while (y <= i) {
                        block19: {
                            if ((Math.abs(x) == i || Math.abs(y) == i) && tx + x + 1 < this.mapWidth && tx + x >= 0 && ty + y + 1 < this.mapHeight && ty + y >= 0 && this.buildable[ty + y][tx + x] && this.buildable[ty + y + 1][tx + x] && this.buildable[ty + y][tx + x + 1] && this.buildable[ty + y + 1][tx + x + 1] && !blArray[(ty + y) * this.mapWidth + tx + x] && !blArray[(ty + y + 1) * this.mapWidth + tx + x] && !blArray[(ty + y) * this.mapWidth + tx + x + 1] && !blArray[(ty + y + 1) * this.mapWidth + tx + x + 1] && homeRegion.contains(32 * tx, 32 * ty)) {
                                for (UnitWME unitWME : game.getPlayerUnits()) {
                                    if (unitWME.getTypeID() != UnitType.UnitTypes.Protoss_Pylon.ordinal() || Math.abs(unitWME.getX() - (tx + x)) >= 6 || Math.abs(unitWME.getY() - (ty + y)) >= 6) {
                                        continue;
                                    }
                                    break block19;
                                }
                                points.add(new Point(tx + x, ty + y));
                                continue block4;
                            }
                        }
                        ++y;
                    }
                    ++x;
                }
                ++i;
            }
        }
        return points;
    }

    public ArrayList<UnitWME> getExpos(Game game) {
        ArrayList<UnitWME> expos = new ArrayList<UnitWME>();
        for (UnitWME unitWME : game.getPlayerUnits()) {
            if (unitWME.getTypeID() != UnitType.UnitTypes.Protoss_Nexus.ordinal()) continue;
            expos.add(unitWME);
        }
        return expos;
    }

    public Point getRallyPoint(int x, int y) {
        TreeMap<Integer, PlayerUnitWME> expos = new TreeMap<Integer, PlayerUnitWME>();
        for (PlayerUnitWME unit : ABLStarCraftBot.getGame().getPlayerUnits()) {
            if (!(unit instanceof NexusWME)) continue;
            expos.put(unit.getID(), unit);
        }
        HashSet<ChokePointWME> ignore = new HashSet<ChokePointWME>();
        int index = 0;
        for (PlayerUnitWME expo : expos.values()) {
            RegionWME homeRegion = null;
            for (RegionWME region : ABLStarCraftBot.getGame().getRegions()) {
                if (!region.contains(32 * expo.getX(), 32 * expo.getY())) continue;
                homeRegion = region;
                break;
            }
            if (homeRegion != null) {
                if (index + 1 == expos.size()) {
                    ArrayList<ChokePointWME> chokes = new ArrayList<ChokePointWME>();
                    for (ChokePointWME choke : homeRegion.getChokePoints()) {
                        if (ignore.contains(choke)) continue;
                        chokes.add(choke);
                    }
                    if (chokes.size() > 0) {
                        ChokePointWME choke;
                        choke = (ChokePointWME)chokes.get((int)(Math.random() * (double)chokes.size()));
                        return new Point(choke.getX(), choke.getY());
                    }
                }
                ignore.addAll(homeRegion.getChokePoints());
            }
            ++index;
        }
        return new Point(x, y);
    }

    public Point getPylonOpenSpace(Game game, UnitWME nexus, int probeID) {
        RegionWME homeRegion = null;
        for (RegionWME region : game.getRegions()) {
            if (!region.contains(32 * nexus.getX(), 32 * nexus.getY())) continue;
            homeRegion = region;
            break;
        }
        if (homeRegion == null) {
            return null;
        }
        boolean[] occupied = new boolean[this.mapHeight * this.mapWidth];
        for (UnitWME unit : game.getUnits()) {
            if (unit.getID() == probeID) continue;
            int width = 4;
            int height = 3;
            if (unit.getType() != null) {
                width = unit.getType().getTileWidth();
                height = unit.getType().getTileHeight();
            }
            int w = 0;
            while (w < width) {
                int h = 0;
                while (h < height) {
                    int index = (unit.getY() + h) * this.mapWidth + unit.getX() + w;
                    if (index >= 0 && index < occupied.length) {
                        occupied[index] = true;
                    }
                    ++h;
                }
                ++w;
            }
        }
        Point closest = null;
        double dist = 0.0;
        int maxSpace = 10;
        int tx = homeRegion.getMinTileX();
        while (tx <= homeRegion.getMaxTileX()) {
            int ty = homeRegion.getMinTileY();
            while (ty <= homeRegion.getMaxTileY()) {
                if (tx + 1 < this.mapWidth && tx >= 0 && ty + 1 < this.mapHeight && ty >= 0 && homeRegion.contains(32 * tx, 32 * ty) && this.buildable[ty][tx] && this.buildable[ty + 1][tx] && this.buildable[ty][tx + 1] && this.buildable[ty + 1][tx + 1] && !occupied[ty * this.mapWidth + tx] && !occupied[(ty + 1) * this.mapWidth + tx] && !occupied[ty * this.mapWidth + tx + 1] && !occupied[(ty + 1) * this.mapWidth + tx + 1]) {
                    int distance = 0;
                    int d = 0;
                    block6: while (d <= maxSpace) {
                        distance = d;
                        int x = -d;
                        while (x <= d) {
                            int y = -d;
                            while (y <= d) {
                                if (!(Math.abs(x) != d && Math.abs(y) != d || tx + x + 1 < this.mapWidth && tx + x >= 0 && ty + y + 1 < this.mapHeight && ty + y >= 0 && this.buildable[ty + y][tx + x] && this.buildable[ty + y + 1][tx + x] && this.buildable[ty + y][tx + x + 1] && this.buildable[ty + y + 1][tx + x + 1] && !occupied[(ty + y) * this.mapWidth + tx + x] && !occupied[(ty + y + 1) * this.mapWidth + tx + x] && !occupied[(ty + y) * this.mapWidth + tx + x + 1] && !occupied[(ty + y + 1) * this.mapWidth + tx + x + 1])) break block6;
                                ++y;
                            }
                            ++x;
                        }
                        ++d;
                    }
                    if (distance == maxSpace) {
                        return new Point(tx, ty);
                    }
                    if (closest == null || (double)distance > dist) {
                        closest = new Point(tx, ty);
                        dist = distance;
                    }
                }
                ++ty;
            }
            ++tx;
        }
        return closest;
    }

    public ArrayList<Point> getPylonBoundary(Game game, UnitWME nexus, int probeID) {
        ArrayList<Point> points = new ArrayList<Point>();
        boolean[] occupied = new boolean[this.mapHeight * this.mapWidth];
        for (UnitWME unit : game.getUnits()) {
            if (unit.getID() == probeID) continue;
            int w = 0;
            while (w < unit.getType().getTileWidth()) {
                int h = 0;
                while (h < unit.getType().getTileHeight()) {
                    int index = (unit.getY() + h) * this.mapWidth + unit.getX() + w;
                    if (index >= 0 && index < occupied.length) {
                        occupied[index] = true;
                    }
                    ++h;
                }
                ++w;
            }
        }
        RegionWME homeRegion = null;
        for (RegionWME region : game.getRegions()) {
            if (!region.contains(32 * nexus.getX(), 32 * nexus.getY())) continue;
            homeRegion = region;
            break;
        }
        if (homeRegion == null) {
            return points;
        }
        block4: for (Point point : homeRegion.getPoints()) {
            for (Point p : points) {
                if (Math.abs(point.x / 32 - p.x) < 10 && Math.abs(point.y / 32 - p.y) < 10) continue block4;
            }
            int tx = point.x / 32;
            int ty = point.y / 32;
            int i = 0;
            while (i < 3) {
                int x = -i;
                while (x <= i) {
                    int y = -i;
                    while (y <= i) {
                        if ((Math.abs(x) == i || Math.abs(y) == i) && tx + x + 1 < this.mapWidth && tx + x >= 0 && ty + y + 1 < this.mapHeight && ty + y >= 0 && homeRegion.contains(32 * (tx + x), 32 * ty + y) && this.buildable[ty + y][tx + x] && this.buildable[ty + y + 1][tx + x] && this.buildable[ty + y][tx + x + 1] && this.buildable[ty + y + 1][tx + x + 1] && !occupied[(ty + y) * this.mapWidth + tx + x] && !occupied[(ty + y + 1) * this.mapWidth + tx + x] && !occupied[(ty + y) * this.mapWidth + tx + x + 1] && !occupied[(ty + y + 1) * this.mapWidth + tx + x + 1]) {
                            for (UnitWME unitWME : game.getPlayerUnits()) {
                                if (unitWME.getTypeID() == UnitType.UnitTypes.Protoss_Pylon.ordinal() && Math.abs(unitWME.getX() - (tx + x)) < 8 && Math.abs(unitWME.getY() - (ty + y)) < 8) continue block4;
                            }
                            points.add(new Point(tx + x, ty + y));
                            continue block4;
                        }
                        ++y;
                    }
                    ++x;
                }
                ++i;
            }
        }
        return points;
    }

    public ArrayList<Point> getPylonChokepoint(Game game, UnitWME nexus, int probeID) {
        ArrayList<UnitWME> expos = new ArrayList<UnitWME>();
        ArrayList<Point> points = new ArrayList<Point>();
        if (nexus != null) {
            expos.add(nexus);
        } else {
            for (UnitWME unitWME : game.getPlayerUnits()) {
                if (unitWME.getTypeID() != UnitType.UnitTypes.Protoss_Nexus.ordinal()) continue;
                expos.add(unitWME);
            }
        }
        Collections.sort(expos, new Comparator<UnitWME>(){

            @Override
            public int compare(UnitWME o1, UnitWME o2) {
                return o1.getID() - o2.getID();
            }
        });
        boolean[] blArray = new boolean[this.mapHeight * this.mapWidth];
        for (UnitWME unit : game.getUnits()) {
            if (unit.getID() == probeID) continue;
            int width = 4;
            int height = 3;
            if (unit.getType() != null) {
                width = unit.getType().getTileWidth();
                height = unit.getType().getTileHeight();
            }
            int w = 0;
            while (w < width) {
                int h = 0;
                while (h < height) {
                    int index = (unit.getY() + h) * this.mapWidth + unit.getX() + w;
                    if (index >= 0 && index < blArray.length) {
                        blArray[index] = true;
                    }
                    ++h;
                }
                ++w;
            }
        }
        HashSet<ChokePointWME> visited = new HashSet<ChokePointWME>();
        for (UnitWME expo : expos) {
            RegionWME homeRegion = null;
            for (RegionWME region : game.getRegions()) {
                if (!region.contains(32 * expo.getX(), 32 * expo.getY())) continue;
                homeRegion = region;
                break;
            }
            if (homeRegion == null) continue;
            block6: for (ChokePointWME choke : homeRegion.getChokePoints()) {
                if (visited.contains(choke)) continue;
                visited.add(choke);
                int tx = choke.getX();
                int ty = choke.getY();
                int i = 3;
                while (i < 9) {
                    int x = -i;
                    while (x <= i) {
                        int y = -i;
                        while (y <= i) {
                            if ((Math.abs(x) == i || Math.abs(y) == i) && homeRegion.contains(32 * (tx + x), 32 * ty + y) && tx + x + 1 < this.mapWidth && tx + x >= 0 && ty + y + 1 < this.mapHeight && ty + y >= 0 && this.buildable[ty + y][tx + x] && this.buildable[ty + y + 1][tx + x] && this.buildable[ty + y][tx + x + 1] && this.buildable[ty + y + 1][tx + x + 1] && !blArray[(ty + y) * this.mapWidth + tx + x] && !blArray[(ty + y + 1) * this.mapWidth + tx + x] && !blArray[(ty + y) * this.mapWidth + tx + x + 1] && !blArray[(ty + y + 1) * this.mapWidth + tx + x + 1]) {
                                for (UnitWME unitWME : game.getPlayerUnits()) {
                                    if (unitWME.getTypeID() == UnitType.UnitTypes.Protoss_Pylon.ordinal() && Math.abs(unitWME.getX() - (tx + x)) < 8 && Math.abs(unitWME.getY() - (ty + y)) < 8) continue block6;
                                }
                                points.add(new Point(tx + x, ty + y));
                                continue block6;
                            }
                            ++y;
                        }
                        ++x;
                    }
                    ++i;
                }
            }
        }
        return points;
    }

    public Point getNextGeyser(Game game) {
        ArrayList<UnitWME> expos = new ArrayList<UnitWME>();
        for (UnitWME unitWME : game.getPlayerUnits()) {
            if (unitWME.getTypeID() != UnitType.UnitTypes.Protoss_Nexus.ordinal() || !unitWME.getActive()) continue;
            expos.add(unitWME);
        }
        Collections.sort(expos, new Comparator<UnitWME>(){

            @Override
            public int compare(UnitWME o1, UnitWME o2) {
                return o1.getID() - o2.getID();
            }
        });
        for (UnitWME unitWME : expos) {
            for (GeyserWME geyser : game.getGeysers()) {
                if (Math.abs(unitWME.getX() - geyser.getX()) >= 10 || Math.abs(unitWME.getY() - geyser.getY()) >= 10) continue;
                return new Point(geyser.getX(), geyser.getY());
            }
        }
        return null;
    }

    public boolean getIsExpoAvailable() {
        return this.getNextExpansion(ABLStarCraftBot.getGame(), true) != null;
    }

    public ArrayList<Point> getExpansionLocations(Game game, boolean ignoreMinOnly) {
        ArrayList<Point> locations = new ArrayList<Point>();
        for (BaseLocationWME location : game.getBaseLocations()) {
            boolean occupied = false;
            for (UnitWME unit : game.getUnits()) {
                if (!unit.getIsCenter() || Math.abs(unit.getRealCenterX() - location.getRealX()) >= 256 || Math.abs(unit.getRealCenterY() - location.getRealY()) >= 256) continue;
                occupied = true;
                break;
            }
            for (ParticleWME particle : game.getParticleFilter().getParticles()) {
                if (!(Math.abs(particle.getRealX() - (double)location.getRealX()) < 500.0) || !(Math.abs(particle.getRealY() - (double)location.getRealY()) < 500.0)) continue;
                occupied = true;
                break;
            }
            if (ignoreMinOnly && location.isMineralOnly()) {
                occupied = true;
            }
            if (occupied) continue;
            locations.add(new Point(location.getX(), location.getY()));
        }
        return locations;
    }

    /*
     * WARNING - void declaration
     */
    public Point getNextExpansion(Game game, boolean ignoreMinOnly) {
        void var5_9;
        ArrayList<Point> locations = this.getExpansionLocations(game, ignoreMinOnly);
        if (locations.size() == 0) {
            return null;
        }
        UnitWME home = null;
        for (UnitWME unitWME : game.getPlayerUnits()) {
            if (unitWME.getTypeID() != UnitType.UnitTypes.Protoss_Nexus.ordinal() || home != null && unitWME.getID() >= home.getID()) continue;
            home = unitWME;
        }
        if (home == null) {
            return null;
        }
        Object var5_7 = null;
        for (RegionWME region : game.getRegions()) {
            if (!region.contains(32 * home.getX(), 32 * home.getY())) continue;
            RegionWME regionWME = region;
            break;
        }
        if (var5_9 == null) {
            return null;
        }
        LinkedList<Object> fringe = new LinkedList<Object>();
        HashMap<Object, Integer> fringed = new HashMap<Object, Integer>();
        fringe.add(var5_9);
        fringed.put(var5_9, 0);
        Point closest = null;
        int depth = 0;
        double dist = Double.MAX_VALUE;
        while (fringe.size() > 0) {
            RegionWME region = (RegionWME)fringe.remove();
            if (closest != null && (Integer)fringed.get(region) > depth) {
                return closest;
            }
            for (Point location : locations) {
                if (!region.contains(location.x * 32, location.y * 32)) continue;
                double distance = Double.MAX_VALUE;
                for (UnitWME unitWME : game.getPlayerUnits()) {
                    double dx = location.x - unitWME.getX();
                    double dy = location.y - unitWME.getY();
                    distance = Math.min(distance, Math.sqrt(dx * dx + dy * dy));
                }
                if (closest != null && !(distance < dist)) continue;
                closest = location;
                dist = distance;
                depth = (Integer)fringed.get(region);
            }
            for (ChokePointWME choke : region.getChokePoints()) {
                RegionWME connected = choke.getOtherRegion(region);
                if (fringed.containsKey(connected)) continue;
                fringe.add(connected);
                fringed.put(connected, 1 + (Integer)fringed.get(region));
            }
        }
        return closest;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<Point> getBuildLocations(Game game, int tileWidth, int tileHeight, int probeID) {
        ArrayList<Point> locations = new ArrayList<Point>();
        boolean[] occupied = new boolean[this.mapHeight * this.mapWidth];
        for (UnitWME unitWME : game.getUnits()) {
            if (unitWME.getID() == probeID) continue;
            int n = 4;
            int height = 3;
            if (unitWME.getType() != null) {
                n = unitWME.getType().getTileWidth();
                height = unitWME.getType().getTileHeight();
            }
            int w = 0;
            while (w < n) {
                int h = 0;
                while (h < height) {
                    int index = (unitWME.getY() + h) * this.mapWidth + unitWME.getX() + w;
                    if (index >= 0 && index < occupied.length) {
                        occupied[index] = true;
                    }
                    ++h;
                }
                ++w;
            }
        }
        for (UnitWME unitWME : game.getPlayerUnits()) {
            int y;
            int x;
            int maxY;
            int minY;
            int maxX;
            int minX;
            if (unitWME.getTypeID() != UnitType.UnitTypes.Protoss_Nexus.ordinal()) continue;
            for (UnitWME unitWME2 : game.getPlayerUnits()) {
                if (unitWME2.getTypeID() != UnitType.UnitTypes.Protoss_Assimilator.ordinal() || Math.abs(unitWME.getX() - unitWME2.getX()) >= 10 || Math.abs(unitWME.getY() - unitWME2.getY()) >= 10) continue;
                minX = Math.min(unitWME2.getX(), unitWME.getX());
                maxX = Math.max(unitWME2.getX() + unitWME2.getType().getTileWidth() - 1, unitWME.getX() + unitWME.getType().getTileWidth() - 1);
                minY = Math.min(unitWME2.getY(), unitWME.getY());
                maxY = Math.max(unitWME2.getY() + unitWME2.getType().getTileHeight() - 1, unitWME.getY() + unitWME.getType().getTileHeight() - 1);
                x = minX;
                while (x <= maxX) {
                    y = minY;
                    while (y <= maxY) {
                        if (x < this.mapWidth && y < this.mapHeight) {
                            occupied[y * this.mapWidth + x] = true;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            for (GeyserWME geyserWME : game.getGeysers()) {
                if (Math.abs(unitWME.getX() - geyserWME.getX()) >= 10 || Math.abs(unitWME.getY() - geyserWME.getY()) >= 10) continue;
                minX = Math.min(geyserWME.getX(), unitWME.getX());
                maxX = Math.max(geyserWME.getX() + geyserWME.getType().getTileWidth() - 1, unitWME.getX() + unitWME.getType().getTileWidth() - 1);
                minY = Math.min(geyserWME.getY(), unitWME.getY());
                maxY = Math.max(geyserWME.getY() + geyserWME.getType().getTileHeight() - 1, unitWME.getY() + unitWME.getType().getTileHeight() - 1);
                x = minX;
                while (x <= maxX) {
                    y = minY;
                    while (y <= maxY) {
                        if (x < this.mapWidth && y < this.mapHeight) {
                            occupied[y * this.mapWidth + x] = true;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
        }
        for (UnitWME unitWME : game.getPlayerUnits()) {
            void var9_18;
            if (unitWME.getTypeID() != UnitType.UnitTypes.Protoss_Pylon.ordinal() || !unitWME.getActive()) continue;
            int n = -10;
            while (var9_18 <= 10) {
                int y = -10;
                while (y <= 10) {
                    block33: {
                        int tx = unitWME.getX() + var9_18;
                        int ty = unitWME.getY() + y;
                        if (tx >= 0 && ty >= 0 && tx + tileWidth <= this.mapWidth && ty + tileHeight < this.mapHeight) {
                            int w = 0;
                            while (w < tileWidth) {
                                int h = 0;
                                while (h < tileHeight) {
                                    if (this.buildable[ty + h][tx + w] && !occupied[(ty + h) * this.mapWidth + tx + w]) {
                                        ++h;
                                        continue;
                                    }
                                    break block33;
                                }
                                ++w;
                            }
                            boolean buildable = false;
                            int bx = tx - unitWME.getX() + 7;
                            int by = ty - unitWME.getY() + 5;
                            if (tileWidth == 4) {
                                ++bx;
                            }
                            if (bx >= 0 && by >= 0 && bx <= 14 && by <= 9 || bx == -1 && tileWidth == 3 && by >= 3 && by <= 6) {
                                switch (by) {
                                    case 0: {
                                        if (tileHeight != 3 || bx < 4 || bx > 9) break;
                                        buildable = true;
                                        break;
                                    }
                                    case 1: {
                                        if (bx < 1 || bx > 12) break;
                                        buildable = true;
                                        break;
                                    }
                                    case 2: {
                                        if (bx > 13) break;
                                        buildable = true;
                                        break;
                                    }
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: {
                                        buildable = true;
                                        break;
                                    }
                                    case 7: {
                                        if (bx > 13) break;
                                        buildable = true;
                                        break;
                                    }
                                    case 8: {
                                        if (bx < 1 || bx > 12) break;
                                        buildable = true;
                                        break;
                                    }
                                    case 9: {
                                        if (bx < 4 || bx > 9) break;
                                        buildable = true;
                                    }
                                }
                            }
                            if (buildable) {
                                locations.add(new Point(tx, ty));
                            }
                        }
                    }
                    ++y;
                }
                ++var9_18;
            }
        }
        return locations;
    }

    public String getMapName() {
        return this.mapName;
    }

    public Point getGatherPoint(int startX, int startY) {
        ArrayList<Object> shortest = new ArrayList();
        for (ParticleWME particle : ABLStarCraftBot.getGame().getParticleFilter().getParticles()) {
            ArrayList<Point> path = this.getPath(startX, startY, particle.getX(), particle.getY());
            if (shortest.size() != 0 && (path.size() <= 0 || path.size() >= shortest.size())) continue;
            shortest = path;
        }
        if (shortest.size() > 0) {
            return (Point)shortest.get(Math.max(0, shortest.size() - 30));
        }
        return new Point(startX, startY);
    }

    public ArrayList<Point> getPath(int startX, int startY, int endX, int endY) {
        HashSet<Integer> visited = new HashSet<Integer>();
        visited.add(startX + this.mapWidth * startY);
        LinkedList<PathNode> fringe = new LinkedList<PathNode>();
        fringe.add(new PathNode(startX, startY, null));
        while (fringe.size() > 0) {
            PathNode node = (PathNode)fringe.remove();
            if (node.x < 0 || node.y < 0 || node.x >= this.mapWidth || node.y >= this.mapHeight || !this.walkable[node.y][node.x]) continue;
            if (node.x == endX && node.y == endY) {
                ArrayList<Point> path = new ArrayList<Point>();
                while (node != null) {
                    path.add(0, new Point(node.x, node.y));
                    node = node.parent;
                }
                return path;
            }
            ArrayList<PathNode> neighbors = new ArrayList<PathNode>();
            if (!visited.contains(node.x - 1 + this.mapWidth * node.y)) {
                visited.add(node.x - 1 + this.mapWidth * node.y);
                neighbors.add(new PathNode(node.x - 1, node.y, node));
            }
            if (!visited.contains(node.x + 1 + this.mapWidth * node.y)) {
                visited.add(node.x + 1 + this.mapWidth * node.y);
                neighbors.add(new PathNode(node.x + 1, node.y, node));
            }
            if (!visited.contains(node.x + this.mapWidth * (node.y - 1))) {
                visited.add(node.x + this.mapWidth * (node.y - 1));
                neighbors.add(new PathNode(node.x, node.y - 1, node));
            }
            if (!visited.contains(node.x + this.mapWidth * (node.y + 1))) {
                visited.add(node.x + this.mapWidth * (node.y + 1));
                neighbors.add(new PathNode(node.x, node.y + 1, node));
            }
            fringe.addAll(neighbors);
        }
        return new ArrayList<Point>();
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public boolean isWalkable(int tx, int ty) {
        return this.walkable[ty][tx];
    }

    public boolean isBuildable(int tx, int ty) {
        return this.buildable[ty][tx];
    }

    public boolean isBuildable(int tx, int ty, int width, int height) {
        boolean result = true;
        if (tx < 0 || ty < 0 || tx + width >= this.mapWidth || ty + height >= this.mapHeight) {
            return false;
        }
        int h = 0;
        while (h < height) {
            int w = 0;
            while (w < width) {
                result &= this.buildable[ty + h][tx + w];
                ++w;
            }
            ++h;
        }
        return result;
    }

    public int getHeight(int tx, int ty) {
        return this.height[ty][tx];
    }

    public boolean setTarget(int attackX, int attackY) {
        if (System.currentTimeMillis() - this.lastInvoked < 1000L) {
            return true;
        }
        this.lastInvoked = System.currentTimeMillis();
        this.leaderX = attackX;
        this.leaderY = attackY;
        int distance = Integer.MAX_VALUE;
        UnitWME leader = null;
        for (PlayerUnitWME unit : ABLStarCraftBot.getGame().getPlayerUnits()) {
            if (!(unit instanceof GroundUnitWME) || unit.getTask() != StarCraftConstants.FIGHTER_ATTACK || leader != null && unit.getSpawnFrame() >= leader.getSpawnFrame()) continue;
            leader = unit;
        }
        if (leader != null) {
            this.leaderX = leader.getX();
            this.leaderY = leader.getY();
        }
        System.out.println("Path time: " + (System.currentTimeMillis() - this.lastInvoked));
        return true;
    }

    public int getLeaderX() {
        return this.leaderX;
    }

    public int getLeaderY() {
        return this.leaderY;
    }

    public MapWME(JNIBWAPI bwapi) {
        this.mapName = bwapi.getMap().getName();
        this.mapWidth = bwapi.getMap().getWidth();
        this.mapHeight = bwapi.getMap().getHeight();
        this.height = new int[this.mapHeight][this.mapWidth];
        this.buildable = new boolean[this.mapHeight][this.mapWidth];
        this.walkable = new boolean[this.mapHeight][this.mapWidth];
        int total = this.mapWidth * this.mapHeight;
        int i = 0;
        while (i < total) {
            int x = i % this.mapWidth;
            int y = i / this.mapWidth;
            this.height[y][x] = bwapi.getMap().getHeight(x, y);
            this.buildable[y][x] = bwapi.getMap().isBuildable(x, y);
            this.walkable[y][x] = bwapi.getMap().isWalkable(4 * x + 1, 4 * y + 1) && bwapi.getMap().isWalkable(4 * x + 2, 4 * y + 1) && bwapi.getMap().isWalkable(4 * x + 1, 4 * y + 2) && bwapi.getMap().isWalkable(4 * x + 2, 4 * y + 2);
            ++i;
        }
    }

    public void print() {
        int x;
        System.out.println("Name: " + this.mapName);
        System.out.println("Size: " + this.mapWidth + " x " + this.mapHeight);
        System.out.println("\nBuildable");
        System.out.println("---------");
        int y = 0;
        while (y < this.mapHeight) {
            x = 0;
            while (x < this.mapWidth) {
                System.out.print(this.buildable[y][x] ? " " : "X");
                ++x;
            }
            System.out.println();
            ++y;
        }
        System.out.println("\nWalkable");
        System.out.println("--------");
        y = 0;
        while (y < this.mapHeight) {
            x = 0;
            while (x < this.mapWidth) {
                System.out.print(this.walkable[y][x] ? " " : "X");
                ++x;
            }
            System.out.println();
            ++y;
        }
        System.out.println("\nHeight");
        System.out.println("------");
        y = 0;
        while (y < this.mapHeight) {
            x = 0;
            while (x < this.mapWidth) {
                switch (this.height[y][x]) {
                    case 2: {
                        System.out.print(" ");
                        break;
                    }
                    case 1: {
                        System.out.print("*");
                        break;
                    }
                    case 0: {
                        System.out.print("X");
                    }
                }
                ++x;
            }
            System.out.println();
            ++y;
        }
    }

    private class PathNode {
        int x;
        int y;
        PathNode parent;

        public PathNode(int x, int y, PathNode parent) {
            this.x = x;
            this.y = y;
            this.parent = parent;
        }
    }
}

