/*
 * Decompiled with CFR 0.152.
 */
package eisbot.proxy.wmes;

import eisbot.proxy.JNIBWAPI;
import eisbot.proxy.model.ChokePoint;
import eisbot.proxy.wmes.RegionWME;
import java.util.ArrayList;
import java.util.HashMap;
import wm.WME;

public class ChokePointWME
extends WME {
    private int x;
    private int y;
    private int width;
    private RegionWME regionA;
    private RegionWME regionB;
    private int searchDistance = -1;
    private WME searchTarget = null;
    private RegionWME next = null;

    public static ArrayList<ChokePointWME> getLocations(JNIBWAPI bwapi, ArrayList<RegionWME> regions) {
        ArrayList<ChokePointWME> locations = new ArrayList<ChokePointWME>();
        HashMap<Integer, RegionWME> regionMap = new HashMap<Integer, RegionWME>();
        for (RegionWME region : regions) {
            regionMap.put(region.getID(), region);
        }
        for (ChokePoint point : bwapi.getMap().getChokePoints()) {
            ChokePointWME loc = new ChokePointWME();
            loc.x = point.getCenterX();
            loc.y = point.getCenterY();
            loc.width = (int)point.getRadius();
            int region1 = point.getFirstRegionID();
            int region2 = point.getSecondRegionID();
            loc.regionA = (RegionWME)regionMap.get(region1);
            loc.regionB = (RegionWME)regionMap.get(region2);
            loc.regionA.getChokePoints().add(loc);
            loc.regionB.getChokePoints().add(loc);
            locations.add(loc);
        }
        return locations;
    }

    public RegionWME getOtherRegion(RegionWME region) {
        return region.equals(this.regionA) ? this.regionB : this.regionA;
    }

    public int getX() {
        return this.x / 32;
    }

    public int getY() {
        return this.y / 32;
    }

    public int getRealX() {
        return this.x;
    }

    public int getRealY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public String toString() {
        return String.valueOf(this.x) + "," + this.y;
    }
}

