/*
 * Decompiled with CFR 0.152.
 */
package eisbot.proxy.model;

import eisbot.proxy.JNIBWAPI;

public class Player {
    public static final int numAttributes = 8;
    private int ID;
    private int raceID;
    private int typeID;
    private boolean self;
    private boolean ally;
    private boolean enemy;
    private boolean neutral;
    private int color;
    private int minerals;
    private int gas;
    private int supplyUsed;
    private int supplyTotal;
    private int cumulativeMinerals;
    private int cumulativeGas;
    private int unitScore;
    private int killScore;
    private int buildingScore;
    private int razingScore;
    private boolean[] researching = new boolean[47];
    private boolean[] researched = new boolean[47];
    private boolean[] upgrading = new boolean[63];
    private int[] upgradeLevel = new int[63];

    public Player(int[] data, int index) {
        this.ID = data[index++];
        this.raceID = data[index++];
        this.typeID = data[index++];
        this.self = data[index++] == 1;
        this.ally = data[index++] == 1;
        this.enemy = data[index++] == 1;
        this.neutral = data[index++] == 1;
        this.color = data[index++];
    }

    public void update(int[] data) {
        int index = 0;
        this.minerals = data[index++];
        this.gas = data[index++];
        this.supplyUsed = data[index++];
        this.supplyTotal = data[index++];
        this.cumulativeMinerals = data[index++];
        this.cumulativeGas = data[index++];
        this.unitScore = data[index++];
        this.killScore = data[index++];
        this.buildingScore = data[index++];
        this.razingScore = data[index++];
    }

    public void updateResearch(JNIBWAPI bwapi, int[] researchData, int[] upgradeData) {
        int i = 0;
        while (i < researchData.length) {
            this.researched[i / 2] = researchData[i] == 1;
            this.researching[i / 2] = researchData[i + 1] == 1;
            i += 2;
        }
        i = 0;
        while (i < upgradeData.length) {
            this.upgradeLevel[i / 2] = upgradeData[i];
            this.upgrading[i / 2] = upgradeData[i + 1] == 1;
            i += 2;
        }
    }

    public int getID() {
        return this.ID;
    }

    public int getRaceID() {
        return this.raceID;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public boolean isSelf() {
        return this.self;
    }

    public boolean isAlly() {
        return this.ally;
    }

    public boolean isEnemy() {
        return this.enemy;
    }

    public boolean isNeutral() {
        return this.neutral;
    }

    public int getColor() {
        return this.color;
    }

    public int getMinerals() {
        return this.minerals;
    }

    public int getGas() {
        return this.gas;
    }

    public int getSupplyUsed() {
        return this.supplyUsed;
    }

    public int getSupplyTotal() {
        return this.supplyTotal;
    }

    public int getCumulativeMinerals() {
        return this.cumulativeMinerals;
    }

    public int getCumulativeGas() {
        return this.cumulativeGas;
    }

    public int getUnitScore() {
        return this.unitScore;
    }

    public int getKillScore() {
        return this.killScore;
    }

    public int getBuildingScore() {
        return this.buildingScore;
    }

    public int getRazingScore() {
        return this.razingScore;
    }

    public boolean[] getResearchCompleted() {
        return this.researched;
    }

    public boolean[] getResearchInProgress() {
        return this.researching;
    }

    public int[] getUpgradeLevels() {
        return this.upgradeLevel;
    }

    public boolean[] getUpgradesInProgress() {
        return this.upgrading;
    }

    public boolean hasResearched(int techID) {
        return this.researched != null && techID < this.researched.length ? this.researched[techID] : false;
    }

    public boolean isResearching(int techID) {
        return this.researching != null && techID < this.researching.length ? this.researching[techID] : false;
    }

    public int upgradeLevel(int upgradeID) {
        return this.upgradeLevel != null && upgradeID < this.upgradeLevel.length ? this.upgradeLevel[upgradeID] : 0;
    }

    public boolean isUpgrading(int upgradeID) {
        return this.upgrading != null && upgradeID < this.upgrading.length ? this.upgrading[upgradeID] : false;
    }
}

