/*
 * Decompiled with CFR 0.152.
 */
package eisbot.proxy.filter;

import eisbot.abl.Game;
import eisbot.abl.StarCraftConstants;
import eisbot.proxy.JNIBWAPI;
import eisbot.proxy.filter.ParticleWME;
import eisbot.proxy.wmes.ChokePointWME;
import eisbot.proxy.wmes.RegionWME;
import eisbot.proxy.wmes.UnitTypeWME;
import eisbot.proxy.wmes.unit.EnemyUnitWME;
import eisbot.proxy.wmes.unit.PlayerUnitWME;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ParticleFilter {
    private Set<ParticleWME> particles = null;
    private ConcurrentHashMap<Integer, ParticleWME> particleMap = new ConcurrentHashMap();
    private boolean identify = false;
    private boolean expoDecay = false;
    public static double[] pVpParameters = new double[]{0.08771930002325175, 0.0, 0.0, 0.0, 0.05629448511513918, -0.015426897110969704, -0.02959453000575519, -0.00833998276435245, 0.05052438651825254, 0.15066145856634044};
    public static double[] pVtParameters = new double[]{0.0031780368028123387, 0.0, 0.0, 0.22418066573005943, 0.11606883817471428, -0.06429078232346042, -0.0470576311481893, -0.061265457527829796, -0.0063818680246395055, -0.006862412007580852};
    public static double[] pVzParameters = new double[]{0.002342240315372699, 0.0, 0.0, 0.1316150483683206, -0.0038501995826119443, 0.00445958498411494, 0.02266418616835058, 0.026307238751711468, 0.0032193804387948633, 0.0174675713524141};
    private HashMap<Integer, ParticleParameters> typeParameters = new HashMap();
    private HashMap<Integer, Point> lastPosition = new HashMap();

    public ParticleFilter(Game game, boolean identify, boolean expoDecay, boolean defaultParameters, boolean useTargetVector) {
        this.particles = Collections.synchronizedSet(new HashSet());
        this.identify = identify;
        this.expoDecay = expoDecay;
        for (UnitTypeWME type : game.getUnitTypes().values()) {
            double[] params = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            if (!defaultParameters) {
                switch (StarCraftConstants.Race.values()[type.getRace()]) {
                    case Protoss: {
                        params = pVpParameters;
                        break;
                    }
                    case Terran: {
                        params = pVtParameters;
                        break;
                    }
                    case Zerg: {
                        params = pVzParameters;
                    }
                }
            }
            ParticleParameters parameters = new ParticleParameters();
            this.typeParameters.put(type.getId(), parameters);
            if (type.isBuilding()) {
                parameters.decay = params[1];
                parameters.movementSpeed = params[5];
            } else if (type.isWorker()) {
                parameters.decay = params[2];
                parameters.movementSpeed = params[6];
            } else if (type.isFlyer()) {
                parameters.decay = params[3];
                parameters.movementSpeed = params[7];
            } else {
                parameters.decay = params[0];
                parameters.movementSpeed = params[4];
            }
            parameters.targetSpeed = params[8];
            parameters.chokepointSpeed = params[9];
            if (!useTargetVector) {
                parameters.targetSpeed = 0.0;
            }
            parameters.movementSpeed *= 2.0833333333333335;
            parameters.targetSpeed *= 2.0833333333333335;
            parameters.chokepointSpeed *= 2.0833333333333335;
            parameters.decay /= 24.0;
        }
    }

    public void draw(JNIBWAPI bwapi) {
        for (ParticleWME particle : this.particles) {
            int r = (int)(particle.weight * 12.0);
            bwapi.drawBox((int)particle.getRealX() - r, (int)particle.getRealY() - r, (int)particle.getRealX() + r, (int)particle.getRealY() + r, 164, false, false);
            bwapi.drawBox((int)particle.getRealX() - r - 1, (int)particle.getRealY() - r - 1, (int)particle.getRealX() + r + 1, (int)particle.getRealY() + r + 1, 164, false, false);
            bwapi.drawLine((int)particle.getRealX(), (int)particle.getRealY(), (int)(particle.getRealX() + 100.0 * particle.dx), (int)(particle.getRealY() + 100.0 * particle.dy), 164, false);
        }
    }

    public void update(Game game) {
        for (ParticleWME particle : this.particles) {
            particle.decay(this.expoDecay);
        }
        for (ParticleWME particle : this.particles) {
            particle.realX += particle.dx;
            particle.realY += particle.dy;
        }
        HashSet<Integer> visibleEnemies = new HashSet<Integer>();
        for (EnemyUnitWME unit : game.getEnemyUnits()) {
            visibleEnemies.add(unit.getID());
        }
        HashSet<ParticleWME> remove = new HashSet<ParticleWME>();
        for (ParticleWME particle : this.particles) {
            if (visibleEnemies.contains(particle.getUnitID())) {
                particle.setWeight(1.0);
                continue;
            }
            if (!this.identify) {
                this.particleMap.remove(particle.getUnitID());
                particle.setUnitID(-1);
            }
            if (particle.getWeight() <= 0.0) {
                remove.add(particle);
                this.particleMap.remove(particle.getUnitID());
                continue;
            }
            for (PlayerUnitWME unit : game.getPlayerUnits()) {
                int sight;
                int dy;
                int dx = Math.abs(unit.getX() - particle.getX());
                if (dx * dx + (dy = Math.abs(unit.getY() - particle.getY())) * dy >= (sight = unit.getType().getSightRange()) * sight) continue;
                remove.add(particle);
                this.particleMap.remove(particle.getUnitID());
                break;
            }
            if (!(particle.getRealX() < 0.0 || particle.getRealY() < 0.0 || particle.getRealX() / 32.0 > (double)game.getMap().getMapWidth()) && !(particle.getRealY() / 32.0 > (double)game.getMap().getMapHeight())) continue;
            remove.add(particle);
            this.particleMap.remove(particle.getUnitID());
        }
        this.particles.removeAll(remove);
        for (EnemyUnitWME unit : game.getEnemyUnits()) {
            ParticleParameters parameters;
            ParticleWME particle = null;
            if (this.particleMap.containsKey(unit.getID())) {
                particle = this.particleMap.get(unit.getID());
                particle.setRealX(unit.getRealCenterX());
                particle.setRealY(unit.getRealCenterY());
            } else {
                particle = new ParticleWME();
                particle.setUnitID(unit.getID());
                particle.setType(unit.getType());
                particle.setTypeID(unit.getTypeID());
                particle.setRealX(unit.getRealCenterX());
                particle.setRealY(unit.getRealCenterY());
                this.particles.add(particle);
                this.particleMap.put(particle.getUnitID(), particle);
            }
            double tx = unit.getTargetRealX() - unit.getRealCenterX();
            double ty = unit.getTargetRealY() - unit.getRealCenterY();
            double magnitude = Math.sqrt(tx * tx + ty * ty);
            if (magnitude > 0.0) {
                tx /= magnitude;
                ty /= magnitude;
            }
            double cx = 0.0;
            double cy = 0.0;
            if (magnitude > 0.0) {
                for (RegionWME region : game.getRegions()) {
                    if (!region.contains(unit.getRealCenterX(), unit.getRealCenterY())) continue;
                    double px = (double)unit.getRealCenterX() + 500.0 * tx;
                    double py = (double)unit.getRealCenterY() + 500.0 * ty;
                    double closest = Double.MAX_VALUE;
                    for (ChokePointWME choke : region.getChokePoints()) {
                        double dy;
                        double dx = Math.abs(px - (double)choke.getRealX());
                        double dist = dx * dx + (dy = Math.abs(py - (double)choke.getRealY())) * dy;
                        if (!(dist < closest)) continue;
                        closest = dist;
                        cx = choke.getRealX();
                        cy = choke.getRealY();
                    }
                    if (!((magnitude = Math.sqrt((cx -= (double)unit.getRealCenterX()) * cx + (cy -= (double)unit.getRealCenterY()) * cy)) > 0.0)) break;
                    cx /= magnitude;
                    cy /= magnitude;
                    break;
                }
            }
            Point previous = this.lastPosition.get(unit.getID());
            double mx = 0.0;
            double my = 0.0;
            if (previous != null && (magnitude = Math.sqrt((mx = (double)(unit.getRealCenterX() - previous.x)) * mx + (my = (double)(unit.getRealCenterY() - previous.y)) * my)) > 0.0) {
                mx /= magnitude;
                my /= magnitude;
            }
            if ((parameters = this.typeParameters.get(unit.getTypeID())) == null) continue;
            particle.decay = Math.max(0.0, parameters.decay);
            particle.dx = mx * parameters.movementSpeed + tx * parameters.targetSpeed + cx * parameters.chokepointSpeed;
            particle.dy = my * parameters.movementSpeed + ty * parameters.targetSpeed + cy * parameters.chokepointSpeed;
        }
        this.lastPosition.clear();
        for (EnemyUnitWME unit : game.getEnemyUnits()) {
            this.lastPosition.put(unit.getID(), new Point(unit.getRealCenterX(), unit.getRealCenterY()));
        }
    }

    public ParticleWME getRandomBuildingParticle() {
        ArrayList<ParticleWME> list = new ArrayList<ParticleWME>();
        for (ParticleWME particle : this.particles) {
            if (!particle.getType().isBuilding()) continue;
            list.add(particle);
        }
        if (list.size() > 0) {
            return (ParticleWME)list.get((int)((double)list.size() * Math.random()));
        }
        return null;
    }

    public ParticleWME getRandomParticle() {
        if (this.particles.size() > 0) {
            ArrayList<ParticleWME> list = new ArrayList<ParticleWME>(this.particles);
            return list.get((int)((double)list.size() * Math.random()));
        }
        return null;
    }

    public Collection<ParticleWME> getParticles() {
        return new ArrayList<ParticleWME>(this.particles);
    }

    public static enum ParticleFilterMode {
        PerfectInformation,
        DefaultParticles,
        DefaultIdentifyParticles,
        OptimizedParticles,
        OptimizedIdentifyParticles,
        NoMemoryParticles;

    }

    class ParticleParameters {
        double decay;
        double targetSpeed;
        double movementSpeed;
        double chokepointSpeed;

        ParticleParameters() {
        }
    }
}

