/*
 * Decompiled with CFR 0.152.
 */
package eisbot.proxy.filter;

import eisbot.abl.Game;
import eisbot.proxy.JNIBWAPI;
import eisbot.proxy.filter.ParticleFilter;
import eisbot.proxy.filter.ParticleWME;
import eisbot.proxy.wmes.unit.EnemyUnitWME;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NoMemoryFilter
extends ParticleFilter {
    private Set<ParticleWME> particles = Collections.synchronizedSet(new HashSet());

    public NoMemoryFilter(Game game, boolean identify, boolean expoDecay, boolean defaultParameters, boolean useTargetVector) {
        super(game, identify, expoDecay, defaultParameters, useTargetVector);
    }

    @Override
    public void draw(JNIBWAPI bwapi) {
        for (ParticleWME particle : this.particles) {
            int r = (int)(particle.weight * 12.0);
            bwapi.drawBox((int)particle.getRealX() - r, (int)particle.getRealY() - r, (int)particle.getRealX() + r, (int)particle.getRealY() + r, 164, false, false);
            bwapi.drawBox((int)particle.getRealX() - r - 1, (int)particle.getRealY() - r - 1, (int)particle.getRealX() + r + 1, (int)particle.getRealY() + r + 1, 164, false, false);
            bwapi.drawLine((int)particle.getRealX(), (int)particle.getRealY(), (int)(particle.getRealX() + 100.0 * particle.dx), (int)(particle.getRealY() + 100.0 * particle.dy), 164, false);
        }
    }

    @Override
    public void update(Game game) {
        this.particles.clear();
        for (EnemyUnitWME unit : game.getEnemyUnits()) {
            ParticleWME particle = new ParticleWME();
            particle.setUnitID(unit.getID());
            particle.setType(unit.getType());
            particle.setTypeID(unit.getTypeID());
            particle.setRealX(unit.getRealCenterX());
            particle.setRealY(unit.getRealCenterY());
            this.particles.add(particle);
        }
    }

    @Override
    public ParticleWME getRandomParticle() {
        if (this.particles.size() > 0) {
            ArrayList<ParticleWME> list = new ArrayList<ParticleWME>(this.particles);
            return list.get((int)((double)list.size() * Math.random()));
        }
        return null;
    }

    @Override
    public Collection<ParticleWME> getParticles() {
        return new ArrayList<ParticleWME>(this.particles);
    }
}

