/*
 * Decompiled with CFR 0.152.
 */
package eisbot.proxy.command;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.actions.StarCraftAction;
import eisbot.proxy.JNIBWAPI;
import eisbot.proxy.command.Command;
import eisbot.proxy.command.CommandListener;
import eisbot.proxy.wmes.unit.UnitWME;
import java.util.ArrayList;

public class CommandQueue {
    private ArrayList<Command> commandQueue = new ArrayList();
    private ArrayList<CommandListener> listeners = new ArrayList();

    public void clear() {
        this.commandQueue.clear();
    }

    public void addCommandListener(CommandListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCommands(JNIBWAPI bwapi) {
        ArrayList<Command> arrayList = this.commandQueue;
        synchronized (arrayList) {
            for (Command command : this.commandQueue) {
                boolean success = true;
                switch (command.getCommand()) {
                    case attackMove: {
                        success = bwapi.attackMove(command.getUnitID(), command.getArg0(), command.getArg1());
                        break;
                    }
                    case attackUnit: {
                        success = bwapi.attackUnit(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case build: {
                        UnitWME unit;
                        int px = command.getArg0() * 32;
                        int py = command.getArg1() * 32;
                        bwapi.drawBox(px, py, px + 96, py + 64, (int)(Math.random() * 50.0), true, false);
                        success = bwapi.build(command.getUnitID(), command.getArg0(), command.getArg1(), command.getArg2());
                        if (success || (unit = ABLStarCraftBot.getGame().getUnitByID(command.getUnitID())) == null || unit.getX() != command.getArg0() || unit.getY() != command.getArg1()) break;
                        ABLStarCraftBot.getGame().newBlockage(command.getArg0(), command.getArg1());
                        break;
                    }
                    case buildAddon: {
                        success = bwapi.buildAddon(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case train: {
                        success = bwapi.train(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case morph: {
                        success = bwapi.morph(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case research: {
                        success = bwapi.research(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case upgrade: {
                        success = bwapi.upgrade(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case setRallyPosition: {
                        success = bwapi.setRallyPoint(command.getUnitID(), command.getArg0(), command.getArg1());
                        break;
                    }
                    case setRallyTarget: {
                        success = bwapi.setRallyPoint(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case move: {
                        success = bwapi.move(command.getUnitID(), command.getArg0(), command.getArg1());
                        break;
                    }
                    case patrol: {
                        success = bwapi.patrol(command.getUnitID(), command.getArg0(), command.getArg1());
                        break;
                    }
                    case holdPosition: {
                        success = bwapi.holdPosition(command.getUnitID());
                        break;
                    }
                    case stop: {
                        success = bwapi.stop(command.getUnitID());
                        break;
                    }
                    case follow: {
                        success = bwapi.follow(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case gather: {
                        success = bwapi.gather(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case returnCargo: {
                        success = bwapi.returnCargo(command.getUnitID());
                        break;
                    }
                    case repair: {
                        success = bwapi.repair(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case burrow: {
                        success = bwapi.burrow(command.getUnitID());
                        break;
                    }
                    case unburrow: {
                        success = bwapi.unburrow(command.getUnitID());
                        break;
                    }
                    case cloak: {
                        success = bwapi.cloak(command.getUnitID());
                        break;
                    }
                    case decloak: {
                        success = bwapi.decloak(command.getUnitID());
                        break;
                    }
                    case siege: {
                        success = bwapi.siege(command.getUnitID());
                        break;
                    }
                    case unsiege: {
                        success = bwapi.unsiege(command.getUnitID());
                        break;
                    }
                    case lift: {
                        success = bwapi.lift(command.getUnitID());
                        break;
                    }
                    case land: {
                        success = bwapi.land(command.getUnitID(), command.getArg0(), command.getArg1());
                        break;
                    }
                    case load: {
                        success = bwapi.load(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case unload: {
                        success = bwapi.unload(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case unloadAll: {
                        success = bwapi.unloadAll(command.getUnitID());
                        break;
                    }
                    case unloadAllPosition: {
                        success = bwapi.unloadAll(command.getUnitID(), command.getArg0(), command.getArg1());
                        break;
                    }
                    case rightClick: {
                        success = bwapi.rightClick(command.getUnitID(), command.getArg0(), command.getArg1());
                        break;
                    }
                    case rightClickUnit: {
                        success = bwapi.rightClick(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case haltConstruction: {
                        success = bwapi.haltConstruction(command.getUnitID());
                        break;
                    }
                    case cancelConstruction: {
                        success = bwapi.cancelConstruction(command.getUnitID());
                        break;
                    }
                    case cancelAddon: {
                        success = bwapi.cancelAddon(command.getUnitID());
                        break;
                    }
                    case cancelTrain: {
                        success = bwapi.cancelTrain(command.getUnitID());
                        break;
                    }
                    case cancelTrainSlot: {
                        success = bwapi.cancelTrain(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case cancelMorph: {
                        success = bwapi.cancelMorph(command.getUnitID());
                        break;
                    }
                    case cancelResearch: {
                        success = bwapi.cancelResearch(command.getUnitID());
                        break;
                    }
                    case cancelUpgrade: {
                        success = bwapi.cancelUpgrade(command.getUnitID());
                        break;
                    }
                    case useTech: {
                        success = bwapi.useTech(command.getUnitID(), command.getArg0());
                        break;
                    }
                    case useTechPosition: {
                        success = bwapi.useTech(command.getUnitID(), command.getArg0(), command.getArg1(), command.getArg2());
                        break;
                    }
                    case useTechTarget: {
                        success = bwapi.useTech(command.getUnitID(), command.getArg0(), command.getArg1());
                        break;
                    }
                    case setGameSpeed: {
                        bwapi.setGameSpeed(command.getUnitID());
                    }
                }
                command.completionCallback(success);
            }
            this.commandQueue.clear();
        }
    }

    public void setGameSpeed(int speed) {
        this.doCommand(null, Command.StarCraftCommand.setGameSpeed, speed, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommand(StarCraftAction action, Command.StarCraftCommand command, int unitID, int arg0, int arg1, int arg2) {
        ArrayList<Command> arrayList = this.commandQueue;
        synchronized (arrayList) {
            Command order = new Command(action, command, unitID, arg0, arg1, arg2);
            if (!this.commandQueue.contains(order)) {
                this.commandQueue.add(order);
                for (CommandListener listener : this.listeners) {
                    listener.event(order);
                }
            } else if (action != null) {
                action.completionCallback(false);
            }
        }
    }

    public void attackMove(StarCraftAction action, int unitID, int x, int y) {
        this.doCommand(action, Command.StarCraftCommand.attackMove, unitID, x, y, 0);
    }

    public void attackUnit(StarCraftAction action, int unitID, int targetID) {
        this.doCommand(action, Command.StarCraftCommand.attackUnit, unitID, targetID, 0, 0);
    }

    public void rightClick(StarCraftAction action, int unitID, int x, int y) {
        this.doCommand(action, Command.StarCraftCommand.rightClick, unitID, x, y, 0);
    }

    public void rightClick(StarCraftAction action, int unitID, int targetID) {
        this.doCommand(action, Command.StarCraftCommand.rightClickUnit, unitID, targetID, 0, 0);
    }

    public void train(StarCraftAction action, int unitID, int typeID) {
        this.doCommand(action, Command.StarCraftCommand.train, unitID, typeID, 0, 0);
    }

    public void build(StarCraftAction action, int unitID, int tx, int ty, int typeID) {
        this.doCommand(action, Command.StarCraftCommand.build, unitID, tx, ty, typeID);
    }

    public void buildAddon(StarCraftAction action, int unitID, int typeID) {
        this.doCommand(action, Command.StarCraftCommand.buildAddon, unitID, typeID, 0, 0);
    }

    public void research(StarCraftAction action, int unitID, int techTypeID) {
        this.doCommand(action, Command.StarCraftCommand.research, unitID, techTypeID, 0, 0);
    }

    public void upgrade(StarCraftAction action, int unitID, int upgradeTypeID) {
        this.doCommand(action, Command.StarCraftCommand.upgrade, unitID, upgradeTypeID, 0, 0);
    }

    public void stop(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.stop, unitID, 0, 0, 0);
    }

    public void holdPosition(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.holdPosition, unitID, 0, 0, 0);
    }

    public void patrol(StarCraftAction action, int unitID, int x, int y) {
        this.doCommand(action, Command.StarCraftCommand.patrol, unitID, x, y, 0);
    }

    public void follow(StarCraftAction action, int unitID, int targetID) {
        this.doCommand(action, Command.StarCraftCommand.follow, unitID, targetID, 0, 0);
    }

    public void setRallyPosition(StarCraftAction action, int unitID, int x, int y) {
        this.doCommand(action, Command.StarCraftCommand.setRallyPosition, unitID, x, y, 0);
    }

    public void setRallyUnit(StarCraftAction action, int unitID, int targetID) {
        this.doCommand(action, Command.StarCraftCommand.setRallyTarget, unitID, targetID, 0, 0);
    }

    public void repair(StarCraftAction action, int unitID, int targetID) {
        this.doCommand(action, Command.StarCraftCommand.repair, unitID, targetID, 0, 0);
    }

    public void morph(StarCraftAction action, int unitID, int typeID) {
        this.doCommand(action, Command.StarCraftCommand.morph, unitID, typeID, 0, 0);
    }

    public void burrow(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.burrow, unitID, 0, 0, 0);
    }

    public void unburrow(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.unburrow, unitID, 0, 0, 0);
    }

    public void siege(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.siege, unitID, 0, 0, 0);
    }

    public void unsiege(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.unsiege, unitID, 0, 0, 0);
    }

    public void cloak(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.cloak, unitID, 0, 0, 0);
    }

    public void decloak(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.decloak, unitID, 0, 0, 0);
    }

    public void lift(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.lift, unitID, 0, 0, 0);
    }

    public void land(StarCraftAction action, int unitID, int tx, int ty) {
        this.doCommand(action, Command.StarCraftCommand.land, unitID, tx, ty, 0);
    }

    public void load(StarCraftAction action, int unitID, int targetID) {
        this.doCommand(action, Command.StarCraftCommand.load, unitID, targetID, 0, 0);
    }

    public void unload(StarCraftAction action, int unitID, int targetID) {
        this.doCommand(action, Command.StarCraftCommand.unload, unitID, targetID, 0, 0);
    }

    public void unloadAll(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.unloadAll, unitID, 0, 0, 0);
    }

    public void unloadAll(StarCraftAction action, int unitID, int x, int y) {
        this.doCommand(action, Command.StarCraftCommand.unloadAllPosition, unitID, x, y, 0);
    }

    public void cancelConstruction(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.cancelConstruction, unitID, 0, 0, 0);
    }

    public void haltConstruction(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.haltConstruction, unitID, 0, 0, 0);
    }

    public void cancelMorph(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.cancelMorph, unitID, 0, 0, 0);
    }

    public void cancelTrain(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.cancelTrain, unitID, 0, 0, 0);
    }

    public void cancelTrain(StarCraftAction action, int unitID, int slot) {
        this.doCommand(action, Command.StarCraftCommand.cancelTrainSlot, unitID, slot, 0, 0);
    }

    public void cancelAddon(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.cancelAddon, unitID, 0, 0, 0);
    }

    public void cancelResearch(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.cancelResearch, unitID, 0, 0, 0);
    }

    public void cancelUpgrade(StarCraftAction action, int unitID) {
        this.doCommand(action, Command.StarCraftCommand.cancelUpgrade, unitID, 0, 0, 0);
    }

    public void useTech(StarCraftAction action, int unitID, int techTypeID) {
        this.doCommand(action, Command.StarCraftCommand.useTech, unitID, techTypeID, 0, 0);
    }

    public void useTech(StarCraftAction action, int unitID, int techTypeID, int x, int y) {
        this.doCommand(action, Command.StarCraftCommand.useTechPosition, unitID, techTypeID, x, y);
    }

    public void useTech(StarCraftAction action, int unitID, int techTypeID, int targetID) {
        this.doCommand(action, Command.StarCraftCommand.useTechTarget, unitID, techTypeID, targetID, 0);
    }
}

