/*
 * Decompiled with CFR 0.152.
 */
package eisbot.proxy;

import eisbot.proxy.BWAPIEventListener;
import eisbot.proxy.model.BaseLocation;
import eisbot.proxy.model.ChokePoint;
import eisbot.proxy.model.Map;
import eisbot.proxy.model.Player;
import eisbot.proxy.model.PlayerScore;
import eisbot.proxy.model.Region;
import eisbot.proxy.model.Unit;
import eisbot.proxy.types.BulletType;
import eisbot.proxy.types.DamageType;
import eisbot.proxy.types.ExplosionType;
import eisbot.proxy.types.TechType;
import eisbot.proxy.types.UnitSizeType;
import eisbot.proxy.types.UnitType;
import eisbot.proxy.types.UpgradeType;
import eisbot.proxy.types.WeaponType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class JNIBWAPI {
    private BWAPIEventListener listener;
    private int gameFrame = 0;
    private Map map;
    private HashMap<Integer, Unit> units = new HashMap();
    private ArrayList<Unit> playerUnits = new ArrayList();
    private ArrayList<Unit> alliedUnits = new ArrayList();
    private ArrayList<Unit> enemyUnits = new ArrayList();
    private ArrayList<Unit> neutralUnits = new ArrayList();
    private ArrayList<Unit> geysers = new ArrayList();
    private Player self;
    private HashMap<Integer, Player> players = new HashMap();
    private ArrayList<Player> allies = new ArrayList();
    private ArrayList<Player> enemies = new ArrayList();
    private HashMap<Integer, UnitType> unitTypes = new HashMap();
    private HashMap<Integer, TechType> techTypes = new HashMap();
    private HashMap<Integer, UpgradeType> upgradeTypes = new HashMap();
    private HashMap<Integer, WeaponType> weaponTypes = new HashMap();
    private HashMap<Integer, UnitSizeType> unitSizeTypes = new HashMap();
    private HashMap<Integer, BulletType> bulletTypes = new HashMap();
    private HashMap<Integer, DamageType> damageTypes = new HashMap();
    private HashMap<Integer, ExplosionType> explosionTypes = new HashMap();

    static {
        System.loadLibrary("ExampleAIClient");
    }

    private native void startClient(JNIBWAPI var1);

    public native void disconnect();

    private native int getGameFrame();

    private native int[] getPlayerInfo();

    private native int[] getPlayerScores();

    private native int[] getPlayerUpdate();

    private native int[] getResearchStatus();

    private native int[] getUpgradeStatus();

    private native int[] getUnits();

    private native int[] getUnitTypes();

    private native String getUnitTypeName(int var1);

    private native int[] getTechTypes();

    private native String getTechTypeName(int var1);

    public native int[] getUpgradeTypes();

    public native String getUpgradeTypeName(int var1);

    private native int[] getWeaponTypes();

    private native String getWeaponTypeName(int var1);

    private native int[] getUnitSizeTypes();

    private native String getUnitSizeTypeName(int var1);

    private native int[] getBulletTypes();

    private native String getBulletTypeName(int var1);

    private native int[] getDamageTypes();

    private native String getDamageTypeName(int var1);

    private native int[] getExplosionTypes();

    private native String getExplosionTypeName(int var1);

    private native void analyzeTerrain();

    private native int getMapWidth();

    private native int getMapHeight();

    private native String getMapName();

    private native String getMapHash();

    private native int[] getHeightData();

    private native int[] getWalkableData();

    private native int[] getBuildableData();

    private native int[] getChokePoints();

    private native int[] getRegions();

    private native int[] getPolygon(int var1);

    private native int[] getBaseLocations();

    public native boolean attackMove(int var1, int var2, int var3);

    public native boolean attackUnit(int var1, int var2);

    public native boolean build(int var1, int var2, int var3, int var4);

    public native boolean buildAddon(int var1, int var2);

    public native boolean train(int var1, int var2);

    public native boolean morph(int var1, int var2);

    public native boolean research(int var1, int var2);

    public native boolean upgrade(int var1, int var2);

    public native boolean setRallyPoint(int var1, int var2, int var3);

    public native boolean setRallyPoint(int var1, int var2);

    public native boolean move(int var1, int var2, int var3);

    public native boolean patrol(int var1, int var2, int var3);

    public native boolean holdPosition(int var1);

    public native boolean stop(int var1);

    public native boolean follow(int var1, int var2);

    public native boolean gather(int var1, int var2);

    public native boolean returnCargo(int var1);

    public native boolean repair(int var1, int var2);

    public native boolean burrow(int var1);

    public native boolean unburrow(int var1);

    public native boolean cloak(int var1);

    public native boolean decloak(int var1);

    public native boolean siege(int var1);

    public native boolean unsiege(int var1);

    public native boolean lift(int var1);

    public native boolean land(int var1, int var2, int var3);

    public native boolean load(int var1, int var2);

    public native boolean unload(int var1, int var2);

    public native boolean unloadAll(int var1);

    public native boolean unloadAll(int var1, int var2, int var3);

    public native boolean rightClick(int var1, int var2, int var3);

    public native boolean rightClick(int var1, int var2);

    public native boolean haltConstruction(int var1);

    public native boolean cancelConstruction(int var1);

    public native boolean cancelAddon(int var1);

    public native boolean cancelTrain(int var1);

    public native boolean cancelTrain(int var1, int var2);

    public native boolean cancelMorph(int var1);

    public native boolean cancelResearch(int var1);

    public native boolean cancelUpgrade(int var1);

    public native boolean useTech(int var1, int var2);

    public native boolean useTech(int var1, int var2, int var3, int var4);

    public native boolean useTech(int var1, int var2, int var3);

    public native void drawHealth(boolean var1);

    public native void drawTargets(boolean var1);

    public native void drawIDs(boolean var1);

    public native void enableUserInput();

    public native void enablePerfectInformation();

    public native void setGameSpeed(int var1);

    public native void setCameraLocation(int var1, int var2);

    public native void pingMinimap(int var1, int var2);

    public native void leaveGame();

    public native void restartGame();

    public native int getFPS();

    public native int getAverageFPS();

    public native void sendText(String var1);

    public native void drawBox(int var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7);

    public native void drawCircle(int var1, int var2, int var3, int var4, boolean var5, boolean var6);

    public native void drawLine(int var1, int var2, int var3, int var4, int var5, boolean var6);

    public native void drawDot(int var1, int var2, int var3, boolean var4);

    public native void drawText(int var1, int var2, String var3, boolean var4);

    public UnitType getUnitType(int unitID) {
        return this.unitTypes.get(unitID);
    }

    public TechType getTechType(int techID) {
        return this.techTypes.get(techID);
    }

    public UpgradeType getUpgradeType(int upgradeID) {
        return this.upgradeTypes.get(upgradeID);
    }

    public WeaponType getWeaponType(int weaponID) {
        return this.weaponTypes.get(weaponID);
    }

    public UnitSizeType getUnitSizeType(int sizeID) {
        return this.unitSizeTypes.get(sizeID);
    }

    public BulletType getBulletType(int bulletID) {
        return this.bulletTypes.get(bulletID);
    }

    public DamageType getDamageType(int damageID) {
        return this.damageTypes.get(damageID);
    }

    public ExplosionType getExplosionType(int explosionID) {
        return this.explosionTypes.get(explosionID);
    }

    public Collection<UnitType> unitTypes() {
        return this.unitTypes.values();
    }

    public Collection<TechType> techTypes() {
        return this.techTypes.values();
    }

    public Collection<UpgradeType> upgradeTypes() {
        return this.upgradeTypes.values();
    }

    public Collection<WeaponType> weaponTypes() {
        return this.weaponTypes.values();
    }

    public Collection<UnitSizeType> unitSizeTypes() {
        return this.unitSizeTypes.values();
    }

    public Collection<BulletType> bulletTypes() {
        return this.bulletTypes.values();
    }

    public Collection<DamageType> damageTypes() {
        return this.damageTypes.values();
    }

    public Collection<ExplosionType> explosionTypes() {
        return this.explosionTypes.values();
    }

    public int getFrameCount() {
        return this.gameFrame;
    }

    public Player getSelf() {
        return this.self;
    }

    public Collection<Player> getPlayers() {
        return this.players.values();
    }

    public Player getPlayer(int playerID) {
        return this.players.get(playerID);
    }

    public ArrayList<Player> getAllies() {
        return this.allies;
    }

    public ArrayList<Player> getEnemies() {
        return this.enemies;
    }

    public Unit getUnit(int unitID) {
        return this.units.get(unitID);
    }

    public Collection<Unit> getAllUnits() {
        return this.units.values();
    }

    public ArrayList<Unit> getMyUnits() {
        return this.playerUnits;
    }

    public ArrayList<Unit> getAlliedUnits() {
        return this.alliedUnits;
    }

    public ArrayList<Unit> getEnemyUnits() {
        return this.enemyUnits;
    }

    public ArrayList<Unit> getNeutralUnits() {
        return this.neutralUnits;
    }

    public ArrayList<Unit> getGeysers() {
        return this.geysers;
    }

    public Map getMap() {
        return this.map;
    }

    public void loadTypeData() {
        int[] unitTypeData = this.getUnitTypes();
        int index = 0;
        while (index < unitTypeData.length) {
            UnitType type = new UnitType(unitTypeData, index);
            type.setName(this.getUnitTypeName(type.getID()));
            this.unitTypes.put(type.getID(), type);
            index += 56;
        }
        int[] techTypeData = this.getTechTypes();
        int index2 = 0;
        while (index2 < techTypeData.length) {
            TechType type = new TechType(techTypeData, index2);
            type.setName(this.getTechTypeName(type.getID()));
            this.techTypes.put(type.getID(), type);
            index2 += 10;
        }
        int[] upgradeTypeData = this.getUpgradeTypes();
        int index3 = 0;
        while (index3 < upgradeTypeData.length) {
            UpgradeType type = new UpgradeType(upgradeTypeData, index3);
            type.setName(this.getUpgradeTypeName(type.getID()));
            this.upgradeTypes.put(type.getID(), type);
            index3 += 10;
        }
        int[] weaponTypeData = this.getWeaponTypes();
        int index4 = 0;
        while (index4 < weaponTypeData.length) {
            WeaponType type = new WeaponType(weaponTypeData, index4);
            type.setName(this.getWeaponTypeName(type.getID()));
            this.weaponTypes.put(type.getID(), type);
            index4 += 24;
        }
        int[] unitSizeTypeData = this.getUnitSizeTypes();
        int index5 = 0;
        while (index5 < unitSizeTypeData.length) {
            UnitSizeType type = new UnitSizeType(unitSizeTypeData, index5);
            type.setName(this.getUnitSizeTypeName(type.getID()));
            this.unitSizeTypes.put(type.getID(), type);
            ++index5;
        }
        int[] bulletTypeData = this.getBulletTypes();
        int index6 = 0;
        while (index6 < bulletTypeData.length) {
            BulletType type = new BulletType(bulletTypeData, index6);
            type.setName(this.getBulletTypeName(type.getID()));
            this.bulletTypes.put(type.getID(), type);
            ++index6;
        }
        int[] damageTypeData = this.getDamageTypes();
        int index7 = 0;
        while (index7 < damageTypeData.length) {
            DamageType type = new DamageType(damageTypeData, index7);
            type.setName(this.getDamageTypeName(type.getID()));
            this.damageTypes.put(type.getID(), type);
            ++index7;
        }
        int[] explosionTypeData = this.getExplosionTypes();
        int index8 = 0;
        while (index8 < explosionTypeData.length) {
            ExplosionType type = new ExplosionType(explosionTypeData, index8);
            type.setName(this.getExplosionTypeName(type.getID()));
            this.explosionTypes.put(type.getID(), type);
            ++index8;
        }
    }

    public void loadMapData(boolean enableBWTA) {
        this.map = new Map(this.getMapWidth(), this.getMapHeight(), this.getMapName(), this.getMapHash(), this.getHeightData(), this.getBuildableData(), this.getWalkableData());
        if (!enableBWTA) {
            return;
        }
        File bwtaFile = new File("bwta/" + this.map.getHash());
        boolean analyzed = bwtaFile.exists();
        int[] regionData = null;
        int[] chokePointData = null;
        int[] baseLocationData = null;
        HashMap<Integer, int[]> polygons = new HashMap<Integer, int[]>();
        if (!analyzed) {
            this.analyzeTerrain();
            regionData = this.getRegions();
            chokePointData = this.getChokePoints();
            baseLocationData = this.getBaseLocations();
            int index = 0;
            while (index < regionData.length) {
                int id = regionData[index];
                polygons.put(id, this.getPolygon(id));
                index += 3;
            }
            try {
                int val;
                BufferedWriter writer = new BufferedWriter(new FileWriter(bwtaFile));
                boolean first = true;
                int[] nArray = regionData;
                int n = regionData.length;
                int n2 = 0;
                while (n2 < n) {
                    val = nArray[n2];
                    if (first) {
                        first = false;
                        writer.write("" + val);
                    } else {
                        writer.write("," + val);
                    }
                    ++n2;
                }
                writer.write("\n");
                first = true;
                nArray = chokePointData;
                n = chokePointData.length;
                n2 = 0;
                while (n2 < n) {
                    val = nArray[n2];
                    if (first) {
                        first = false;
                        writer.write("" + val);
                    } else {
                        writer.write("," + val);
                    }
                    ++n2;
                }
                writer.write("\n");
                first = true;
                nArray = baseLocationData;
                n = baseLocationData.length;
                n2 = 0;
                while (n2 < n) {
                    val = nArray[n2];
                    if (first) {
                        first = false;
                        writer.write("" + val);
                    } else {
                        writer.write("," + val);
                    }
                    ++n2;
                }
                writer.write("\n");
                Iterator iterator = polygons.keySet().iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    writer.write("" + id);
                    int[] nArray2 = (int[])polygons.get(id);
                    int n3 = nArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int val2 = nArray2[n4];
                        writer.write("," + val2);
                        ++n4;
                    }
                    writer.write("\n");
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(bwtaFile));
                String[] regions = reader.readLine().split(",");
                regionData = new int[regions.length];
                int i = 0;
                while (i < regions.length) {
                    regionData[i] = Integer.parseInt(regions[i]);
                    ++i;
                }
                String[] chokePoints = reader.readLine().split(",");
                chokePointData = new int[chokePoints.length];
                int i2 = 0;
                while (i2 < chokePoints.length) {
                    chokePointData[i2] = Integer.parseInt(chokePoints[i2]);
                    ++i2;
                }
                String[] baseLocations = reader.readLine().split(",");
                baseLocationData = new int[baseLocations.length];
                int i3 = 0;
                while (i3 < baseLocations.length) {
                    baseLocationData[i3] = Integer.parseInt(baseLocations[i3]);
                    ++i3;
                }
                String line = reader.readLine();
                while (line != null) {
                    String[] coordinates = line.split(",");
                    int[] coordinateData = new int[coordinates.length - 1];
                    int i4 = 1;
                    while (i4 < coordinates.length) {
                        coordinateData[i4 - 1] = Integer.parseInt(coordinates[i4]);
                        ++i4;
                    }
                    polygons.put(Integer.parseInt(coordinates[0]), coordinateData);
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        HashMap<Integer, Region> regionMap = new HashMap<Integer, Region>();
        int index = 0;
        while (index < regionData.length) {
            Region region = new Region(regionData, index);
            region.setCoordinates((int[])polygons.get(region.getID()));
            this.map.getRegions().add(region);
            regionMap.put(region.getID(), region);
            index += 3;
        }
        index = 0;
        while (index < chokePointData.length) {
            ChokePoint chokePoint = new ChokePoint(chokePointData, index);
            chokePoint.setFirstRegion((Region)regionMap.get(chokePoint.getFirstRegionID()));
            chokePoint.setSecondRegion((Region)regionMap.get(chokePoint.getSecondRegionID()));
            this.map.getChokePoints().add(chokePoint);
            index += 9;
        }
        index = 0;
        while (index < baseLocationData.length) {
            BaseLocation baseLocation = new BaseLocation(baseLocationData, index);
            this.map.getBaseLocations().add(baseLocation);
            index += 10;
        }
        for (Region region : this.map.getRegions()) {
            for (ChokePoint chokePoint : this.map.getChokePoints()) {
                if (!chokePoint.getFirstRegion().equals(region) && !chokePoint.getSecondRegion().equals(region)) continue;
                region.getChokePoints().add(chokePoint);
                region.getConnectedRegions().add(chokePoint.getOtherRegion(region));
            }
        }
    }

    public JNIBWAPI(BWAPIEventListener listener) {
        this.listener = listener;
    }

    public void start() {
        this.startClient(this);
    }

    public void javaPrint(String msg) {
        try {
            System.out.println("Bridge: " + msg);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void connected() {
        try {
            this.listener.connected();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void gameStarted() {
        try {
            this.allies.clear();
            this.enemies.clear();
            this.players.clear();
            int[] playerData = this.getPlayerInfo();
            int index = 0;
            while (index < playerData.length) {
                Player player = new Player(playerData, index);
                this.players.put(player.getID(), player);
                if (player.isSelf()) {
                    this.self = player;
                } else if (player.isAlly()) {
                    this.allies.add(player);
                } else if (player.isEnemy()) {
                    this.enemies.add(player);
                }
                index += 8;
            }
            this.units.clear();
            this.playerUnits.clear();
            this.alliedUnits.clear();
            this.enemyUnits.clear();
            this.neutralUnits.clear();
            this.geysers.clear();
            int[] unitData = this.getUnits();
            int index2 = 0;
            while (index2 < unitData.length) {
                int id = unitData[index2];
                Unit unit = new Unit(id);
                unit.update(unitData, index2);
                this.units.put(id, unit);
                if (unit.getTypeID() == UnitType.UnitTypes.Resource_Vespene_Geyser.ordinal()) {
                    this.geysers.add(unit);
                } else {
                    Player player = this.players.get(unit.getPlayerID());
                    if (player.isSelf()) {
                        this.playerUnits.add(unit);
                    } else if (player.isNeutral()) {
                        this.neutralUnits.add(unit);
                    } else if (player.isAlly()) {
                        this.alliedUnits.add(unit);
                    } else if (player.isEnemy()) {
                        this.enemyUnits.add(unit);
                    }
                }
                index2 += 112;
            }
            this.listener.gameStarted();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void menuUpdate(int frameCount) {
        this.listener.menuUpdate(frameCount);
    }

    private void gameUpdate() {
        try {
            if (this.gameFrame == this.getGameFrame()) {
                return;
            }
            this.gameFrame = this.getGameFrame();
            this.self.update(this.getPlayerUpdate());
            this.self.updateResearch(this, this.getResearchStatus(), this.getUpgradeStatus());
            int[] unitData = this.getUnits();
            HashSet<Integer> deadUnits = new HashSet<Integer>(this.units.keySet());
            ArrayList<Unit> playerList = new ArrayList<Unit>();
            ArrayList<Unit> alliedList = new ArrayList<Unit>();
            ArrayList<Unit> enemyList = new ArrayList<Unit>();
            ArrayList<Unit> neutralList = new ArrayList<Unit>();
            int index = 0;
            while (index < unitData.length) {
                int id = unitData[index];
                deadUnits.remove(id);
                Unit unit = this.units.get(id);
                if (unit == null) {
                    unit = new Unit(id);
                    this.units.put(id, unit);
                }
                unit.update(unitData, index);
                Player player = this.players.get(unit.getPlayerID());
                if (player.isSelf()) {
                    playerList.add(unit);
                } else if (player.isNeutral()) {
                    neutralList.add(unit);
                } else if (player.isAlly()) {
                    alliedList.add(unit);
                } else if (player.isEnemy()) {
                    enemyList.add(unit);
                }
                index += 112;
            }
            this.playerUnits = playerList;
            this.alliedUnits = alliedList;
            this.enemyUnits = enemyList;
            this.neutralUnits = neutralList;
            for (Integer unitID : deadUnits) {
                this.units.remove(unitID);
            }
            this.listener.gameUpdate();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void gameEnded() {
        try {
            this.listener.gameEnded();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void eventOccured(int type, int param1, int param2) {
        try {
            switch (type) {
                case 0: {
                    this.listener.matchEnded(param1 == 1);
                    break;
                }
                case 1: {
                    this.listener.playerLeft(param1);
                    break;
                }
                case 2: {
                    this.listener.nukeDetect(param2, param2);
                    break;
                }
                case 3: {
                    this.listener.nukeDetect();
                    break;
                }
                case 4: {
                    this.listener.unitDiscover(param1);
                    break;
                }
                case 5: {
                    this.listener.unitEvade(param1);
                    break;
                }
                case 6: {
                    this.listener.unitShow(param1);
                    break;
                }
                case 7: {
                    this.listener.unitHide(param1);
                    break;
                }
                case 8: {
                    this.listener.unitCreate(param1);
                    break;
                }
                case 9: {
                    this.listener.unitDestroy(param1);
                    break;
                }
                case 10: {
                    this.listener.unitMorph(param1);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void keyPressed(int keyCode) {
        try {
            this.listener.keyPressed(keyCode);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public ArrayList<PlayerScore> playerScores() {
        ArrayList<PlayerScore> scores = new ArrayList<PlayerScore>();
        int[] playerData = this.getPlayerScores();
        int index = 0;
        while (index < playerData.length) {
            scores.add(new PlayerScore(playerData, index));
            index += 11;
        }
        return scores;
    }
}

