/*
 * Decompiled with CFR 0.152.
 */
package eisbot.proxy;

import eisbot.proxy.BWAPIEventListener;
import eisbot.proxy.JNIBWAPI;
import eisbot.proxy.model.Unit;
import eisbot.proxy.types.UnitType;
import java.util.HashSet;
import java.util.Iterator;

public class ExampleAIClient
implements BWAPIEventListener {
    private JNIBWAPI bwapi;
    private HashSet<Integer> claimed = new HashSet();
    private boolean morphedDrone = false;
    private int poolDrone = -1;
    private int supplyCap = 0;

    public static void main(String[] args) {
        new ExampleAIClient();
    }

    public ExampleAIClient() {
        this.bwapi = new JNIBWAPI(this);
        this.bwapi.start();
    }

    @Override
    public void menuUpdate(int menuFrame) {
    }

    @Override
    public void connected() {
        this.bwapi.loadTypeData();
    }

    @Override
    public void gameStarted() {
        System.out.println("Game Started");
        this.bwapi.enableUserInput();
        this.bwapi.enablePerfectInformation();
        this.bwapi.setGameSpeed(0);
        this.bwapi.loadMapData(true);
        this.claimed.clear();
        this.morphedDrone = false;
        this.poolDrone = -1;
        this.supplyCap = 0;
    }

    @Override
    public void gameUpdate() {
        Iterator<Unit> iterator;
        for (Unit unit : this.bwapi.getMyUnits()) {
            if (unit.getTypeID() != UnitType.UnitTypes.Zerg_Larva.ordinal() || this.bwapi.getSelf().getMinerals() < 50 || this.morphedDrone) continue;
            this.bwapi.morph(unit.getID(), UnitType.UnitTypes.Zerg_Drone.ordinal());
            this.morphedDrone = true;
        }
        block1: for (Unit unit : this.bwapi.getMyUnits()) {
            if (unit.getTypeID() != UnitType.UnitTypes.Zerg_Drone.ordinal() || !unit.isIdle() || unit.getID() == this.poolDrone) continue;
            iterator = this.bwapi.getNeutralUnits().iterator();
            while (iterator.hasNext()) {
                double distance;
                Unit minerals = iterator.next();
                if (minerals.getTypeID() != UnitType.UnitTypes.Resource_Mineral_Field.ordinal() || this.claimed.contains(minerals.getID()) || !((distance = Math.sqrt(Math.pow(minerals.getX() - unit.getX(), 2.0) + Math.pow(minerals.getY() - unit.getY(), 2.0))) < 300.0)) continue;
                this.bwapi.rightClick(unit.getID(), minerals.getID());
                this.claimed.add(minerals.getID());
                continue block1;
            }
        }
        if (this.bwapi.getSelf().getMinerals() >= 200 && this.poolDrone < 0) {
            for (Unit unit : this.bwapi.getMyUnits()) {
                if (unit.getTypeID() != UnitType.UnitTypes.Zerg_Drone.ordinal()) continue;
                this.poolDrone = unit.getID();
                break;
            }
            for (Unit unit : this.bwapi.getMyUnits()) {
                if (unit.getTypeID() != UnitType.UnitTypes.Zerg_Overlord.ordinal()) continue;
                this.bwapi.build(this.poolDrone, unit.getTileX(), unit.getTileY(), UnitType.UnitTypes.Zerg_Spawning_Pool.ordinal());
            }
        }
        if (this.bwapi.getSelf().getSupplyUsed() + 2 >= this.bwapi.getSelf().getSupplyTotal() && this.bwapi.getSelf().getSupplyTotal() > this.supplyCap) {
            if (this.bwapi.getSelf().getMinerals() >= 100) {
                for (Unit larva : this.bwapi.getMyUnits()) {
                    if (larva.getTypeID() != UnitType.UnitTypes.Zerg_Larva.ordinal()) continue;
                    this.bwapi.morph(larva.getID(), UnitType.UnitTypes.Zerg_Overlord.ordinal());
                    this.supplyCap = this.bwapi.getSelf().getSupplyTotal();
                }
            }
        } else if (this.bwapi.getSelf().getMinerals() >= 50) {
            for (Unit unit : this.bwapi.getMyUnits()) {
                if (unit.getTypeID() != UnitType.UnitTypes.Zerg_Spawning_Pool.ordinal() || !unit.isCompleted()) continue;
                iterator = this.bwapi.getMyUnits().iterator();
                while (iterator.hasNext()) {
                    Unit larva = iterator.next();
                    if (larva.getTypeID() != UnitType.UnitTypes.Zerg_Larva.ordinal()) continue;
                    this.bwapi.morph(larva.getID(), UnitType.UnitTypes.Zerg_Zergling.ordinal());
                }
            }
        }
        for (Unit unit : this.bwapi.getMyUnits()) {
            if (unit.getTypeID() != UnitType.UnitTypes.Zerg_Zergling.ordinal() || !unit.isIdle() || !(iterator = this.bwapi.getEnemyUnits().iterator()).hasNext()) continue;
            Unit enemy = iterator.next();
            this.bwapi.attackMove(unit.getID(), enemy.getX(), enemy.getY());
        }
    }

    @Override
    public void gameEnded() {
    }

    @Override
    public void keyPressed(int keyCode) {
    }

    @Override
    public void matchEnded(boolean winner) {
    }

    @Override
    public void nukeDetect(int x, int y) {
    }

    @Override
    public void nukeDetect() {
    }

    @Override
    public void playerLeft(int id) {
    }

    @Override
    public void unitCreate(int unitID) {
    }

    @Override
    public void unitDestroy(int unitID) {
    }

    @Override
    public void unitDiscover(int unitID) {
    }

    @Override
    public void unitEvade(int unitID) {
    }

    @Override
    public void unitHide(int unitID) {
    }

    @Override
    public void unitMorph(int unitID) {
    }

    @Override
    public void unitShow(int unitID) {
    }
}

