/*
 * Decompiled with CFR 0.152.
 */
package eisbot.gui;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.Game;
import eisbot.abl.wmes.SquadWME;
import eisbot.proxy.command.Command;
import eisbot.proxy.command.CommandListener;
import eisbot.proxy.filter.ParticleWME;
import eisbot.proxy.wmes.ChokePointWME;
import eisbot.proxy.wmes.MapWME;
import eisbot.proxy.wmes.RegionWME;
import eisbot.proxy.wmes.StartingLocationWME;
import eisbot.proxy.wmes.unit.AllyUnitWME;
import eisbot.proxy.wmes.unit.EnemyUnitWME;
import eisbot.proxy.wmes.unit.GeyserWME;
import eisbot.proxy.wmes.unit.MineralWME;
import eisbot.proxy.wmes.unit.NeutralUnitWME;
import eisbot.proxy.wmes.unit.PlayerUnitWME;
import eisbot.proxy.wmes.unit.UnitWME;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JPanel;

public class StarCraftFrame
extends JPanel
implements MouseWheelListener,
MouseMotionListener,
MouseListener,
CommandListener {
    private static boolean drawIDs = true;
    private static boolean drawPings = false;
    private static boolean drawPlayerUnits = true;
    private static boolean drawEnemyUnits = true;
    private static boolean drawNeutralUnits = true;
    private static boolean drawResources = true;
    private static boolean drawStartSpots = true;
    private static boolean drawRegions = true;
    private static boolean fillRegions = false;
    private static boolean drawChokepoints = true;
    private Game game;
    private int tileSize = 6;
    private int panelHeight = 30;
    private int textSize = 10;
    private boolean running = true;
    private boolean influenceMap = false;
    private double scale = 1.0;
    private double tx = 0.0;
    private double ty = 0.0;
    public int mx = 0;
    public int my = 0;
    private boolean mouseDown = false;
    long lastRedraw = 0L;
    double scaleAmmount = 0.9;
    private ArrayList<Order> orders = new ArrayList();

    public StarCraftFrame(Game game) {
        this.game = game;
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        new Thread(){

            @Override
            public void run() {
                while (StarCraftFrame.this.running) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    StarCraftFrame.this.repaint();
                }
            }
        }.start();
    }

    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void paint(Graphics g) {
        if (System.currentTimeMillis() > 1000L + this.lastRedraw) {
            this.orders.clear();
        }
        this.lastRedraw = System.currentTimeMillis();
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(Color.BLACK);
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2.translate(this.tx, this.ty);
        g2.scale(this.scale, this.scale);
        if (!this.influenceMap) {
            MapWME map = this.game.getMap();
            int y = 0;
            while (y < map.getMapHeight()) {
                int x = 0;
                while (x < map.getMapWidth()) {
                    int n;
                    int buildable;
                    int n2 = map.isWalkable(x, y) ? 1 : 0;
                    int c = 70 * n2 + 60 * (buildable = map.isBuildable(x, y) ? 1 : 0) + 50 * (n = map.getHeight(x, y));
                    if (c < 0) {
                        c = 0;
                    } else if (c > 255) {
                        c = 255;
                    }
                    g.setColor(new Color(c, c, c * 3 / 4));
                    g.fillRect(x * this.tileSize, this.panelHeight + y * this.tileSize, this.tileSize, this.tileSize);
                    ++x;
                }
                ++y;
            }
            if (drawRegions) {
                g.setColor(Color.ORANGE);
                int j = 0;
                for (RegionWME region : this.game.getRegions()) {
                    g.setColor(Color.ORANGE);
                    if (fillRegions) {
                        if (j % 2 == 0) {
                            g.setColor(Color.CYAN);
                        } else {
                            g.setColor(Color.BLUE);
                        }
                    }
                    int[] x = region.getPointsX();
                    int[] nArray = region.getPointsY();
                    int i = 1;
                    while (i < x.length) {
                        g.drawLine(x[i - 1] / 32 * this.tileSize, this.panelHeight + nArray[i - 1] / 32 * this.tileSize, x[i] / 32 * this.tileSize, this.panelHeight + nArray[i] / 32 * this.tileSize);
                        ++i;
                    }
                    ++j;
                }
            }
            if (drawChokepoints) {
                g.setColor(Color.MAGENTA.darker());
                for (ChokePointWME chokepoint : this.game.getChokePoints()) {
                    g.drawArc(chokepoint.getX() * this.tileSize - chokepoint.getWidth() / 32 * this.tileSize / 2, this.panelHeight + chokepoint.getY() * this.tileSize - chokepoint.getWidth() / 32 * this.tileSize / 2, chokepoint.getWidth() / 32 * this.tileSize, chokepoint.getWidth() / 32 * this.tileSize, 0, 360);
                }
            }
            if (drawStartSpots) {
                g.setColor(Color.ORANGE);
                for (StartingLocationWME location : this.game.getStartingLocations()) {
                    g.fillRect(location.getX() * this.tileSize, this.panelHeight + location.getY() * this.tileSize, 4 * this.tileSize, 3 * this.tileSize);
                }
            }
            if (drawResources) {
                g.setColor(new Color(0, 255, 255));
                for (MineralWME unit : this.game.getMinerals()) {
                    g.fillRect(unit.getX() * this.tileSize, this.panelHeight + unit.getY() * this.tileSize, this.tileSize, this.tileSize);
                }
            }
            if (drawResources) {
                g.setColor(new Color(0, 128, 0));
                for (GeyserWME unit : this.game.getGeysers()) {
                    g.fillRect(unit.getX() * this.tileSize, this.panelHeight + unit.getY() * this.tileSize, unit.getType().getTileWidth() * this.tileSize, unit.getType().getTileHeight() * this.tileSize);
                }
            }
            if (drawEnemyUnits) {
                for (ParticleWME unit : this.game.getParticleFilter().getParticles()) {
                    g.setColor(new Color((float)Math.max(0.0, unit.getWeight()), 0.0f, (float)Math.max(0.0, unit.getWeight())));
                    g.fillRect(unit.getX() * this.tileSize, this.panelHeight + unit.getY() * this.tileSize, unit.getType().getTileWidth() * this.tileSize, unit.getType().getTileHeight() * this.tileSize);
                }
                g.setColor(new Color(255, 0, 0));
                for (EnemyUnitWME unit : this.game.getEnemyUnits()) {
                    g.fillRect(unit.getX() * this.tileSize, this.panelHeight + unit.getY() * this.tileSize, unit.getType().getTileWidth() * this.tileSize, unit.getType().getTileHeight() * this.tileSize);
                }
            }
            if (drawPlayerUnits) {
                g.setColor(Color.YELLOW);
                for (AllyUnitWME unit : this.game.getAllyUnits()) {
                    g.fillRect(unit.getX() * this.tileSize, this.panelHeight + unit.getY() * this.tileSize, unit.getType().getTileWidth() * this.tileSize, unit.getType().getTileHeight() * this.tileSize);
                }
            }
            if (drawNeutralUnits) {
                g.setColor(Color.GRAY);
                for (NeutralUnitWME unit : this.game.getNeutralUnits()) {
                    g.fillRect(unit.getX() * this.tileSize, this.panelHeight + unit.getY() * this.tileSize, unit.getType().getTileWidth() * this.tileSize, unit.getType().getTileHeight() * this.tileSize);
                }
            }
            if (drawPlayerUnits) {
                g.setColor(new Color(0, 255, 0));
                for (PlayerUnitWME unit : this.game.getPlayerUnits()) {
                    g.fillRect(unit.getX() * this.tileSize, this.panelHeight + unit.getY() * this.tileSize, unit.getType().getTileWidth() * this.tileSize, unit.getType().getTileHeight() * this.tileSize);
                }
            }
            if (drawIDs) {
                g.setColor(new Color(255, 255, 255));
                g.setFont(new Font("ariel", 0, this.textSize));
                for (UnitWME unit : this.game.getUnits()) {
                    g.drawString("" + unit.getID(), unit.getX() * this.tileSize, this.panelHeight + unit.getY() * this.tileSize + this.textSize - 2);
                }
            }
            LinkedList squads = ABLStarCraftBot.getBehavingEntity().getWorkingMemory().lookupWME("SquadWME");
            g.setColor(new Color(255, 255, 255));
            for (Object obj : squads) {
                SquadWME squad = (SquadWME)obj;
                g.fillRect((squad.getTargetX() - 1) * this.tileSize, this.panelHeight + (squad.getTargetY() - 1) * this.tileSize, 3 * this.tileSize, 3 * this.tileSize);
            }
            if (drawPings) {
                g.setColor(Color.YELLOW);
                ArrayList<Order> remove = new ArrayList<Order>();
                for (Order order : new ArrayList<Order>(this.orders)) {
                    ++order.timer;
                    if (order.timer > 15) {
                        remove.add(order);
                    }
                    int n = order.x * this.tileSize + this.tileSize / 2;
                    int y3 = this.panelHeight + order.y * this.tileSize + this.tileSize / 2;
                    g2.drawLine(n + 3 * order.timer, y3 - (25 - order.timer), n + 3 * order.timer, y3 + (25 - order.timer));
                    g2.drawLine(n - 3 * order.timer, y3 - (25 - order.timer), n - 3 * order.timer, y3 + (25 - order.timer));
                    g2.drawLine(n - 20, y3 + 3 * order.timer, n + (25 - order.timer), y3 + 3 * order.timer);
                    g2.drawLine(n - 20, y3 - 3 * order.timer, n + (25 - order.timer), y3 - 3 * order.timer);
                }
                ArrayList<Order> arrayList = this.orders;
                synchronized (arrayList) {
                    this.orders.removeAll(remove);
                }
            }
        } else {
            void var8_54;
            Double influence;
            int y;
            int x;
            double dist;
            int dx;
            int dy;
            int w = this.game.getMap().getMapWidth();
            int h = this.game.getMap().getMapHeight();
            HashMap<Integer, Double> playerInfluence = new HashMap<Integer, Double>();
            HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
            HashMap<Integer, Double> allyInfluence = new HashMap<Integer, Double>();
            for (UnitWME unitWME : this.game.getPlayerUnits()) {
                dy = -5;
                while (dy <= 5) {
                    dx = -5;
                    while (dx <= 5) {
                        dist = Math.sqrt(dx * dx + dy * dy);
                        x = unitWME.getX() + dx;
                        y = unitWME.getY() + dy;
                        influence = (Double)playerInfluence.get(y * w + x);
                        influence = influence != null ? influence : 0.0;
                        if (dist == 0.0) {
                            influence = influence + 0.5;
                        } else if (dist > 0.0 && dist < 5.0) {
                            influence = influence + 0.5 / dist;
                        }
                        influence = Math.min(1.0, influence);
                        playerInfluence.put(y * w + x, influence);
                        ++dx;
                    }
                    ++dy;
                }
            }
            for (UnitWME unitWME : this.game.getEnemyUnits()) {
                dy = -5;
                while (dy <= 5) {
                    dx = -5;
                    while (dx <= 5) {
                        dist = Math.sqrt(dx * dx + dy * dy);
                        x = unitWME.getX() + dx;
                        y = unitWME.getY() + dy;
                        influence = (Double)hashMap.get(y * w + x);
                        influence = influence != null ? influence : 0.0;
                        if (dist == 0.0) {
                            influence = influence + 0.5;
                        } else if (dist > 0.0 && dist < 5.0) {
                            influence = influence + 0.5 / dist;
                        }
                        influence = Math.min(1.0, influence);
                        hashMap.put(y * w + x, influence);
                        ++dx;
                    }
                    ++dy;
                }
            }
            for (UnitWME unitWME : this.game.getAllyUnits()) {
                dy = -5;
                while (dy <= 5) {
                    dx = -5;
                    while (dx <= 5) {
                        dist = Math.sqrt(dx * dx + dy * dy);
                        x = unitWME.getX() + dx;
                        y = unitWME.getY() + dy;
                        influence = (Double)allyInfluence.get(y * w + x);
                        influence = influence != null ? influence : 0.0;
                        if (dist == 0.0) {
                            influence = influence + 0.5;
                        } else if (dist > 0.0 && dist < 5.0) {
                            influence = influence + 0.5 / dist;
                        }
                        influence = Math.min(1.0, influence);
                        allyInfluence.put(y * w + x, influence);
                        ++dx;
                    }
                    ++dy;
                }
            }
            boolean bl = false;
            while (var8_54 < h) {
                int x2 = 0;
                while (x2 < w) {
                    void position = var8_54 * w + x2;
                    Double pInfluence = (Double)playerInfluence.get((int)position);
                    Double eInfluence = (Double)hashMap.get((int)position);
                    Double aInfluence = (Double)allyInfluence.get((int)position);
                    pInfluence = pInfluence != null ? pInfluence : 0.0;
                    eInfluence = eInfluence != null ? eInfluence : 0.0;
                    aInfluence = aInfluence != null ? aInfluence : 0.0;
                    g.setColor(new Color((float)eInfluence.doubleValue(), (float)pInfluence.doubleValue(), (float)aInfluence.doubleValue()));
                    g.fillRect(x2 * this.tileSize, this.panelHeight + var8_54 * this.tileSize, this.tileSize, this.tileSize);
                    ++x2;
                }
                ++var8_54;
            }
        }
        g2.scale(1.0 / this.scale, 1.0 / this.scale);
        g2.translate(-this.tx, -this.ty);
        g.setColor(new Color(255, 255, 255));
        g.setFont(new Font("ariel", 0, 12));
        g.fillRect(0, 0, this.getWidth(), this.panelHeight);
        g.setColor(new Color(125, 125, 125));
        g.drawLine(0, this.panelHeight, this.getWidth(), this.panelHeight);
        g.setColor(new Color(0, 0, 255));
        g.fillRect(5, 10, 10, 10);
        g.setColor(new Color(0, 0, 0));
        g.drawRect(5, 10, 10, 10);
        g.setColor(new Color(0, 0, 0));
        g.drawString("" + this.game.getPlayer().getMinerals(), 25, 20);
        g.setColor(new Color(0, 255, 0));
        g.fillRect(105, 10, 10, 10);
        g.setColor(new Color(0, 0, 0));
        g.drawRect(105, 10, 10, 10);
        g.setColor(new Color(0, 0, 0));
        g.drawString("" + this.game.getPlayer().getGas(), 125, 20);
        g.setColor(new Color(0, 0, 0));
        g.drawString(String.valueOf(this.game.getPlayer().getSupplyUsed() / 2) + "/" + this.game.getPlayer().getSupplyTotal() / 2, 200, 20);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        try {
            if (e.getWheelRotation() > 0) {
                double screenX = e.getX();
                double screenY = e.getY();
                AffineTransform transform = new AffineTransform();
                transform.translate(this.tx, this.ty);
                transform.scale(this.scale, this.scale);
                double[] src = new double[]{screenX, screenY};
                double[] dest1 = new double[2];
                transform.inverseTransform(src, 0, dest1, 0, 1);
                this.scale *= this.scaleAmmount;
                screenX = e.getX();
                screenY = e.getY();
                transform = new AffineTransform();
                transform.translate(this.tx, this.ty);
                transform.scale(this.scale, this.scale);
                src = new double[]{screenX, screenY};
                double[] dest2 = new double[2];
                transform.inverseTransform(src, 0, dest2, 0, 1);
                this.tx += (dest2[0] - dest1[0]) * this.scale;
                this.ty += (dest2[1] - dest1[1]) * this.scale;
            } else {
                double screenX = e.getX();
                double screenY = e.getY();
                AffineTransform transform = new AffineTransform();
                transform.translate(this.tx, this.ty);
                transform.scale(this.scale, this.scale);
                double[] src = new double[]{screenX, screenY};
                double[] dest1 = new double[2];
                transform.inverseTransform(src, 0, dest1, 0, 1);
                this.scale /= this.scaleAmmount;
                screenX = e.getX();
                screenY = e.getY();
                transform = new AffineTransform();
                transform.translate(this.tx, this.ty);
                transform.scale(this.scale, this.scale);
                src = new double[]{screenX, screenY};
                double[] dest2 = new double[2];
                transform.inverseTransform(src, 0, dest2, 0, 1);
                this.tx += (dest2[0] - dest1[0]) * this.scale;
                this.ty += (dest2[1] - dest1[1]) * this.scale;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouseDown) {
            double dx = e.getX() - this.mx;
            double dy = e.getY() - this.my;
            this.tx += dx;
            this.ty += dy;
            this.mx = e.getX();
            this.my = e.getY();
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.mouseDown = true;
            this.mx = e.getX();
            this.my = e.getY();
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            this.mouseDown = false;
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event(Command command) {
        ArrayList<Order> arrayList = this.orders;
        synchronized (arrayList) {
            switch (command.getCommand()) {
                case attackMove: {
                    this.orders.add(new Order(command.getArg0() / 32, command.getArg1() / 32));
                    break;
                }
                case attackUnit: {
                    UnitWME target = ABLStarCraftBot.getGame().getUnitByID(command.getArg0());
                    if (target == null) break;
                    this.orders.add(new Order(target.getX(), target.getY()));
                    break;
                }
                case rightClick: {
                    this.orders.add(new Order(command.getArg0() / 32, command.getArg1() / 32));
                    break;
                }
                case rightClickUnit: {
                    UnitWME target = ABLStarCraftBot.getGame().getUnitByID(command.getArg0());
                    if (target == null) break;
                    this.orders.add(new Order(target.getX(), target.getY()));
                    break;
                }
                case train: {
                    UnitWME target = ABLStarCraftBot.getGame().getUnitByID(command.getUnitID());
                    if (target == null) break;
                    this.orders.add(new Order(target.getX(), target.getY()));
                    break;
                }
                case build: {
                    this.orders.add(new Order(command.getArg0(), command.getArg1()));
                    break;
                }
                case buildAddon: {
                    UnitWME target = ABLStarCraftBot.getGame().getUnitByID(command.getUnitID());
                    if (target == null) break;
                    this.orders.add(new Order(target.getX(), target.getY()));
                    break;
                }
                case research: {
                    UnitWME target = ABLStarCraftBot.getGame().getUnitByID(command.getUnitID());
                    if (target == null) break;
                    this.orders.add(new Order(target.getX(), target.getY()));
                    break;
                }
                case upgrade: {
                    UnitWME target = ABLStarCraftBot.getGame().getUnitByID(command.getUnitID());
                    if (target == null) break;
                    this.orders.add(new Order(target.getX(), target.getY()));
                    break;
                }
                case stop: {
                    UnitWME target = ABLStarCraftBot.getGame().getUnitByID(command.getUnitID());
                    if (target == null) break;
                    this.orders.add(new Order(target.getX(), target.getY()));
                    break;
                }
                case holdPosition: {
                    UnitWME target = ABLStarCraftBot.getGame().getUnitByID(command.getUnitID());
                    if (target == null) break;
                    this.orders.add(new Order(target.getX(), target.getY()));
                    break;
                }
                case patrol: {
                    this.orders.add(new Order(command.getArg0() / 32, command.getArg1() / 32));
                    break;
                }
                case follow: {
                    UnitWME target = ABLStarCraftBot.getGame().getUnitByID(command.getArg0());
                    if (target == null) break;
                    this.orders.add(new Order(target.getX(), target.getY()));
                    break;
                }
                case siege: {
                    UnitWME target = ABLStarCraftBot.getGame().getUnitByID(command.getUnitID());
                    if (target == null) break;
                    this.orders.add(new Order(target.getX(), target.getY()));
                    break;
                }
                case unsiege: {
                    UnitWME target = ABLStarCraftBot.getGame().getUnitByID(command.getUnitID());
                    if (target == null) break;
                    this.orders.add(new Order(target.getX(), target.getY()));
                    break;
                }
                case useTechPosition: {
                    this.orders.add(new Order(command.getArg1() / 32, command.getArg2() / 32));
                    break;
                }
                case useTechTarget: {
                    UnitWME target = ABLStarCraftBot.getGame().getUnitByID(command.getArg0());
                    if (target == null) break;
                    this.orders.add(new Order(target.getX(), target.getY()));
                }
            }
        }
    }

    public JPanel getLayerPanel() {
        JPanel panel = new JPanel();
        JButton idButton = new JButton("Unit IDs");
        idButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                drawIDs = !drawIDs;
            }
        });
        JButton pingButton = new JButton("Pings");
        pingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                drawPings = !drawPings;
            }
        });
        JButton playerButton = new JButton("Units");
        playerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                drawPlayerUnits = !drawPlayerUnits;
            }
        });
        JButton enemyButton = new JButton("Enemies");
        enemyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                drawEnemyUnits = !drawEnemyUnits;
            }
        });
        JButton resourcesButton = new JButton("Resources");
        resourcesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                drawResources = !drawResources;
            }
        });
        JButton startSpotButton = new JButton("Start Spots");
        startSpotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                drawStartSpots = !drawStartSpots;
            }
        });
        JButton regionsButton = new JButton("Regions");
        regionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                drawRegions = !drawRegions;
                drawChokepoints = !drawChokepoints;
            }
        });
        JButton fillRegionsButton = new JButton("Fill Regions");
        fillRegionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fillRegions = !fillRegions;
            }
        });
        JButton influenceButton = new JButton("Influence");
        influenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StarCraftFrame.this.influenceMap = !StarCraftFrame.this.influenceMap;
            }
        });
        panel.add(idButton);
        panel.add(pingButton);
        panel.add(playerButton);
        panel.add(enemyButton);
        panel.add(resourcesButton);
        panel.add(startSpotButton);
        panel.add(regionsButton);
        panel.add(fillRegionsButton);
        panel.add(influenceButton);
        return panel;
    }

    private class Order {
        int timer = -5;
        int x;
        int y;

        public Order(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

