/*
 * Decompiled with CFR 0.152.
 */
package eisbot.gui;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.Game;
import eisbot.abl.wmes.ReconWME;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;

public class ReconPanel
extends JPanel {
    boolean repaintQueued = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Game game = ABLStarCraftBot.getGame();
        ReconWME recon = game.getRecon();
        if (recon == null) {
            return;
        }
        ReconWME reconWME = recon;
        synchronized (reconWME) {
            g.setColor(Color.BLACK);
            int x = 15;
            int y = 25;
            g.drawString("Player Units", x, y);
            g.drawString("-----------------------------", x, y += 18);
            TreeMap<String, Integer> types = new TreeMap<String, Integer>();
            for (Map.Entry<Integer, Integer> entry : recon.getPlayerCounts().entrySet()) {
                types.put(game.getUnitTypes().get(entry.getKey()).getName(), entry.getValue());
            }
            for (String string : types.keySet()) {
                g.drawString(String.valueOf(string) + ": " + types.get(string), x, y += 18);
            }
            types.clear();
            for (Integer n : recon.getEnemyTypes()) {
                types.put(game.getUnitTypes().get(n).getName(), 0);
            }
            y = 25;
            g.drawString("Enemy Units", x += 200, y);
            g.drawString("-----------------------------", x, y += 18);
            for (String string : types.keySet()) {
                g.drawString(string, x, y += 18);
            }
        }
        if (!this.repaintQueued) {
            this.repaintQueued = true;
            new Thread(){

                @Override
                public void run() {
                    try {
                        1.sleep(1000L);
                        ReconPanel.this.repaintQueued = false;
                        ReconPanel.this.repaint();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
        }
    }
}

