/*
 * Decompiled with CFR 0.152.
 */
package eisbot.gui;

import eisbot.abl.LogListener;
import eisbot.abl.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class LoggingPanel
extends JTabbedPane
implements LogListener {
    HashMap<String, LogTopic> panels = new HashMap();
    public static final String INVALID = "Other";

    public LoggingPanel() {
        LogTopic topic = new LogTopic(INVALID);
        this.panels.put(INVALID, topic);
        this.addTab(INVALID, topic);
    }

    @Override
    public void onLogMessage(String domain, String text) {
        LogTopic topic = this.panels.get(domain);
        boolean valid = Logger.isValidDomain(domain);
        if (valid) {
            if (topic == null) {
                topic = new LogTopic(domain);
                this.panels.put(domain, topic);
                this.addTab(domain, topic);
            }
        } else {
            topic = this.panels.get(INVALID);
        }
        topic.onMessage(text);
    }

    public class LogTopic
    extends JPanel {
        JTextArea textPane = null;
        ArrayList<String> commands = new ArrayList();
        int listSize = 20;
        String domain;

        public LogTopic(String domain) {
            this.setLayout(new BorderLayout());
            this.domain = domain;
            this.textPane = new JTextArea();
            this.add((Component)this.textPane, "West");
        }

        public void onMessage(String text) {
            this.commands.add(text);
            while (this.commands.size() > this.listSize) {
                this.commands.remove(0);
            }
            this.update();
        }

        public void update() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("\n");
            buffer.append("   " + this.domain + "\n");
            buffer.append("   ---------------------------------------------\n");
            for (String message : this.commands) {
                buffer.append("   " + message + "\n");
            }
            this.textPane.setText(buffer.toString());
        }
    }
}

