/*
 * Decompiled with CFR 0.152.
 */
package eisbot.gui;

import abl.runtime.BehavingEntity;
import abl.runtime.BehavingListener;
import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ABLPanel
extends JPanel
implements BehavingListener {
    private int updates = 0;
    private long lastUpdate = System.currentTimeMillis();
    private JLabel label = new JLabel("ABL is running");
    private boolean running = true;

    public ABLPanel() {
        this.setLayout(new BorderLayout());
        JButton pause = new JButton("Pause ABL");
        pause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BehavingEntity behavingEntity = ABLStarCraftBot.getBehavingEntity();
                if (behavingEntity != null) {
                    if (behavingEntity.isPaused()) {
                        behavingEntity.unpause();
                        ABLPanel.this.label.setText("ABL is running");
                        Logger.print("GUI", "Un-pausing ABL");
                        ABLPanel.this.running = true;
                    } else {
                        behavingEntity.pause();
                        ABLPanel.this.label.setText("ABL is paused");
                        Logger.print("GUI", "Pausing ABL");
                        ABLPanel.this.running = false;
                    }
                }
            }
        });
        this.add((Component)pause, "West");
        this.add((Component)this.label, "East");
    }

    @Override
    public void onBehave(Hashtable executingSteps, Set leafSteps) {
        ++this.updates;
        if (System.currentTimeMillis() > this.lastUpdate + 1000L) {
            this.lastUpdate = System.currentTimeMillis();
            if (this.running) {
                this.label.setText("ABL is running: " + this.updates + " (" + leafSteps.size() + "," + executingSteps.size() + ")");
            }
            this.updates = 0;
        }
    }
}

