/*
 * Decompiled with CFR 0.152.
 */
package eisbot.abl.wmes;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.wmes.ScoutingWME;
import eisbot.proxy.wmes.unit.UnitWME;
import java.util.ArrayList;
import wm.WME;

public class UnitQueryWME
extends WME {
    int srcx = -1;
    int srcy = -1;
    int dstx = -1;
    int dsty = -1;
    int type = -1;
    int playerID = -1;
    boolean enemy = false;
    boolean worker = false;
    boolean center = false;
    boolean flying = false;
    boolean ground = false;
    ScoutingWME scoutingwme = null;
    static final double MAX_BFS_DISTANCE = 50.0;
    double distance = Double.MAX_VALUE;
    ArrayList<UnitWME> allUnits = null;

    public boolean setLocation(int x, int y) {
        this.srcx = x;
        this.srcy = y;
        return true;
    }

    public boolean setLocationPixels(int x, int y) {
        this.srcx = x / 32;
        this.srcy = y / 32;
        return true;
    }

    public boolean setLocationUnit(int unitID) {
        UnitWME unit = ABLStarCraftBot.getGame().getUnitByID(unitID);
        if (unit == null) {
            return false;
        }
        this.srcx = unit.getX();
        this.srcy = unit.getY();
        return true;
    }

    public boolean setDestination(int x, int y) {
        this.dstx = x;
        this.dsty = y;
        return true;
    }

    public boolean setType(int type) {
        this.type = type;
        return true;
    }

    public boolean setIsCenter(boolean iscenter) {
        this.center = iscenter;
        return true;
    }

    public boolean setIsWorker(boolean isworker) {
        this.worker = isworker;
        return true;
    }

    public boolean setIsEnemy(boolean isenemy) {
        this.enemy = isenemy;
        return true;
    }

    public boolean setIsFlying(boolean isflying) {
        this.flying = isflying;
        return true;
    }

    public boolean setIsGround(boolean isground) {
        this.ground = isground;
        return true;
    }

    public boolean setPlayer(int playerID) {
        this.playerID = playerID;
        return true;
    }

    public boolean setPlayerMe() {
        this.playerID = ABLStarCraftBot.getGame().getPlayer().getPlayerID();
        return true;
    }

    private void update() {
        this.distance = Double.MAX_VALUE;
        this.allUnits = ABLStarCraftBot.getGame().getUnits();
    }

    public boolean getFresh() {
        this.srcx = -1;
        this.srcy = -1;
        this.dstx = -1;
        this.dsty = -1;
        this.type = -1;
        this.playerID = -1;
        this.enemy = false;
        this.worker = false;
        this.center = false;
        this.flying = false;
        this.ground = false;
        return true;
    }

    public double getDistance() {
        return this.distance;
    }

    public int getNearest() {
        return this.getNearestEuclidian();
    }

    public int getNearestEuclidian() {
        UnitWME nearest = null;
        this.update();
        for (UnitWME unit : this.allUnits) {
            double dist;
            if (!this.meetsConditions(unit) || !((dist = UnitQueryWME.distance(unit.getX(), unit.getY(), this.srcx, this.srcy)) < this.distance)) continue;
            this.distance = dist;
            nearest = unit;
        }
        if (nearest != null) {
            return nearest.getID();
        }
        return -1;
    }

    public boolean setScoutingWME(ScoutingWME wme) {
        this.scoutingwme = wme;
        return true;
    }

    public static final double distance(int sx, int sy, int dx, int dy) {
        if (sx < 0 || sy < 0 || dx < 0 || dy < 0) {
            return Double.MAX_VALUE;
        }
        return Math.sqrt(Math.pow(dx - sx, 2.0) + Math.pow(dy - sy, 2.0));
    }

    public final double getFlightDistance() {
        return Math.sqrt(Math.pow(this.srcx - this.dstx, 2.0) + Math.pow(this.srcy - this.dsty, 2.0));
    }

    private final boolean meetsConditions(UnitWME unit) {
        if (this.type != -1 && this.type != unit.getTypeID()) {
            return false;
        }
        if (this.playerID != -1 && this.playerID != unit.getPlayerID()) {
            return false;
        }
        if (this.center && !unit.getIsCenter()) {
            return false;
        }
        if (this.worker && !unit.getIsWorker()) {
            return false;
        }
        if (this.enemy && (this.playerID == unit.getPlayerID() || ABLStarCraftBot.getGame().getPlayerByID(unit.getPlayerID()).isAlly())) {
            return false;
        }
        if (this.flying && !unit.getIsAirborne()) {
            return false;
        }
        return !this.ground || !unit.getIsAirborne();
    }
}

