/*
 * Decompiled with CFR 0.152.
 */
package eisbot.abl.wmes;

import eisbot.abl.StarCraftConstants;
import eisbot.proxy.wmes.UnitTypeWME;
import wm.WME;

public class TrainUnitWME
extends WME {
    protected int type;
    protected int whatBuilds;
    protected int addOnType = -1;
    protected int priority;
    protected int mineralCost;
    protected int gasCost;
    protected int supplyCost;
    protected int buildAt = -1;
    protected int status = TrainingStatus.Request.ordinal();

    public TrainUnitWME() {
    }

    public TrainUnitWME(int type) {
        this.type = type;
        UnitTypeWME typeWME = UnitTypeWME.getType(type);
        this.whatBuilds = typeWME.getWhatBuilds();
        this.mineralCost = typeWME.getMineralsCost();
        this.supplyCost = typeWME.getSupplyRequired();
        this.gasCost = typeWME.getGasCost();
        this.status = TrainingStatus.Request.ordinal();
        if (typeWME.getFirstUnitReq() != -1) {
            if (UnitTypeWME.getType(typeWME.getFirstUnitReq()).isAddOn()) {
                this.addOnType = typeWME.getFirstUnitReq();
            } else if (typeWME.getSecondUnitReq() != -1 && UnitTypeWME.getType(typeWME.getSecondUnitReq()).isAddOn()) {
                this.addOnType = typeWME.getSecondUnitReq();
            }
        }
    }

    public TrainUnitWME(int type, int at) {
        this(type);
        this.buildAt = at;
    }

    public boolean getIsWorker() {
        return this.type == UnitTypeWME.UnitType.Protoss_Probe.ordinal() || this.type == UnitTypeWME.UnitType.Terran_SCV.ordinal() || this.type == UnitTypeWME.UnitType.Zerg_Drone.ordinal();
    }

    public int getType() {
        return this.type;
    }

    public int getAddOnType() {
        return this.addOnType;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void activate() {
        this.status = TrainingStatus.Active.ordinal();
    }

    public int getWhatBuilds() {
        return this.whatBuilds;
    }

    public void setWhatBuilds(int whatBuilds) {
        this.whatBuilds = whatBuilds;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getMineralCost() {
        return this.mineralCost;
    }

    public void setMineralCost(int mineralCost) {
        this.mineralCost = mineralCost;
    }

    public int getSupplyCost() {
        return this.supplyCost;
    }

    public int getGasCost() {
        return this.gasCost;
    }

    public void setGasCost(int gasCost) {
        this.gasCost = gasCost;
    }

    public int getBuilder() {
        return this.buildAt;
    }

    public void setBuilder(int builderID) {
        this.buildAt = builderID;
    }

    public static TrainUnitWME TrainWorkerWME(int race) {
        TrainUnitWME wme = new TrainUnitWME();
        wme.mineralCost = 50;
        wme.gasCost = 0;
        wme.priority = 0;
        switch (StarCraftConstants.Race.values()[race]) {
            case Protoss: {
                wme.type = UnitTypeWME.UnitType.Protoss_Probe.ordinal();
                wme.whatBuilds = UnitTypeWME.UnitType.Protoss_Nexus.ordinal();
                break;
            }
            case Terran: {
                wme.type = UnitTypeWME.UnitType.Terran_SCV.ordinal();
                wme.whatBuilds = UnitTypeWME.UnitType.Terran_Command_Center.ordinal();
                break;
            }
            case Zerg: {
                wme.type = UnitTypeWME.UnitType.Zerg_Drone.ordinal();
                wme.whatBuilds = UnitTypeWME.UnitType.Zerg_Larva.ordinal();
            }
        }
        return wme;
    }

    public static enum TrainingStatus {
        Request,
        Active;

    }
}

