/*
 * Decompiled with CFR 0.152.
 */
package eisbot.abl.wmes;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.Logger;
import eisbot.abl.wmes.UnitQueryWME;
import eisbot.proxy.wmes.StartingLocationWME;
import eisbot.proxy.wmes.unit.UnitWME;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Queue;
import tuple.Pair;
import wm.WME;

public class ScoutingWME
extends WME {
    protected int workerID = -1;
    protected Queue<Pair<Integer, Integer>> destinations = new LinkedList<Pair<Integer, Integer>>();
    protected boolean enroute = false;

    public int getWorkerID() {
        return this.workerID;
    }

    public void setWorkerID(int workerID) {
        this.workerID = workerID;
    }

    public void clearWorkerID() {
        this.workerID = -1;
    }

    public boolean getHasWorker() {
        return ABLStarCraftBot.getGame().getUnitByID(this.workerID) != null;
    }

    public int getNumDestinations() {
        return this.destinations.size();
    }

    public void clearDestinations() {
        this.destinations.clear();
    }

    public void pushDestination(int dstx, int dsty) {
        this.destinations.add(new Pair<Integer, Integer>(dstx, dsty));
    }

    public Pair<Integer, Integer> popDestination() {
        return this.destinations.remove();
    }

    public Pair<Integer, Integer> peekDestination() {
        return this.destinations.peek();
    }

    public int getNextX() {
        return (Integer)this.destinations.peek().fst;
    }

    public int getNextY() {
        return (Integer)this.destinations.peek().snd;
    }

    public boolean getArrived() {
        double dy;
        if (this.destinations.size() == 0) {
            return false;
        }
        Pair<Integer, Integer> dst = this.destinations.peek();
        UnitWME worker = ABLStarCraftBot.getGame().getUnitByID(this.workerID);
        double dx = worker.getX() - (Integer)dst.fst;
        return Math.sqrt(dx * dx + (dy = (double)(worker.getY() - (Integer)dst.snd)) * dy) < 3.0;
    }

    public boolean getEnroute() {
        return this.enroute;
    }

    public void setEnroute(boolean enr) {
        this.enroute = enr;
    }

    public boolean enqueueScoutStartingLocations(int unitx, int unity) {
        int fromx = unitx;
        int fromy = unity;
        ArrayList startingLocations = (ArrayList)ABLStarCraftBot.getGame().getStartingLocations().clone();
        StartingLocationWME sl = ABLStarCraftBot.getGame().getPlayerStart();
        startingLocations.remove(sl);
        ArrayList<Pair<Double, StartingLocationWME>> distances = new ArrayList<Pair<Double, StartingLocationWME>>();
        ArrayList<StartingLocationWME> visited = new ArrayList<StartingLocationWME>();
        while (visited.size() < startingLocations.size()) {
            int i = 0;
            while (i < startingLocations.size()) {
                sl = (StartingLocationWME)startingLocations.get(i);
                Logger.print("ScoutingWME", "Considering location (" + sl.getX() + ", " + sl.getY() + ") ...");
                if (visited.contains(sl)) {
                    Logger.print("ScoutingWME", "  ...visited!");
                } else {
                    distances.add(new Pair<Double, StartingLocationWME>(UnitQueryWME.distance(fromx, fromy, sl.getX(), sl.getY()), sl));
                    Logger.print("ScoutingWME", "  ...distance: " + ((Pair)distances.get((int)(distances.size() - 1))).fst);
                }
                ++i;
            }
            if (distances.size() == 0) {
                Logger.print("ScoutingWME", "  ...no locations left unvisited.");
                break;
            }
            Collections.sort(distances, new Comparator<Pair<Double, StartingLocationWME>>(){

                @Override
                public int compare(Pair<Double, StartingLocationWME> first, Pair<Double, StartingLocationWME> second) {
                    double val = (Double)first.fst - (Double)second.fst;
                    if (val < 0.0) {
                        return -1;
                    }
                    if (val > 0.0) {
                        return 1;
                    }
                    return 0;
                }
            });
            sl = (StartingLocationWME)((Pair)distances.get((int)0)).snd;
            Logger.print("ScoutingWME", "Closest: (" + sl.getX() + ", " + sl.getY() + ") at distance " + ((Pair)distances.get((int)0)).fst);
            visited.add(sl);
            distances.clear();
            Logger.print("ScoutingWME", "Enqueueing location (" + sl.getX() + ", " + sl.getY() + ")");
            this.pushDestination(sl.getX(), sl.getY());
            fromx = sl.getX();
            fromy = sl.getY();
        }
        return true;
    }
}

