/*
 * Decompiled with CFR 0.152.
 */
package eisbot.abl.wmes;

import eisbot.abl.Game;
import eisbot.proxy.wmes.UnitTypeWME;
import eisbot.proxy.wmes.unit.AllyUnitWME;
import eisbot.proxy.wmes.unit.EnemyUnitWME;
import eisbot.proxy.wmes.unit.PlayerUnitWME;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import wm.WME;

public class ReconWME
extends WME {
    Map<Integer, Integer> playerCounts;
    Map<Integer, Integer> allyCounts;
    Set<Integer> enemyTypes;
    HashSet<Integer> currentEnemyTypes = new HashSet();

    public ReconWME() {
        this.playerCounts = Collections.synchronizedMap(new HashMap());
        this.allyCounts = Collections.synchronizedMap(new HashMap());
        this.enemyTypes = Collections.synchronizedSet(new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Game game) {
        ReconWME reconWME = this;
        synchronized (reconWME) {
            Integer count;
            this.playerCounts.clear();
            for (PlayerUnitWME playerUnitWME : game.getPlayerUnits()) {
                if (!playerUnitWME.getActive()) continue;
                count = this.playerCounts.get(playerUnitWME.getTypeID());
                this.playerCounts.put(playerUnitWME.getTypeID(), 1 + (count != null ? count : 0));
            }
            this.allyCounts.clear();
            for (AllyUnitWME allyUnitWME : game.getAllyUnits()) {
                count = this.allyCounts.get(allyUnitWME.getTypeID());
                this.allyCounts.put(allyUnitWME.getTypeID(), 1 + (count != null ? count : 0));
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (EnemyUnitWME unit : game.getEnemyUnits()) {
                if (!unit.getActive()) continue;
                this.enemyTypes.add(unit.getTypeID());
                hashSet.add(unit.getTypeID());
                UnitTypeWME type = game.getUnitTypes().get(unit.getTypeID());
                if (type == null) continue;
                if (type.getWhatBuilds() != -1) {
                    this.enemyTypes.add(type.getWhatBuilds());
                }
                if (type.getFirstUnitReq() != -1) {
                    this.enemyTypes.add(type.getFirstUnitReq());
                }
                if (type.getSecondUnitReq() == -1) continue;
                this.enemyTypes.add(type.getSecondUnitReq());
            }
            this.currentEnemyTypes = hashSet;
        }
    }

    public boolean getEnemyCannons() {
        return this.currentEnemyTypes.contains(162);
    }

    public boolean getEnemySunkens() {
        return this.currentEnemyTypes.contains(146);
    }

    public boolean getEnemyBunkers() {
        return this.currentEnemyTypes.contains(125);
    }

    public boolean getEnemyTanks() {
        return this.currentEnemyTypes.contains(30) || this.currentEnemyTypes.contains(5);
    }

    public int getNumType(int type) {
        Integer count = this.playerCounts.get(type);
        if (count != null) {
            return count;
        }
        return 0;
    }

    public int getNumForces() {
        return this.getNumZealots() + this.getNumDragoons() + 3 * this.getNumCarriers();
    }

    public int getNumCarriers() {
        return this.getNumType(72);
    }

    public int getNumObs() {
        return this.getNumType(84);
    }

    public int getNumZealots() {
        return this.getNumType(65);
    }

    public int getNumDragoons() {
        return this.getNumType(66);
    }

    public int getNumProbes() {
        return this.getNumType(64);
    }

    public int getNumAssimilators() {
        return this.getNumType(157);
    }

    public int getMyNexusCount() {
        return this.getNumType(154);
    }

    public Set<Integer> getEnemyTypes() {
        return this.enemyTypes;
    }

    public Map<Integer, Integer> getPlayerCounts() {
        return this.playerCounts;
    }

    public boolean getEnemyCloakingTech() {
        return this.enemyTypes.contains(66) || this.enemyTypes.contains(164) || this.enemyTypes.contains(97) || this.enemyTypes.contains(103) || this.enemyTypes.contains(38) || this.enemyTypes.contains(135) || this.enemyTypes.contains(114) || this.enemyTypes.contains(8);
    }
}

