/*
 * Decompiled with CFR 0.152.
 */
package eisbot.abl.wmes;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.Game;
import eisbot.abl.StarCraftConstants;
import eisbot.proxy.wmes.UnitTypeWME;
import eisbot.proxy.wmes.unit.PlayerUnitWME;
import wm.WME;

public class ConstructionWME
extends WME {
    protected int status = ConstructionStatus.Request.ordinal();
    protected int workerID = -1;
    protected int type;
    protected int whatBuilds;
    protected int priority;
    protected int mineralCost;
    protected int gasCost;
    protected int x = -1;
    protected int y = -1;
    private boolean resourcesClaimed = false;

    public ConstructionWME() {
    }

    public ConstructionWME(int type) {
        this.type = type;
        UnitTypeWME typeWME = UnitTypeWME.getType(type);
        this.whatBuilds = typeWME.getWhatBuilds();
        this.mineralCost = typeWME.getMineralsCost();
        this.gasCost = typeWME.getGasCost();
    }

    public boolean getHasRequirements() {
        Game game = ABLStarCraftBot.getGame();
        UnitTypeWME typeWME = game.getUnitTypes().get(this.type);
        if (typeWME == null) {
            return false;
        }
        boolean firstMet = typeWME.getFirstUnitReq() == -1;
        boolean secondMet = typeWME.getSecondUnitReq() == -1;
        for (PlayerUnitWME unit : game.getPlayerUnits()) {
            if (!unit.getPowered()) continue;
            if (unit.getTypeID() == typeWME.getFirstUnitReq()) {
                firstMet = true;
            }
            if (unit.getTypeID() == typeWME.getSecondUnitReq()) {
                secondMet = true;
            }
            if (!firstMet || !secondMet) continue;
            return true;
        }
        return false;
    }

    public boolean getResourcesClaimed() {
        return this.resourcesClaimed;
    }

    public void setResourcesClaimed() {
        this.resourcesClaimed = true;
    }

    public boolean getIsFarm() {
        return this.type == UnitTypeWME.UnitType.Protoss_Pylon.ordinal() || this.type == UnitTypeWME.UnitType.Terran_Supply_Depot.ordinal() || this.type == UnitTypeWME.UnitType.Zerg_Overlord.ordinal();
    }

    public boolean getIsCenter() {
        return this.type == UnitTypeWME.UnitType.Protoss_Nexus.ordinal() || this.type == UnitTypeWME.UnitType.Terran_Command_Center.ordinal() || this.type == UnitTypeWME.UnitType.Zerg_Hatchery.ordinal() || this.type == UnitTypeWME.UnitType.Zerg_Lair.ordinal() || this.type == UnitTypeWME.UnitType.Zerg_Hive.ordinal();
    }

    public boolean isRefinery() {
        return this.type == UnitTypeWME.UnitType.Protoss_Assimilator.ordinal() || this.type == UnitTypeWME.UnitType.Terran_Refinery.ordinal() || this.type == UnitTypeWME.UnitType.Zerg_Extractor.ordinal();
    }

    public boolean getCanAddOn() {
        return UnitTypeWME.getType(this.type).canAddOn();
    }

    public int getBuildingClass() {
        return UnitTypeWME.getType(this.type).getBuildingClass().ordinal();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getWorkerID() {
        return this.workerID;
    }

    public void setWorkerID(int workerID) {
        this.workerID = workerID;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getWhatBuilds() {
        return this.whatBuilds;
    }

    public void setWhatBuilds(int whatBuilds) {
        this.whatBuilds = whatBuilds;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getMineralCost() {
        return this.mineralCost;
    }

    public void setMineralCost(int mineralCost) {
        this.mineralCost = mineralCost;
    }

    public int getGasCost() {
        return this.gasCost;
    }

    public void setGasCost(int gasCost) {
        this.gasCost = gasCost;
    }

    public static ConstructionWME FarmWME(int race) {
        ConstructionWME wme = new ConstructionWME();
        wme.mineralCost = 100;
        wme.gasCost = 0;
        wme.priority = 0;
        switch (StarCraftConstants.Race.values()[race]) {
            case Protoss: {
                wme.type = UnitTypeWME.UnitType.Protoss_Pylon.ordinal();
                wme.whatBuilds = UnitTypeWME.UnitType.Protoss_Probe.ordinal();
                break;
            }
            case Terran: {
                wme.type = UnitTypeWME.UnitType.Terran_Supply_Depot.ordinal();
                wme.whatBuilds = UnitTypeWME.UnitType.Terran_SCV.ordinal();
                break;
            }
            case Zerg: {
                wme.type = UnitTypeWME.UnitType.Zerg_Overlord.ordinal();
                wme.whatBuilds = UnitTypeWME.UnitType.Zerg_Larva.ordinal();
            }
        }
        return wme;
    }

    public static enum ConstructionStatus {
        Request,
        Prepare,
        Ready,
        Constructing,
        Paused,
        Finished;

    }
}

