/*
 * Decompiled with CFR 0.152.
 */
package eisbot.abl.wmes;

import abl.runtime.BehavingEntity;
import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.Logger;
import eisbot.abl.wmes.ConstructionWME;
import eisbot.proxy.wmes.BaseLocationWME;
import eisbot.proxy.wmes.MapWME;
import eisbot.proxy.wmes.StartingLocationWME;
import eisbot.proxy.wmes.UnitTypeWME;
import eisbot.proxy.wmes.unit.GeyserWME;
import eisbot.proxy.wmes.unit.MineralWME;
import eisbot.proxy.wmes.unit.PlayerUnitWME;
import eisbot.proxy.wmes.unit.UnitWME;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import tuple.Pair;
import wm.WME;

public class BuildLocationWME
extends WME {
    private int xLocation;
    private int yLocation;
    private static final int MAX_SEARCH_RANGE = 12;
    private static final int MIN_BUFFER_DISTANCE = 5;
    private static final int DESIRED_BUFFER_DISTANCE = 7;
    private static final int RESOURCE_EXTRA_BUFFER = 2;
    private MapWME mapWME;

    public boolean chooseAnyLocation(int typeID) {
        LinkedList buildings = BehavingEntity.getBehavingEntity().lookupWME(PlayerUnitWME.class.getSimpleName());
        LinkedList<PlayerUnitWME> toremove = new LinkedList<PlayerUnitWME>();
        for (PlayerUnitWME building : buildings) {
            if (building.getIsBuilding()) continue;
            toremove.add(building);
        }
        for (PlayerUnitWME remove : toremove) {
            buildings.remove(remove);
        }
        Collections.shuffle(buildings);
        for (PlayerUnitWME building : buildings) {
            if (!this.chooseLocation(building.getX(), building.getY(), typeID)) continue;
            return true;
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    public boolean chooseLocation(int x, int y, int typeID) {
        if (this.mapWME == null) {
            this.mapWME = ABLStarCraftBot.getGame().getMap();
        }
        UnitTypeWME type = UnitTypeWME.getType(typeID);
        int width = type.getTileWidth();
        int height = type.getTileHeight();
        if (typeID == 113) {
            width += 3;
        }
        if (typeID == 114) {
            width += 3;
        }
        if (typeID == 118) {
            width += 3;
        }
        Logger.print("BuildLocationWME", "Searching from (" + x + ", " + y + ")");
        LinkedList units = BehavingEntity.getBehavingEntity().lookupWME(PlayerUnitWME.class.getSimpleName());
        LinkedList minerals = BehavingEntity.getBehavingEntity().lookupWME(MineralWME.class.getSimpleName());
        LinkedList geysers = BehavingEntity.getBehavingEntity().lookupWME(GeyserWME.class.getSimpleName());
        LinkedList expolocs = BehavingEntity.getBehavingEntity().lookupWME(BaseLocationWME.class.getSimpleName());
        LinkedList projects = BehavingEntity.getBehavingEntity().lookupWME(ConstructionWME.class.getSimpleName());
        int buffer = 7;
        while (buffer >= 5) {
            int range = 0;
            while (range < 12) {
                int testy;
                int testx;
                ArrayList<Pair<Integer, Integer>> locs = new ArrayList<Pair<Integer, Integer>>();
                int ty = -range;
                while (ty <= range) {
                    int tx = -range;
                    while (tx <= range) {
                        if (Math.abs(tx) == range || Math.abs(ty) == range) {
                            testx = x + tx;
                            testy = y + ty;
                            locs.add(new Pair<Integer, Integer>(testx, testy));
                        }
                        ++tx;
                    }
                    ++ty;
                }
                Collections.shuffle(locs);
                block4: for (Pair loc : locs) {
                    testx = (Integer)loc.fst;
                    if (!this.mapWME.isBuildable(testx, testy = ((Integer)loc.snd).intValue(), width, height)) continue;
                    for (PlayerUnitWME unit : units) {
                        if (unit.distance(testx, testy) < (double)buffer) continue block4;
                    }
                    for (BaseLocationWME expo : expolocs) {
                        if (Math.pow(expo.getX() - testx, 2.0) + Math.pow(expo.getY() - testy, 2.0) < (double)(buffer * buffer)) continue block4;
                    }
                    for (ConstructionWME project : projects) {
                        if (Math.pow(project.getX() - testx, 2.0) + Math.pow(project.getY() - testy, 2.0) < (double)(buffer * buffer)) continue block4;
                    }
                    for (MineralWME min : minerals) {
                        if (min.distance(testx, testy) < (double)(buffer + 2)) continue block4;
                    }
                    for (GeyserWME gas : geysers) {
                        if (gas.distance(testx, testy) < (double)(buffer + 2)) continue block4;
                    }
                    Logger.print("BuildLocationWME", "Range: " + range);
                    Logger.print("BuildLocationWME", "Result " + testx + ":" + testy);
                    this.xLocation = testx;
                    this.yLocation = testy;
                    return true;
                }
                ++range;
            }
            --buffer;
        }
        Logger.print("BuildLocationWME", "No suitable build locaitons found near (" + x + ", " + y + ")");
        return false;
    }

    public boolean chooseExpansionLocation() {
        if (this.mapWME == null) {
            this.mapWME = ABLStarCraftBot.getGame().getMap();
        }
        final StartingLocationWME start = ABLStarCraftBot.getGame().getPlayerStart();
        StartingLocationWME enemyStart = ABLStarCraftBot.getGame().getEnemyStart();
        LinkedList units = BehavingEntity.getBehavingEntity().lookupWME(UnitWME.class.getSimpleName());
        ArrayList<BaseLocationWME> expansionLocations = ABLStarCraftBot.getGame().getBaseLocations();
        ArrayList<BaseLocationWME> valid = new ArrayList<BaseLocationWME>();
        block0: for (BaseLocationWME loc : expansionLocations) {
            for (UnitWME unit : units) {
                if (unit.distance(loc.getX(), loc.getY()) < 5.0) continue block0;
            }
            valid.add(loc);
        }
        Collections.sort(valid, new Comparator<BaseLocationWME>(){

            @Override
            public int compare(BaseLocationWME first, BaseLocationWME second) {
                return this.distance(start.getX(), start.getY(), first.getX(), first.getY()) - this.distance(start.getX(), start.getY(), second.getX(), second.getY());
            }

            private int distance(int x, int y, int x2, int y2) {
                return (int)(Math.pow(x2 - x, 2.0) + Math.pow(y2 - y, 2.0));
            }
        });
        valid.remove(0);
        if (valid.size() < 2) {
            Logger.print("BuildLocationWME", "No valid expansion locations found!");
            return false;
        }
        if (enemyStart == null) {
            this.xLocation = ((BaseLocationWME)valid.get(0)).getX();
            this.yLocation = ((BaseLocationWME)valid.get(0)).getY();
        } else if (Math.pow(((BaseLocationWME)valid.get(0)).getX() - enemyStart.getX(), 2.0) + Math.pow(((BaseLocationWME)valid.get(0)).getY() - enemyStart.getX(), 2.0) < Math.pow(((BaseLocationWME)valid.get(1)).getX() - enemyStart.getX(), 2.0) + Math.pow(((BaseLocationWME)valid.get(1)).getY() - enemyStart.getX(), 2.0)) {
            this.xLocation = ((BaseLocationWME)valid.get(0)).getX();
            this.yLocation = ((BaseLocationWME)valid.get(0)).getY();
        } else {
            this.xLocation = ((BaseLocationWME)valid.get(1)).getX();
            this.yLocation = ((BaseLocationWME)valid.get(1)).getY();
        }
        return true;
    }

    public int getXLocation() {
        return this.xLocation;
    }

    public int getYLocation() {
        return this.yLocation;
    }
}

