/*
 * Decompiled with CFR 0.152.
 */
package eisbot.abl.wmes;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.Logger;
import eisbot.proxy.wmes.unit.MineralWME;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import wm.WME;

public class AllMineralsWME
extends WME {
    ArrayList<Patch> patches = new ArrayList();
    HashSet<Integer> claimed = new HashSet();
    HashMap<Integer, Integer> assigned = new HashMap();
    HashMap<Integer, Integer> centerAssignments = new HashMap();
    private int maxPatchDistance = 5;
    int px;
    int py;

    public AllMineralsWME() {
        ArrayList<MineralWME> fringe = new ArrayList<MineralWME>(ABLStarCraftBot.getGame().getMinerals());
        while (fringe.size() > 0) {
            HashSet<MineralWME> neighbors = new HashSet<MineralWME>();
            neighbors.add(fringe.remove(0));
            while (true) {
                HashSet<MineralWME> addSet = new HashSet<MineralWME>();
                for (MineralWME patchMineral : neighbors) {
                    for (MineralWME mineral : ABLStarCraftBot.getGame().getMinerals()) {
                        if (mineral == patchMineral || neighbors.contains(mineral) || Math.abs(patchMineral.getX() - mineral.getX()) > this.maxPatchDistance || Math.abs(patchMineral.getY() - mineral.getY()) > this.maxPatchDistance) continue;
                        addSet.add(mineral);
                        fringe.remove(mineral);
                    }
                }
                if (addSet.size() <= 0) break;
                neighbors.addAll(addSet);
            }
            int centerX = 0;
            int centerY = 0;
            for (MineralWME mineral : neighbors) {
                centerX += mineral.getX();
                centerY += mineral.getY();
            }
            Patch patch = new Patch();
            patch.centerX = centerX / neighbors.size();
            patch.centerY = centerY / neighbors.size();
            patch.minerals = new HashSet(neighbors);
            this.patches.add(patch);
        }
        Logger.print("AllMineralsWME", "Num patches: " + this.patches.size());
        for (Patch patch : this.patches) {
            Logger.print("AllMineralsWME", String.valueOf(patch.centerX) + " " + patch.centerY);
            Logger.print("AllMineralsWME", "Mineral patch size: " + patch.minerals.size());
            for (MineralWME min : patch.minerals) {
                Logger.print("AllMineralsWME", "  " + min.getID());
            }
        }
    }

    public void setClaimed(int unitID, int mineralID, int centerID) {
        this.assigned.put(unitID, mineralID);
        this.centerAssignments.put(unitID, centerID);
        this.claimed.add(mineralID);
    }

    public void unAssign(int unitID) {
        Integer patch = this.assigned.remove(unitID);
        this.centerAssignments.remove(unitID);
        if (patch != null) {
            this.claimed.remove(patch);
        }
    }

    public boolean isAssigned(int unitID) {
        return this.assigned.containsKey(unitID);
    }

    public int getNumWorkers(int centerID) {
        int count = 0;
        for (int workerID : this.centerAssignments.keySet()) {
            if (this.centerAssignments.get(workerID) != centerID) continue;
            ++count;
        }
        return count;
    }

    public double getSaturation(int centerID) {
        int workers = 0;
        int numMinerals = 0;
        HashSet<Integer> minerals = new HashSet<Integer>();
        HashSet<Patch> nearbyPatches = new HashSet<Patch>();
        for (int workerID : this.centerAssignments.keySet()) {
            if (this.centerAssignments.get(workerID) != centerID) continue;
            ++workers;
            minerals.add(this.assigned.get(workerID));
        }
        for (int mineralID : minerals) {
            for (Patch p : this.patches) {
                for (MineralWME m : p.minerals) {
                    if (m.getID() != mineralID) continue;
                    nearbyPatches.add(p);
                }
            }
        }
        for (Patch p : nearbyPatches) {
            numMinerals += p.minerals.size();
        }
        return (double)workers / (double)(numMinerals * 2);
    }

    public boolean setLocation(int x, int y) {
        this.px = x;
        this.py = y;
        return true;
    }

    public int getBestPatch() {
        return this.getBestPatch(this.px, this.py);
    }

    public int getBestPatch(int x, int y) {
        if (this.patches.size() == 0) {
            return -1;
        }
        Patch bestPatch = this.patches.get(0);
        double bestDistance = this.distance(bestPatch, x, y);
        for (Patch patch : this.patches) {
            double distance = this.distance(patch, x, y);
            if (!(distance < bestDistance)) continue;
            bestPatch = patch;
            bestDistance = distance;
        }
        ArrayList<MineralWME> free = new ArrayList<MineralWME>();
        for (MineralWME mineral : bestPatch.minerals) {
            if (this.claimed.contains(mineral.getID())) continue;
            free.add(mineral);
        }
        if (free.size() == 0) {
            for (MineralWME mineral : bestPatch.minerals) {
                this.claimed.remove(mineral.getID());
            }
            free.addAll(bestPatch.minerals);
        }
        int closest = -1;
        bestDistance = 1000.0;
        for (MineralWME mineral : free) {
            double distance = this.distance(mineral, x, y);
            if (!(distance < bestDistance)) continue;
            bestDistance = distance;
            closest = mineral.getID();
        }
        return closest;
    }

    private final double distance(MineralWME mineral, int x, int y) {
        double dx = mineral.getX() - x;
        double dy = mineral.getY() - y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private final double distance(Patch patch, int x, int y) {
        double dx = patch.centerX - x;
        double dy = patch.centerY - y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private class Patch {
        HashSet<MineralWME> minerals = new HashSet();
        int centerX;
        int centerY;

        private Patch() {
        }
    }
}

