/*
 * Decompiled with CFR 0.152.
 */
package eisbot.abl;

import eisbot.abl.LogListener;
import java.util.ArrayList;
import java.util.HashSet;

public class Logger {
    private static HashSet<String> disabledDomains = new HashSet();
    private static HashSet<String> validDomains = new HashSet();
    private static HashSet<String> categories = new HashSet();
    private static ArrayList<LogListener> listeners = new ArrayList();

    static {
        validDomains.add("ABL");
        validDomains.add("GUI");
        validDomains.add("ProxyBot");
        validDomains.add("ICCupRobot");
        validDomains.add("CBR");
        validDomains.add("AllMineralsWME");
        validDomains.add("SquadWME");
        validDomains.add("BuildLocationWME");
        validDomains.add("ScoutingWME");
        validDomains.add("LayoutAnalysisWME");
        validDomains.add("RegionWME");
        validDomains.add("MapWME");
        validDomains.add("StrategyManager");
        validDomains.add("ProductionManager");
        validDomains.add("WorkerManager");
        validDomains.add("SupplyManager");
        validDomains.add("ConstructionManager");
        validDomains.add("ScoutingManager");
        validDomains.add("OperationsManager");
        validDomains.add("VultureManager");
        categories.add("WME");
        categories.add("Manager");
        disabledDomains.add("ScoutingWME");
        disabledDomains.add("AllMineralsWME");
        disabledDomains.add("MapWME");
        disabledDomains.add("RegionWME");
    }

    public static void addListener(LogListener listener) {
        listeners.add(listener);
    }

    public static boolean isValidDomain(String domain) {
        return validDomains.contains(domain);
    }

    public static boolean print(String domain, String text) {
        for (LogListener listener : listeners) {
            listener.onLogMessage(domain, text);
        }
        if (disabledDomains.contains(domain)) {
            return true;
        }
        for (String s : categories) {
            if (!disabledDomains.contains(s) || !domain.contains(s)) continue;
            return true;
        }
        if (validDomains.contains(domain)) {
            System.out.println(String.valueOf(domain) + ": " + text);
        } else {
            System.out.println("(INVALID DOMAIN)" + domain + ": " + text);
        }
        return true;
    }
}

