/*
 * Decompiled with CFR 0.152.
 */
package eisbot.abl;

import eisbot.abl.ABLStarCraftBot;
import eisbot.abl.StarCraftConstants;
import eisbot.abl.wmes.ReconWME;
import eisbot.proxy.JNIBWAPI;
import eisbot.proxy.filter.NoMemoryFilter;
import eisbot.proxy.filter.ParticleFilter;
import eisbot.proxy.wmes.BaseLocationWME;
import eisbot.proxy.wmes.ChokePointWME;
import eisbot.proxy.wmes.MapWME;
import eisbot.proxy.wmes.PlayerWME;
import eisbot.proxy.wmes.RegionWME;
import eisbot.proxy.wmes.StartingLocationWME;
import eisbot.proxy.wmes.TechTypeWME;
import eisbot.proxy.wmes.UnitTypeWME;
import eisbot.proxy.wmes.UpgradeTypeWME;
import eisbot.proxy.wmes.unit.AllyUnitWME;
import eisbot.proxy.wmes.unit.EnemyUnitWME;
import eisbot.proxy.wmes.unit.GeyserWME;
import eisbot.proxy.wmes.unit.MineralWME;
import eisbot.proxy.wmes.unit.NeutralUnitWME;
import eisbot.proxy.wmes.unit.PlayerUnitWME;
import eisbot.proxy.wmes.unit.UnitWME;
import java.util.ArrayList;
import java.util.HashMap;

public class Game {
    private int playerID;
    private int playerRace;
    private PlayerWME player;
    private ArrayList<PlayerWME> enemies = new ArrayList();
    private ArrayList<PlayerWME> players;
    private PlayerWME[] playerArray = new PlayerWME[12];
    private MapWME map;
    private ArrayList<StartingLocationWME> startingLocations;
    private StartingLocationWME playerStart = null;
    private ArrayList<UnitWME> units = new ArrayList();
    private HashMap<Integer, UnitWME> unitMap = new HashMap();
    private HashMap<Integer, UnitTypeWME> unitTypes = UnitTypeWME.getUnitTypeMap();
    private ArrayList<TechTypeWME> techTypes = TechTypeWME.getTechTypes();
    private ArrayList<UpgradeTypeWME> upgradeTypes = UpgradeTypeWME.getUpgradeTypes();
    private long lastGameUpdate = 0L;
    private ArrayList<BaseLocationWME> baseLocations;
    private ArrayList<ChokePointWME> chokePoints;
    private ArrayList<RegionWME> regions;
    int frame = 0;
    private ParticleFilter particleFilter;
    private ReconWME recon = new ReconWME();

    public Game(JNIBWAPI bwapi) {
        this.playerID = bwapi.getSelf().getID();
        this.players = PlayerWME.getPlayers(bwapi);
        for (PlayerWME p : this.players) {
            if (this.playerID == p.getPlayerID()) {
                this.player = p;
                this.playerRace = StarCraftConstants.Race.valueOf(p.getRace()).ordinal();
            } else {
                this.enemies.add(p);
            }
            this.playerArray[p.getPlayerID()] = p;
        }
        if (!ABLStarCraftBot.IgnoreBases) {
            this.map = new MapWME(bwapi);
            this.startingLocations = StartingLocationWME.getLocations(bwapi);
            this.baseLocations = BaseLocationWME.getLocations(bwapi);
            this.regions = RegionWME.getRegions(this.map, bwapi);
            this.chokePoints = ChokePointWME.getLocations(bwapi, this.regions);
        }
        this.particleFilter = Boolean.getBoolean("ParticleFilter") ? new ParticleFilter(this, Boolean.getBoolean("IdentifyParticles"), false, Boolean.getBoolean("DefaultParticles"), Boolean.getBoolean("UseTargetVector")) : new NoMemoryFilter(this, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newBlockage(int x, int y) {
        NeutralUnitWME blockage = new NeutralUnitWME();
        blockage.setBlockage(this.getUnitTypes().get(89), x, y);
        ArrayList<UnitWME> arrayList = this.units;
        synchronized (arrayList) {
            this.units.add(blockage);
        }
    }

    public int getGameFrame() {
        return this.frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(JNIBWAPI bwapi) {
        this.frame = bwapi.getFrameCount();
        this.player.update(bwapi);
        this.lastGameUpdate = System.currentTimeMillis();
        ArrayList<UnitWME> arrayList = this.units;
        synchronized (arrayList) {
            this.units = UnitWME.getUnits(this, bwapi, this.unitTypes, this.playerID, this.playerArray);
            HashMap<Integer, UnitWME> newMap = new HashMap<Integer, UnitWME>();
            for (UnitWME unit : this.units) {
                newMap.put(unit.getID(), unit);
            }
            this.unitMap = newMap;
        }
        this.recon.update(this);
        if (!ABLStarCraftBot.IgnoreBases) {
            this.particleFilter.update(this);
        }
        for (UnitWME unit : this.units) {
            if (unit.getSpawnFrame() != 0) continue;
            unit.setSpawnFrame(this.frame);
        }
    }

    public long getLastGameUpdate() {
        return this.lastGameUpdate;
    }

    public ParticleFilter getParticleFilter() {
        return this.particleFilter;
    }

    public ReconWME getRecon() {
        return this.recon;
    }

    public PlayerWME getPlayer() {
        return this.player;
    }

    public ArrayList<PlayerWME> getEnemies() {
        return this.enemies;
    }

    public int getPlayerRace() {
        return this.playerRace;
    }

    public PlayerWME getPlayerByID(int id) {
        return this.playerArray[id];
    }

    public MapWME getMap() {
        return this.map;
    }

    public HashMap<Integer, UnitTypeWME> getUnitTypes() {
        return this.unitTypes;
    }

    public ArrayList<StartingLocationWME> getStartingLocations() {
        return this.startingLocations;
    }

    private void findPlayerStart() {
        if (this.playerStart != null) {
            return;
        }
        ArrayList<PlayerUnitWME> playerUnits = this.getPlayerUnits();
        for (PlayerUnitWME unit : playerUnits) {
            if (!unit.getIsCenter()) continue;
            for (StartingLocationWME start : this.startingLocations) {
                if (start.getX() != unit.getRealCenterX() / 32 || start.getY() != unit.getRealCenterY() / 32) continue;
                this.playerStart = start;
                return;
            }
        }
        this.playerStart = null;
    }

    public StartingLocationWME getPlayerStart() {
        this.findPlayerStart();
        return this.playerStart;
    }

    public StartingLocationWME getEnemyStart() {
        ArrayList<EnemyUnitWME> enemyUnits = this.getEnemyUnits();
        ArrayList<StartingLocationWME> startingLocations = this.getStartingLocations();
        for (EnemyUnitWME unit : enemyUnits) {
            if (!unit.getIsCenter()) continue;
            int i = 0;
            for (StartingLocationWME start : startingLocations) {
                if (start.getX() == unit.getRealCenterX() / 32 && start.getY() == unit.getRealCenterY() / 32) {
                    return start;
                }
                ++i;
            }
        }
        return null;
    }

    public ArrayList<UnitWME> getUnits() {
        return this.units;
    }

    public ArrayList<ChokePointWME> getChokePoints() {
        return this.chokePoints;
    }

    public ArrayList<RegionWME> getRegions() {
        return this.regions;
    }

    public ArrayList<BaseLocationWME> getBaseLocations() {
        return this.baseLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PlayerUnitWME> getPlayerUnits() {
        ArrayList<UnitWME> arrayList = this.units;
        synchronized (arrayList) {
            ArrayList<PlayerUnitWME> playerUnits = new ArrayList<PlayerUnitWME>();
            for (UnitWME unit : this.units) {
                if (!(unit instanceof PlayerUnitWME)) continue;
                playerUnits.add((PlayerUnitWME)unit);
            }
            return playerUnits;
        }
    }

    public UnitWME getUnitByID(int id) {
        return this.unitMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<EnemyUnitWME> getEnemyUnits() {
        ArrayList<UnitWME> arrayList = this.units;
        synchronized (arrayList) {
            ArrayList<EnemyUnitWME> enemyUnits = new ArrayList<EnemyUnitWME>();
            for (UnitWME unit : this.units) {
                if (!(unit instanceof EnemyUnitWME)) continue;
                enemyUnits.add((EnemyUnitWME)unit);
            }
            return enemyUnits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AllyUnitWME> getAllyUnits() {
        ArrayList<UnitWME> arrayList = this.units;
        synchronized (arrayList) {
            ArrayList<AllyUnitWME> allyUnits = new ArrayList<AllyUnitWME>();
            for (UnitWME unit : this.units) {
                if (!(unit instanceof AllyUnitWME)) continue;
                allyUnits.add((AllyUnitWME)unit);
            }
            return allyUnits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<NeutralUnitWME> getNeutralUnits() {
        ArrayList<UnitWME> arrayList = this.units;
        synchronized (arrayList) {
            ArrayList<NeutralUnitWME> neutralUnits = new ArrayList<NeutralUnitWME>();
            for (UnitWME unit : this.units) {
                if (!(unit instanceof NeutralUnitWME)) continue;
                neutralUnits.add((NeutralUnitWME)unit);
            }
            return neutralUnits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MineralWME> getMinerals() {
        ArrayList<UnitWME> arrayList = this.units;
        synchronized (arrayList) {
            ArrayList<MineralWME> minerals = new ArrayList<MineralWME>();
            for (UnitWME unit : this.units) {
                if (!(unit instanceof MineralWME)) continue;
                minerals.add((MineralWME)unit);
            }
            return minerals;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<GeyserWME> getGeysers() {
        ArrayList<UnitWME> arrayList = this.units;
        synchronized (arrayList) {
            ArrayList<GeyserWME> gas = new ArrayList<GeyserWME>();
            for (UnitWME unit : this.units) {
                if (!(unit instanceof GeyserWME)) continue;
                gas.add((GeyserWME)unit);
            }
            return gas;
        }
    }

    public ArrayList<TechTypeWME> getTechTypes() {
        return this.techTypes;
    }

    public ArrayList<UpgradeTypeWME> getUpgradeTypes() {
        return this.upgradeTypes;
    }
}

