/*
 * Decompiled with CFR 0.152.
 */
package eisbot.abl;

import abl.runtime.BehavingEntity;
import eisbot.abl.Game;
import eisbot.abl.Logger;
import eisbot.abl.wmes.KeyPressWME;
import eisbot.gui.ABLPanel;
import eisbot.gui.ABTViewer;
import eisbot.gui.CommandLogPanel;
import eisbot.gui.LoggingPanel;
import eisbot.gui.ReconPanel;
import eisbot.gui.SpeedPanel;
import eisbot.gui.StarCraftFrame;
import eisbot.gui.WMEPanel;
import eisbot.proxy.BWAPIEventListener;
import eisbot.proxy.ICCupRobot;
import eisbot.proxy.JNIBWAPI;
import eisbot.proxy.command.CommandQueue;
import eisbot.proxy.filter.ParticleFilter;
import eisbot.proxy.model.Unit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ABLStarCraftBot
implements BWAPIEventListener {
    private static ABLStarCraftBot thisInstance;
    private CommandQueue commandQueue = new CommandQueue();
    public static boolean IgnoreBases;
    private JNIBWAPI bwapi;
    private BehavingEntity ablBot;
    private Game game;
    private boolean autoCamera = false;
    private long lastCameraUpdate = 0L;
    private int drawBuildLocations = 0;
    private boolean drawParticles = false;
    private ICCupRobot robot;
    boolean iccup = false;
    private boolean showGUI = false;
    private boolean autoRestart = false;
    private boolean useManners = false;
    private boolean fastest = false;
    private boolean userInput = false;
    private boolean fogOfWar = false;
    private StarCraftFrame gameFrame;
    private SpeedPanel speedPanel = null;
    private WMEPanel wmePanel = null;
    private ABTViewer abtViewer;
    private JFrame mainFrame;
    private int delay = 0;
    private int quitFrame = 0;
    boolean shiftPressed = false;
    boolean drawHealth = false;
    boolean drawIDs = false;
    boolean drawTargets = false;
    boolean drawPylons = false;

    static {
        IgnoreBases = false;
    }

    public static void main(String[] args) {
        if (System.getProperty("ABLBotName") == null) {
            System.setProperty("ABLBotName", "ProtossBot");
        }
        new ABLStarCraftBot();
    }

    public ABLStarCraftBot() {
        thisInstance = this;
        this.initParticleFilterSettings();
        while (true) {
            if (this.iccup) {
                this.startRobot();
            }
            this.bwapi = new JNIBWAPI(this);
            this.bwapi.start();
            if (!this.iccup) continue;
            this.killStarCraft();
        }
    }

    private void initParticleFilterSettings() {
        ParticleFilter.ParticleFilterMode mode = ParticleFilter.ParticleFilterMode.PerfectInformation;
        try {
            mode = ParticleFilter.ParticleFilterMode.valueOf(System.getProperty("ParticleFilterMode"));
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        switch (mode) {
            case PerfectInformation: {
                this.fogOfWar = false;
                System.setProperty("ParticleFilter", "false");
                System.setProperty("IdentifyParticles", "false");
                System.setProperty("DefaultParticles", "false");
                System.setProperty("UseTargetVector", "false");
                break;
            }
            case NoMemoryParticles: {
                this.fogOfWar = true;
                System.setProperty("ParticleFilter", "false");
                System.setProperty("IdentifyParticles", "false");
                System.setProperty("DefaultParticles", "false");
                System.setProperty("UseTargetVector", "false");
                break;
            }
            case DefaultParticles: {
                this.fogOfWar = true;
                System.setProperty("ParticleFilter", "true");
                System.setProperty("IdentifyParticles", "false");
                System.setProperty("DefaultParticles", "true");
                System.setProperty("UseTargetVector", "false");
                break;
            }
            case OptimizedParticles: {
                this.fogOfWar = true;
                System.setProperty("ParticleFilter", "true");
                System.setProperty("IdentifyParticles", "false");
                System.setProperty("DefaultParticles", "false");
                System.setProperty("UseTargetVector", "false");
                break;
            }
            case DefaultIdentifyParticles: {
                this.fogOfWar = true;
                System.setProperty("ParticleFilter", "true");
                System.setProperty("IdentifyParticles", "true");
                System.setProperty("DefaultParticles", "true");
                System.setProperty("UseTargetVector", "false");
                break;
            }
            case OptimizedIdentifyParticles: {
                this.fogOfWar = true;
                System.setProperty("ParticleFilter", "true");
                System.setProperty("IdentifyParticles", "true");
                System.setProperty("DefaultParticles", "false");
                System.setProperty("UseTargetVector", "false");
            }
        }
        System.out.println("Particle Filter Mode: " + (Object)((Object)mode));
    }

    public static BehavingEntity getBehavingEntity() {
        return ABLStarCraftBot.thisInstance.ablBot;
    }

    public static CommandQueue getQueue() {
        return ABLStarCraftBot.thisInstance.commandQueue;
    }

    public static Game getGame() {
        return ABLStarCraftBot.thisInstance.game;
    }

    @Override
    public void connected() {
        System.out.println("Connected to StarCraft");
        this.bwapi.loadTypeData();
    }

    @Override
    public void gameStarted() {
        this.quitFrame = 0;
        if (!IgnoreBases) {
            this.bwapi.loadMapData(true);
        }
        if (this.userInput) {
            this.bwapi.enableUserInput();
        }
        if (!this.fogOfWar) {
            this.bwapi.enablePerfectInformation();
        }
        if (this.fastest) {
            this.bwapi.setGameSpeed(0);
        }
        try {
            this.game = new Game(this.bwapi);
            this.commandQueue.clear();
            this.ablBot = (BehavingEntity)Class.forName("eisbot.abl.java." + System.getProperty("ABLBotName")).newInstance();
            this.ablBot.setUseSynchrousSensors();
            new Thread(){

                @Override
                public void run() {
                    ABLStarCraftBot.this.ablBot.startBehaving();
                }
            }.start();
            if (this.showGUI) {
                this.mainFrame = new JFrame("EISBot");
                JPanel flowPanel = new JPanel();
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                this.speedPanel = new SpeedPanel(this.game);
                panel.add((Component)this.speedPanel, "North");
                ABLPanel ablPanel = new ABLPanel();
                ABLStarCraftBot.getBehavingEntity().addBehavingListener(ablPanel);
                this.wmePanel = new WMEPanel();
                panel.add((Component)this.wmePanel, "West");
                panel.add((Component)ablPanel, "South");
                panel.setBorder(BorderFactory.createTitledBorder("ABL"));
                CommandLogPanel logPanel = new CommandLogPanel();
                this.commandQueue.addCommandListener(logPanel);
                logPanel.setBorder(BorderFactory.createTitledBorder("Commands Issued"));
                flowPanel.setLayout(new BorderLayout());
                flowPanel.add((Component)panel, "West");
                flowPanel.add((Component)logPanel, "Center");
                JTabbedPane mainPanel = new JTabbedPane();
                mainPanel.setPreferredSize(new Dimension(600, 500));
                this.mainFrame.add(mainPanel);
                mainPanel.addTab("Controls", flowPanel);
                this.mainFrame.pack();
                this.mainFrame.setVisible(true);
                LoggingPanel loggingPanel = new LoggingPanel();
                Logger.addListener(loggingPanel);
                mainPanel.addTab("Logging", loggingPanel);
                this.abtViewer = new ABTViewer();
                this.ablBot.addBehavingListener(this.abtViewer);
                mainPanel.addTab("ABL Tree", this.abtViewer);
                this.gameFrame = new StarCraftFrame(this.game);
                this.commandQueue.addCommandListener(this.gameFrame);
                panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add((Component)this.gameFrame, "Center");
                panel.add((Component)this.gameFrame.getLayerPanel(), "South");
                mainPanel.addTab("Game View", panel);
                mainPanel.addTab("Recon", new ReconPanel());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void gameUpdate() {
        try {
            if (this.delay > 0) {
                Thread.sleep(this.delay);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.game.update(this.bwapi);
        this.commandQueue.processCommands(this.bwapi);
        if (this.useManners) {
            this.useManners();
        }
        if (this.drawBuildLocations > 0) {
            this.game.getMap().drawLocations(this.bwapi, this.game, this.drawBuildLocations, this.drawPylons);
        }
        if (this.drawParticles) {
            this.game.getParticleFilter().draw(this.bwapi);
        }
        this.bwapi.drawText(8, 16, "FPS: " + this.bwapi.getFPS(), true);
    }

    @Override
    public void menuUpdate(int menuFrame) {
        if (this.iccup && menuFrame > 2500000) {
            this.robot.stop();
            this.bwapi.disconnect();
        }
    }

    public void useManners() {
        if (this.game.getGameFrame() == 60) {
            this.bwapi.sendText("This is EISBot");
        } else if (this.game.getGameFrame() == 120) {
            this.bwapi.sendText("A project at UC Santa Cruz");
        } else if (this.game.getGameFrame() == 180) {
            this.bwapi.sendText("Thanks for playing!");
        }
        if (this.quitFrame == 0) {
            int probeCount = 0;
            int nexusHealth = 0;
            for (Unit unit : this.bwapi.getMyUnits()) {
                if (unit.getTypeID() == 64) {
                    ++probeCount;
                    continue;
                }
                if (unit.getTypeID() != 154) continue;
                nexusHealth = Math.max(nexusHealth, unit.getHitPoints());
            }
            if (probeCount < 3 || nexusHealth < 200) {
                this.quitFrame = this.bwapi.getFrameCount() + 120;
                this.bwapi.sendText("GG");
            }
        }
        if (this.quitFrame > 0 && this.bwapi.getFrameCount() >= this.quitFrame) {
            this.quitFrame = 0;
            this.bwapi.leaveGame();
        }
    }

    public void killStarCraft() {
        try {
            Process kill = Runtime.getRuntime().exec(new String[]{"TASKKILL", "/IM", "StarCraft.exe"});
            kill.waitFor();
            System.out.println("StarCraft exit code: " + kill.exitValue());
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startRobot() {
        new Thread(){

            @Override
            public void run() {
                ABLStarCraftBot.this.robot = new ICCupRobot();
                ABLStarCraftBot.this.robot.start();
            }
        }.start();
    }

    @Override
    public void gameEnded() {
        System.out.println("Game ended");
        if (this.showGUI) {
            this.gameFrame.stop();
            this.wmePanel.stop();
            this.abtViewer.stop();
            this.mainFrame.setVisible(false);
        }
        this.ablBot.stopBehaving();
        System.exit(0);
    }

    @Override
    public void keyPressed(int keyCode) {
        if (keyCode == 189) {
            this.delay += 10;
            System.out.println("Delay: " + this.delay);
        } else if (keyCode == 187) {
            if (this.delay > 0) {
                this.delay -= 10;
            }
            System.out.println("Delay: " + this.delay);
        }
        if (this.shiftPressed) {
            ABLStarCraftBot.getBehavingEntity().getWorkingMemory().addWME(new KeyPressWME(keyCode));
        }
        if (this.shiftPressed && keyCode == 66) {
            ++this.drawBuildLocations;
            if (this.drawBuildLocations == 4) {
                this.drawBuildLocations = 0;
            }
        }
        if (this.shiftPressed && keyCode == 65) {
            this.drawHealth = !this.drawHealth;
            this.bwapi.drawHealth(this.drawHealth);
        }
        if (this.shiftPressed && keyCode == 73) {
            this.drawIDs = !this.drawIDs;
            this.bwapi.drawIDs(this.drawIDs);
        }
        if (this.shiftPressed && keyCode == 84) {
            this.drawTargets = !this.drawTargets;
            this.bwapi.drawTargets(this.drawTargets);
        }
        if (this.shiftPressed && keyCode == 89) {
            boolean bl = this.drawPylons = !this.drawPylons;
        }
        if (this.shiftPressed && keyCode == 80) {
            boolean bl = this.drawParticles = !this.drawParticles;
        }
        if (this.shiftPressed && keyCode == 83) {
            this.autoCamera = !this.autoCamera;
        }
        this.shiftPressed = keyCode == 160;
    }

    @Override
    public void matchEnded(boolean winner) {
        System.out.println("Match ended: " + winner);
        if (this.autoRestart) {
            this.bwapi.restartGame();
        }
        if (this.iccup) {
            this.bwapi.disconnect();
        }
    }

    @Override
    public void unitCreate(int unitID) {
        Unit unit;
        if (this.autoCamera && (unit = this.bwapi.getUnit(unitID)) != null && System.currentTimeMillis() - this.lastCameraUpdate > 8000L) {
            this.lastCameraUpdate = System.currentTimeMillis();
            this.bwapi.setCameraLocation(unit.getX() - 320, unit.getY() - 240);
        }
    }

    @Override
    public void unitDestroy(int unitID) {
        Unit unit;
        if (this.autoCamera && (unit = this.bwapi.getUnit(unitID)) != null && System.currentTimeMillis() - this.lastCameraUpdate > 3000L) {
            this.lastCameraUpdate = System.currentTimeMillis();
            this.bwapi.setCameraLocation(unit.getX() - 320, unit.getY() - 240);
        }
    }

    @Override
    public void unitDiscover(int unitID) {
        Unit unit;
        if (this.autoCamera && (unit = this.bwapi.getUnit(unitID)) != null && unit.getPlayerID() != 11 && System.currentTimeMillis() - this.lastCameraUpdate > 4000L) {
            this.lastCameraUpdate = System.currentTimeMillis();
            this.bwapi.setCameraLocation(unit.getX() - 320, unit.getY() - 240);
        }
    }

    @Override
    public void nukeDetect(int x, int y) {
    }

    @Override
    public void nukeDetect() {
    }

    @Override
    public void playerLeft(int id) {
    }

    @Override
    public void unitEvade(int unitID) {
    }

    @Override
    public void unitHide(int unitID) {
    }

    @Override
    public void unitMorph(int unitID) {
    }

    @Override
    public void unitShow(int unitID) {
    }
}

