/*
 * Decompiled with CFR 0.152.
 */
package debug;

import abl.runtime.ABTNode;
import abl.runtime.BehavingListener;
import abl.runtime.Behavior;
import abl.runtime.GoalStep;
import abl.runtime.Step;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ABTViewer
extends JPanel
implements BehavingListener,
MouseWheelListener,
MouseMotionListener,
MouseListener {
    private HashMap<ABTNode, ABLNode> nodeMap = new HashMap();
    private boolean running = true;
    private JFrame frame;
    private double scale = 1.0;
    private double tx = 0.0;
    private double ty = 0.0;
    public int mx = 0;
    public int my = 0;
    private boolean mouseDown = false;
    Font font = new Font("ariel", 1, 12);
    int h = 25;
    int stackHeight = 35;
    private long last = 0L;
    double scaleAmmount = 0.9;

    public ABTViewer() {
        this.setPreferredSize(new Dimension(600, 600));
        this.frame = new JFrame("ABL Behavior Tree");
        this.frame.add(this);
        this.frame.pack();
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.frame.setLocation(640, 0);
        this.frame.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                while (ABTViewer.this.running) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ABTViewer.this.repaint();
                }
            }
        }.start();
    }

    public void stop() {
        this.running = false;
        this.frame.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setBackground(Color.WHITE);
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.translate(this.tx, this.ty);
        g2.scale(this.scale, this.scale);
        int y = 0;
        ArrayList<ABLNode> roots = new ArrayList<ABLNode>();
        HashMap<ABTNode, ABLNode> hashMap = this.nodeMap;
        synchronized (hashMap) {
            for (ABLNode node : this.nodeMap.values()) {
                if (node.parent != null) continue;
                roots.add(node);
            }
        }
        y = 0;
        int depth = 0;
        for (ABLNode node : roots) {
            y = this.drawNode(g2, node, y, depth);
        }
    }

    public int drawNode(Graphics2D g2, ABLNode node, int y, int depth) {
        this.drawNode(g2, node, y, depth, this.h);
        ++y;
        if (!node.collapsed) {
            for (ABLNode child : node.children) {
                y = this.drawNode(g2, child, y, depth + 1);
            }
        }
        return y;
    }

    private void drawNode(Graphics2D g2, ABLNode node, int y, int depth, int h) {
        g2.setColor(Color.GRAY.darker());
        g2.fillRect(50 * depth - 20, this.stackHeight * y + h / 2 + 1, 10, 2);
        if (node.collapsed) {
            g2.fillRect(50 * depth - 16, this.stackHeight * y + 9, 2, 10);
        }
        int tw = 20 + 15 * node.name.length() / 2;
        g2.setColor(new Color(230, 230, 230));
        if (node.type == NodeType.Root) {
            g2.setColor(Color.ORANGE.brighter().brighter());
        } else if (node.type == NodeType.Parallel) {
            g2.setColor(new Color(200, 255, 200));
        } else if (node.type == NodeType.Sequential) {
            g2.setColor(new Color(255, 255, 200));
        } else if (node.type == NodeType.MentalAct) {
            g2.setColor(new Color(255, 255, 255));
        } else if (node.type == NodeType.PrimitiveAct) {
            g2.setColor(new Color(150, 255, 255));
        }
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(50 * depth, this.stackHeight * y, tw, h, 20.0, 20.0);
        g2.fill(rect);
        if (node.executing > 0) {
            g2.setColor(new Color(0.0f, 1.0f, 0.0f, 0.001f * (float)node.executing));
            g2.fill(rect);
        }
        if (node.leaf > 0) {
            g2.setColor(new Color(0.0f, 0.0f, 1.0f, 0.001f * (float)node.leaf));
            g2.fill(rect);
        }
        g2.setStroke(new BasicStroke(3.0f));
        g2.setColor(Color.GRAY.darker());
        g2.draw(rect);
        g2.setColor(Color.black);
        g2.setFont(this.font);
        g2.drawString(node.name, 50 * depth + 10, this.stackHeight * y + 18);
    }

    @Override
    public void onBehave(Hashtable executingSteps, Set leafSteps) {
        this.updateTree(executingSteps, leafSteps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTree(Hashtable executingSteps, Set leafSteps) {
        HashMap<ABTNode, ABLNode> hashMap = this.nodeMap;
        synchronized (hashMap) {
            int decay = 0;
            if (this.last > 0L) {
                decay = 5 * (int)(System.currentTimeMillis() - this.last);
            }
            this.last = System.currentTimeMillis();
            for (ABLNode node : this.nodeMap.values()) {
                node.leaf = Math.max(0, node.leaf - decay);
                node.executing = Math.max(0, node.executing - decay);
            }
            for (ABLNode obj : leafSteps) {
                Step step = (Step)((Object)obj);
                ABLNode node = this.nodeMap.get(step);
                if (node != null) {
                    node.leaf = 1000;
                    continue;
                }
                node = new ABLNode(step.toString());
                node.leaf = 1000;
                this.nodeMap.put(step, node);
                this.addNode(node, step);
            }
            for (ABLNode key : executingSteps.keySet()) {
                HashSet steps = (HashSet)executingSteps.get(key);
                for (Object object : steps) {
                    Step step = (Step)object;
                    ABLNode node = this.nodeMap.get(step);
                    if (node != null) {
                        node.executing = 1000;
                        continue;
                    }
                    node = new ABLNode(step.toString());
                    node.executing = 1000;
                    this.nodeMap.put(step, node);
                    this.addNode(node, step);
                }
            }
        }
    }

    private void printTree() {
        ArrayList<ABLNode> rootNodes = new ArrayList<ABLNode>();
        for (ABLNode node : this.nodeMap.values()) {
            if (node.parent != null) continue;
            rootNodes.add(node);
        }
        for (ABLNode node : rootNodes) {
            this.print(node, " ");
        }
    }

    private void print(ABLNode node, String indent) {
        System.out.println(String.valueOf(indent) + (Object)((Object)node.type) + ": " + node.name);
        for (ABLNode child : node.children) {
            this.print(child, String.valueOf(indent) + " ");
        }
    }

    private void addNode(ABLNode node, Step step) {
        Behavior parent = step.getParent();
        if (parent != null) {
            ABLNode behaviorNode = this.nodeMap.get(parent);
            if (behaviorNode == null) {
                behaviorNode = new ABLNode(parent.toString());
                this.nodeMap.put(parent, behaviorNode);
                node.setParent(behaviorNode);
                GoalStep parentStep = parent.getParent();
                if (parentStep != null) {
                    ABLNode goalNode = this.nodeMap.get(parentStep);
                    if (goalNode == null) {
                        goalNode = new ABLNode(step.toString());
                        this.nodeMap.put(parentStep, goalNode);
                        this.addNode(goalNode, parentStep);
                        behaviorNode.setParent(goalNode);
                        return;
                    }
                    behaviorNode.setParent(goalNode);
                    return;
                }
                return;
            }
            node.setParent(behaviorNode);
            return;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        try {
            if (e.getWheelRotation() > 0) {
                double screenX = e.getX();
                double screenY = e.getY();
                AffineTransform transform = new AffineTransform();
                transform.translate(this.tx, this.ty);
                transform.scale(this.scale, this.scale);
                double[] src = new double[]{screenX, screenY};
                double[] dest1 = new double[2];
                transform.inverseTransform(src, 0, dest1, 0, 1);
                this.scale *= this.scaleAmmount;
                screenX = e.getX();
                screenY = e.getY();
                transform = new AffineTransform();
                transform.translate(this.tx, this.ty);
                transform.scale(this.scale, this.scale);
                src = new double[]{screenX, screenY};
                double[] dest2 = new double[2];
                transform.inverseTransform(src, 0, dest2, 0, 1);
                this.tx += (dest2[0] - dest1[0]) * this.scale;
                this.ty += (dest2[1] - dest1[1]) * this.scale;
            } else {
                double screenX = e.getX();
                double screenY = e.getY();
                AffineTransform transform = new AffineTransform();
                transform.translate(this.tx, this.ty);
                transform.scale(this.scale, this.scale);
                double[] src = new double[]{screenX, screenY};
                double[] dest1 = new double[2];
                transform.inverseTransform(src, 0, dest1, 0, 1);
                this.scale /= this.scaleAmmount;
                screenX = e.getX();
                screenY = e.getY();
                transform = new AffineTransform();
                transform.translate(this.tx, this.ty);
                transform.scale(this.scale, this.scale);
                src = new double[]{screenX, screenY};
                double[] dest2 = new double[2];
                transform.inverseTransform(src, 0, dest2, 0, 1);
                this.tx += (dest2[0] - dest1[0]) * this.scale;
                this.ty += (dest2[1] - dest1[1]) * this.scale;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mouseDown) {
            double dx = e.getX() - this.mx;
            double dy = e.getY() - this.my;
            this.tx += dx;
            this.ty += dy;
            this.mx = e.getX();
            this.my = e.getY();
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.mouseDown = true;
            this.mx = e.getX();
            this.my = e.getY();
        } else {
            int x = e.getX();
            int y = e.getY();
            AffineTransform transform = new AffineTransform();
            transform.translate(this.tx, this.ty);
            transform.scale(this.scale, this.scale);
            Point2D.Double source = new Point2D.Double(x, y);
            Point2D.Double result = new Point2D.Double();
            try {
                transform.inverseTransform(source, result);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            int stack = (int)(((Point2D)result).getY() / (double)this.stackHeight);
            if (stack >= 0 && stack < this.nodeMap.size()) {
                HashMap<ABTNode, ABLNode> hashMap = this.nodeMap;
                synchronized (hashMap) {
                    ArrayList<ABLNode> fringe = new ArrayList<ABLNode>();
                    for (ABLNode node : this.nodeMap.values()) {
                        if (node.parent != null) continue;
                        fringe.add(node);
                    }
                    int count = 0;
                    while (fringe.size() > 0) {
                        ABLNode node = (ABLNode)fringe.remove(0);
                        if (stack == count++) {
                            node.collapsed = !node.collapsed;
                            continue;
                        }
                        int index = 0;
                        if (node.collapsed) continue;
                        for (ABLNode child : node.children) {
                            fringe.add(index++, child);
                        }
                    }
                }
            }
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 3) {
            this.mouseDown = false;
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public class ABLNode
    implements Comparable<ABLNode> {
        public ABLNode parent = null;
        public TreeSet<ABLNode> children = new TreeSet();
        public int leaf = 0;
        public int executing = 0;
        public String description;
        public String name;
        public NodeType type;
        public boolean collapsed = false;

        public ABLNode(String name) {
            this.description = name;
            this.type = NodeType.Unknown;
            this.name = name;
            if (name.startsWith("collection")) {
                this.type = NodeType.Root;
                this.name = name.split(" ")[1];
            } else if (name.startsWith("subgoal")) {
                this.type = NodeType.SubGoal;
                this.name = name.split(" ")[1];
            } else if (name.startsWith("sequential")) {
                this.type = NodeType.Sequential;
                this.name = name.split(" ")[1];
            } else if (name.startsWith("parallel")) {
                this.type = NodeType.Parallel;
                this.name = name.split(" ")[1];
            } else if (name.startsWith("mental")) {
                this.type = NodeType.MentalAct;
                this.name = "Mental Act";
            } else if (name.startsWith("act")) {
                this.type = NodeType.PrimitiveAct;
                this.name = name.split(" ")[1];
            }
            this.name = (Object)((Object)this.type) + ":" + this.name;
        }

        public void setParent(ABLNode parent) {
            this.parent = parent;
            parent.children.add(this);
        }

        @Override
        public int compareTo(ABLNode o) {
            return this.name.compareTo(o.name);
        }
    }

    public static enum NodeType {
        Root,
        SubGoal,
        Parallel,
        Sequential,
        MentalAct,
        PrimitiveAct,
        Unknown;

    }
}

