/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.ABTNode;
import abl.runtime.AblNamedPropertySupport;
import abl.runtime.AblRuntimeError;
import abl.runtime.AdaptiveBehavior;
import abl.runtime.BehavingEntity;
import abl.runtime.Behavior;
import abl.runtime.CompletedActWME;
import abl.runtime.CompletedGoalWME;
import abl.runtime.CompletedMentalActWME;
import abl.runtime.CompletedStepWME;
import abl.runtime.CompletedWaitWME;
import abl.runtime.ExecutableStep;
import abl.runtime.GoalStep;
import abl.runtime.MultiStepBehavior;
import abl.runtime.PrimitiveStep;
import abl.runtime.SensorActivation;
import abl.runtime.SequentialBehavior;
import abl.runtime.StepWME;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import wm.WorkingMemory;

public abstract class Step
implements ABTNode {
    public static final short PRIMITIVE = 0;
    public static final short GOAL = 1;
    public static final short MENTAL = 2;
    public static final short WAIT = 3;
    public static final short FAIL = 4;
    public static final short SUCCEED = 5;
    public static final short EXECUTE_POLICY = 6;
    public static final short MODIFY = 7;
    protected Behavior parent;
    private boolean persistent = false;
    private boolean persistentWhenSucceeds = false;
    private boolean persistentWhenFails = false;
    private boolean ignoreFailure = false;
    private boolean effectOnly = false;
    private boolean teamEffectOnly = false;
    private short priority = Short.MIN_VALUE;
    private short priorityModifier = 0;
    private boolean isAtomic = false;
    private boolean post = false;
    private String postMemory = null;
    protected final Method execute;
    private final Method successTest;
    private final Method successTestSensorFactory;
    private final short stepType;
    protected final int stepID;
    protected List stepsSuspendingMe = new LinkedList();
    protected List stepsIHaveSuspended = new LinkedList();
    private int metaSuspenderCount = 0;
    private int jointSuspenderCount = 0;
    final AblNamedPropertySupport propertyTable;
    private StepWME stepWME = null;

    public Step(int arg_stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, String arg_postMemory, Method arg_execute, Method arg_successTest, Method arg_successTestSensorFactory, AblNamedPropertySupport arg_propertyTable, short arg_stepType) {
        this.stepID = arg_stepID;
        this.parent = arg_parent;
        this.isAtomic = this.parent.isAtomic;
        this.persistent = arg_persistent;
        this.persistentWhenSucceeds = arg_persistentWhenSucceeds;
        this.persistentWhenFails = arg_persistentWhenFails;
        this.ignoreFailure = arg_ignoreFailure;
        this.effectOnly = arg_effectOnly;
        this.teamEffectOnly = arg_teamEffectOnly;
        this.priority = arg_priority;
        this.priorityModifier = arg_priorityModifier;
        this.post = arg_post;
        this.postMemory = arg_postMemory;
        this.execute = arg_execute;
        this.successTest = arg_successTest;
        this.successTestSensorFactory = arg_successTestSensorFactory;
        this.propertyTable = arg_propertyTable != null ? arg_propertyTable : new AblNamedPropertySupport();
        this.stepType = arg_stepType;
    }

    public String toString() {
        String behaviorTypeString;
        switch (this.getStepType()) {
            case 1: {
                behaviorTypeString = ((GoalStep)this).getGoalExecutionType() != 0 && !((GoalStep)this).getRerooted() ? "spawngoal " + ((GoalStep)this).getSignature() : "subgoal " + ((GoalStep)this).getSignature();
                if (!((GoalStep)this).isJointGoal()) break;
                behaviorTypeString = "joint " + behaviorTypeString;
                break;
            }
            case 0: {
                behaviorTypeString = "act " + ((PrimitiveStep)this).name;
                break;
            }
            case 3: {
                behaviorTypeString = "wait";
                break;
            }
            case 2: {
                behaviorTypeString = "mental";
                break;
            }
            case 4: {
                behaviorTypeString = "fail_step";
                break;
            }
            case 5: {
                behaviorTypeString = "succeed_step";
                break;
            }
            case 6: {
                behaviorTypeString = "execute_policy";
                break;
            }
            default: {
                return "UNEXPECTED STEP TYPE";
            }
        }
        return behaviorTypeString;
    }

    final short getStepType() {
        return this.stepType;
    }

    final boolean getPersistent() {
        return this.persistent;
    }

    final boolean getPersistentWhenSucceeds() {
        return this.persistentWhenSucceeds;
    }

    final boolean getPersistentWhenFails() {
        return this.persistentWhenFails;
    }

    final boolean getIgnoreFailure() {
        return this.ignoreFailure;
    }

    final boolean getHasSuccessTest() {
        return this.successTest != null;
    }

    final boolean getEffectOnly() {
        return this.effectOnly;
    }

    final boolean getTeamEffectOnly() {
        return this.teamEffectOnly;
    }

    final boolean getEffectOnlyOrTeamEffectOnly() {
        return this.effectOnly || this.teamEffectOnly;
    }

    final short getPriority() {
        if (this.priority == Short.MIN_VALUE) {
            this.priority = (short)(this.parent.getPriority() + this.priorityModifier);
            return this.priority;
        }
        return this.priority;
    }

    final short getPriorityModifier() {
        return this.priorityModifier;
    }

    final boolean getIsAtomic() {
        return this.isAtomic;
    }

    final List getStepsSuspendingMe() {
        return new Vector(this.stepsSuspendingMe);
    }

    final List getStepsIHaveSuspended() {
        return new Vector(this.stepsIHaveSuspended);
    }

    public final Behavior getParent() {
        return this.parent;
    }

    final int getMetaSuspenderCount() {
        return this.metaSuspenderCount;
    }

    final int getStepID() {
        return this.stepID;
    }

    final void setPersistent(boolean b) {
        this.persistent = b;
    }

    final void setPersistentWhenSucceeds(boolean b) {
        this.persistentWhenSucceeds = b;
    }

    final void setPersistentWhenFails(boolean b) {
        this.persistentWhenFails = b;
    }

    final void setIgnoreFailure(boolean b) {
        this.ignoreFailure = b;
    }

    final void setEffectOnly(boolean b) {
        this.effectOnly = b;
    }

    final void setTeamEffectOnly(boolean b) {
        this.teamEffectOnly = b;
    }

    final void setPriority(short i) {
        this.priority = i;
    }

    final void setPriorityModifier(short i) {
        this.priority = i;
    }

    boolean successTest() {
        if (this.successTest == null) {
            return false;
        }
        Object[] args = new Object[]{new Integer(this.stepID), this.parent.getBehaviorVariableFrame(), BehavingEntity.getBehavingEntity()};
        try {
            Boolean b = (Boolean)this.successTest.invoke(null, args);
            return b;
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error invoking success test", e);
        }
    }

    final SensorActivation[] getSuccessTestSensorActivations() {
        if (this.successTestSensorFactory == null) {
            return null;
        }
        Object[] args = new Object[]{new Integer(this.stepID)};
        try {
            return (SensorActivation[])this.successTestSensorFactory.invoke(null, args);
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error invoking success test sensor factory", e);
        }
    }

    abstract void execute();

    protected void executeBookkeeping() {
        BehavingEntity.getBehavingEntity().executeStep(this);
    }

    private void postCompletionWME(int success, String memoryName) {
        CompletedStepWME newWME;
        if (memoryName != null) assert (WorkingMemory.lookupRegisteredMemory(memoryName) != null) : "memory " + memoryName + " does not exist.";
        switch (this.getStepType()) {
            case 0: {
                newWME = new CompletedActWME(((PrimitiveStep)this).name, success, this.parent.getSignature(), BehavingEntity.getBehavingEntity().getBehavingEntityShortName());
                break;
            }
            case 1: {
                newWME = new CompletedGoalWME(((GoalStep)this).getSignature(), success, this.parent.getSignature(), BehavingEntity.getBehavingEntity().getBehavingEntityShortName());
                break;
            }
            case 2: {
                newWME = new CompletedMentalActWME(this.parent.getSignature(), BehavingEntity.getBehavingEntity().getBehavingEntityShortName());
                break;
            }
            case 3: {
                newWME = new CompletedWaitWME(this.parent.getSignature(), BehavingEntity.getBehavingEntity().getBehavingEntityShortName());
                break;
            }
            default: {
                throw new AblRuntimeError("Unexpected step type " + this.getStepType());
            }
        }
        WorkingMemory memory = memoryName == null ? BehavingEntity.getBehavingEntity().getWorkingMemory() : WorkingMemory.lookupRegisteredMemory(memoryName);
        memory.addWME(newWME);
    }

    void succeedStep() {
        if (this.post) {
            this.postCompletionWME(0, null);
        }
        if (this.postMemory != null) {
            this.postCompletionWME(0, this.postMemory);
        }
        if (this.getPersistent() || this.getPersistentWhenSucceeds()) {
            this.resetStep();
        } else {
            this.parent.removeChild(this, true);
            if (this.parent.getBehaviorType() == 0) {
                Step nextStep = ((SequentialBehavior)this.parent).getNextStep();
                if (nextStep == null) {
                    this.parent.succeedBehavior();
                } else {
                    ((SequentialBehavior)this.parent).addChild(nextStep);
                }
            } else if (this.parent.getBehaviorType() == 3) {
                AdaptiveBehavior parentBeh = (AdaptiveBehavior)this.parent;
                parentBeh.updatePolicy();
                parentBeh.addChildren();
            } else if (((MultiStepBehavior)this.parent).isSuccessful()) {
                this.parent.succeedBehavior();
            }
        }
    }

    void failStep() {
        if (this.post) {
            this.postCompletionWME(1, null);
        }
        if (this.postMemory != null) {
            this.postCompletionWME(1, this.postMemory);
        }
        if (this.getIgnoreFailure()) {
            this.succeedStep();
        } else if (this.getPersistent() || this.getPersistentWhenFails()) {
            this.resetStep();
        } else {
            this.parent.removeChild(this, true);
            if (this.parent.getBehaviorType() == 2) {
                if (((MultiStepBehavior)this.parent).isSuccessful()) {
                    this.parent.succeedBehavior();
                }
            } else if (this.parent.getBehaviorType() == 3) {
                AdaptiveBehavior parentBeh = (AdaptiveBehavior)this.parent;
                parentBeh.updatePolicy();
                parentBeh.addChildren();
            } else if (!this.getEffectOnly() && !this.getTeamEffectOnly()) {
                this.parent.failBehavior();
            }
        }
    }

    abstract void resetStep();

    boolean currentLineOfExpansion(GoalStep currentGoal) {
        return this.parent.currentLineOfExpansion(currentGoal);
    }

    void suspend(ExecutableStep step) {
        this.stepsSuspendingMe.add(step);
        step.suspenderFor(this);
    }

    void unsuspend(ExecutableStep step) {
        this.stepsSuspendingMe.remove(step);
        step.unsuspenderFor(this);
    }

    void metaSuspend() {
        assert (this.metaSuspenderCount >= 0);
        ++this.metaSuspenderCount;
    }

    void metaUnsuspend() {
        assert (this.metaSuspenderCount >= 0);
        if (this.metaSuspenderCount > 0) {
            --this.metaSuspenderCount;
        }
    }

    void jointSuspend() {
        assert (this.jointSuspenderCount >= 0);
        ++this.jointSuspenderCount;
    }

    void jointUnsuspend() {
        assert (this.jointSuspenderCount > 0);
        --this.jointSuspenderCount;
    }

    boolean isSuspended() {
        return !this.stepsSuspendingMe.isEmpty() || this.metaSuspenderCount > 0 || this.jointSuspenderCount > 0;
    }

    void updateStepsSuspendingMe() {
        ExecutableStep[] stepsSuspendingMeArray = this.stepsSuspendingMe.toArray(new ExecutableStep[this.stepsSuspendingMe.size()]);
        int i = 0;
        while (i < stepsSuspendingMeArray.length) {
            stepsSuspendingMeArray[i].unsuspenderFor(this);
            ++i;
        }
    }

    void setReflectionWME(StepWME stepWME) {
        assert (stepWME != null);
        this.stepWME = stepWME;
    }

    public StepWME getReflectionWME() {
        if (BehavingEntity.getBehavingEntity().reflectionEnabled() && this.stepWME == null) {
            System.err.println("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ UNEXPECTED NULL REFLECTION WME in " + BehavingEntity.getBehavingEntity());
            BehavingEntity.printABTBranchUpwards(this);
            throw new AblRuntimeError("Unexpected NULL Reflection WME in " + BehavingEntity.getBehavingEntity());
        }
        return this.stepWME;
    }
}

