/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.AblRuntimeError;
import abl.runtime.BehavingEntity;
import abl.runtime.Behavior;
import abl.runtime.ExecutableStep;
import abl.runtime.GoalStep;
import abl.runtime.RuntimeError;
import abl.runtime.Step;
import abl.runtime.__StepDesc;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;

public class SequentialBehavior
extends Behavior {
    private int stepCounter = 0;
    private Step child;
    protected static short behaviorType = 0;

    public SequentialBehavior(GoalStep arg_parent, Method arg_contextCondition, Method arg_contextConditionSensorFactory, Method arg_successCondition, Method arg_successConditionSensorFactory, boolean arg_isAtomic, String arg_signature, short arg_specificity, int arg_behaviorID, Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs) {
        super(arg_parent, arg_contextCondition, arg_contextConditionSensorFactory, arg_successCondition, arg_successConditionSensorFactory, arg_isAtomic, arg_signature, arg_specificity, arg_behaviorID, arg_behaviorVariableFrame, arg_stepDescs);
    }

    public SequentialBehavior(GoalStep arg_parent, Method arg_contextCondition, Method arg_contextConditionSensorFactory, Method arg_successCondition, Method arg_successConditionSensorFactory, boolean arg_isAtomic, String arg_signature, short arg_specificity, int arg_behaviorID, Object[] arg_behaviorVariableFrame, __StepDesc[] arg_stepDescs, BehavingEntity[] arg_teamMembers) {
        super(arg_parent, arg_contextCondition, arg_contextConditionSensorFactory, arg_successCondition, arg_successConditionSensorFactory, arg_isAtomic, arg_signature, arg_specificity, arg_behaviorID, arg_behaviorVariableFrame, arg_stepDescs, arg_teamMembers);
    }

    @Override
    final short getBehaviorType() {
        return behaviorType;
    }

    final Step getChild() {
        return this.child;
    }

    final Step getNextStep() {
        if (this.stepCounter == this.stepDescs.length) {
            return null;
        }
        try {
            Object[] factoryArgs = new Object[]{new Integer(this.stepDescs[this.stepCounter].stepID), this, this.getBehaviorVariableFrame()};
            return (Step)this.stepDescs[this.stepCounter++].factory.invoke(null, factoryArgs);
        }
        catch (Exception e) {
            throw new AblRuntimeError("Error invoking step factory", e);
        }
    }

    @Override
    void addChildren() {
        assert (this.stepCounter == 0);
        this.child = this.getNextStep();
        BehavingEntity.getBehavingEntity().addStep(this.child);
        this.changes.firePropertyChange("child", null, this.child);
    }

    final void addChild(Step s) {
        assert (this.child == null);
        this.child = s;
        BehavingEntity.getBehavingEntity().addStep(s);
        this.changes.firePropertyChange("child", null, this.child);
    }

    @Override
    protected final void removeChildren() {
        if (this.child != null) {
            this.removeChild(this.child, false);
        }
    }

    @Override
    protected final void removeChild(Step childToRemove, boolean isCallerChild) {
        assert (childToRemove == this.child) : "childToRemove == " + childToRemove + ": current child == " + this.child + " behavior: " + this.getSignature();
        assert (childToRemove != null) : "Attempt to remove a null child from a sequential behavior.";
        super.removeChild(childToRemove, isCallerChild);
        this.child = null;
    }

    @Override
    final boolean currentLineOfExpansion(GoalStep currentGoal) {
        return this.parent.currentLineOfExpansion(currentGoal);
    }

    @Override
    final void suspend(ExecutableStep step) {
        this.child.suspend(step);
    }

    @Override
    final void jointUnsuspend() {
        this.child.jointUnsuspend();
    }

    @Override
    final void metaSuspend() {
        this.child.metaSuspend();
    }

    @Override
    final void unsuspend(ExecutableStep step) {
        this.child.unsuspend(step);
    }

    @Override
    final void metaUnsuspend() {
        this.child.metaUnsuspend();
    }

    @Override
    final void suspendSkipJointGoals(ExecutableStep step) {
        if (!(this.child == null || this.child.getStepType() == 1 && ((GoalStep)this.child).isJointGoal())) {
            if (this.child.getStepType() == 1) {
                ((GoalStep)this.child).suspendSkipJointGoals(step);
            } else {
                this.child.suspend(step);
            }
        }
    }

    @Override
    final void metaSuspendSkipJointGoals() {
        if (!(this.child == null || this.child.getStepType() == 1 && ((GoalStep)this.child).isJointGoal())) {
            if (this.child.getStepType() == 1) {
                ((GoalStep)this.child).metaSuspendSkipJointGoals();
            } else {
                this.child.metaSuspend();
            }
        }
    }

    @Override
    final List<Step> freezeSubtreeAndNegotiateRemoval() {
        if (this.hasTeamEffectOnlySteps()) {
            return this.freezeNonTeamEffectOnlySubtreeAndNegotiateRemoval();
        }
        BehavingEntity.getBehavingEntity().removeBehavior(this);
        if (this.child != null) {
            return this.freezeChild(this.child);
        }
        return new Vector<Step>(0);
    }

    @Override
    protected final List<Step> freezeNonTeamEffectOnlySubtreeAndNegotiateRemoval() {
        BehavingEntity.getBehavingEntity().removeBehavior(this);
        if (this.child != null && !this.child.getTeamEffectOnly()) {
            return this.freezeChild(this.child);
        }
        return new Vector<Step>(0);
    }

    @Override
    protected final boolean hasTeamEffectOnlySteps() {
        if (this.child != null) {
            return this.child.getTeamEffectOnly();
        }
        return false;
    }

    @Override
    final List negotiateSuspensionOfSubtree(ExecutableStep s) {
        if (this.child != null) {
            return this.negotiateSuspensionOfChild(this.child, s);
        }
        return new Vector(0);
    }

    @Override
    final List negotiateSuspensionOfSubtree() {
        if (this.child != null) {
            return this.negotiateSuspensionOfChild(this.child);
        }
        return new Vector(0);
    }

    final void insertStep(__StepDesc step, int index) {
        if (index < 0 || index > this.stepDescs.length) {
            throw new RuntimeError("Invalid insertStep index (" + index + ")");
        }
        __StepDesc[] newStepDescs = new __StepDesc[this.stepDescs.length + 1];
        int i = 0;
        while (i < this.stepDescs.length) {
            newStepDescs[i] = i < index ? this.stepDescs[i] : (i == index ? step : this.stepDescs[i + 1]);
            ++i;
        }
        this.stepDescs = newStepDescs;
    }

    final void moveStep(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex >= this.stepDescs.length) {
            throw new RuntimeError("Invalid moveStep fromIndex (" + fromIndex + ")");
        }
        if (toIndex > this.stepDescs.length) {
            throw new RuntimeError("Invalid moveStep toIndex (" + toIndex + ")");
        }
        if (fromIndex == toIndex) {
            return;
        }
        int newSize = this.stepDescs.length;
        if (toIndex < 0) {
            --newSize;
        }
        __StepDesc[] newStepDescs = new __StepDesc[newSize];
        int i = 0;
        while (i < this.stepDescs.length) {
            newStepDescs[i] = i < fromIndex ? this.stepDescs[i] : this.stepDescs[i + 1];
            ++i;
        }
        if (toIndex >= 0) {
            i = newStepDescs.length - 1;
            while (i > toIndex) {
                newStepDescs[i] = newStepDescs[i - 1];
                --i;
            }
            newStepDescs[toIndex] = this.stepDescs[fromIndex];
        }
        this.stepDescs = newStepDescs;
    }
}

