/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.AblNamedPropertySupport;
import abl.runtime.AblRuntimeError;
import abl.runtime.BehavingEntity;
import abl.runtime.Behavior;
import abl.runtime.ExecutableStep;
import abl.runtime.PrimitiveAction;
import java.lang.reflect.Method;

public class PrimitiveStep
extends ExecutableStep {
    private PrimitiveAction act;
    private boolean executing = false;

    public PrimitiveStep(int stepID, Behavior arg_parent, boolean arg_persistent, boolean arg_persistentWhenSucceeds, boolean arg_persistentWhenFails, boolean arg_ignoreFailure, boolean arg_effectOnly, boolean arg_teamEffectOnly, short arg_priority, short arg_priorityModifier, boolean arg_post, String arg_postMemory, Method arg_execute, Method arg_successTest, Method arg_successTestSensorFactory, AblNamedPropertySupport arg_propertyTable, PrimitiveAction arg_act, String[] arg_stepsIConflictWith, String arg_actName) {
        super(stepID, arg_parent, arg_persistent, arg_persistentWhenSucceeds, arg_persistentWhenFails, arg_ignoreFailure, arg_effectOnly, arg_teamEffectOnly, arg_priority, arg_priorityModifier, arg_post, arg_postMemory, arg_execute, arg_successTest, arg_successTestSensorFactory, arg_propertyTable, (short)0, arg_stepsIConflictWith);
        this.act = arg_act;
        this.name = arg_actName;
    }

    @Override
    final boolean isExecuting() {
        if (this.executing) {
            if (this.getCompletionStatus() == 0) {
                return true;
            }
            this.executing = false;
        }
        return false;
    }

    final int getCompletionStatus() {
        return this.act.getCompletionStatus();
    }

    @Override
    final void resetStep() {
        if (this.isExecuting()) {
            this.act.abort();
        }
        BehavingEntity.getBehavingEntity().resetStep(this);
        try {
            Class<?> actionClass = this.act.getClass();
            this.act = (PrimitiveAction)actionClass.newInstance();
        }
        catch (Exception e) {
            throw new AblRuntimeError("Reflection error in PrimitiveStep.resetStep()", e);
        }
        this.executing = false;
    }

    private final Object[] bindArgs() {
        if (this.execute != null) {
            Object[] exeArgs = new Object[]{new Integer(this.stepID), this.parent.getBehaviorVariableFrame(), BehavingEntity.getBehavingEntity()};
            try {
                return (Object[])this.execute.invoke(null, exeArgs);
            }
            catch (Exception e) {
                throw new AblRuntimeError("Error invoking execute", e);
            }
        }
        return new Object[0];
    }

    @Override
    void execute() {
        this.checkForConflictsOnExecution();
        if (!this.isSuspended()) {
            this.executeBookkeeping();
            Object[] args = this.bindArgs();
            this.act.execute(args);
        }
    }

    @Override
    protected final void executeBookkeeping() {
        this.executing = true;
        super.executeBookkeeping();
    }

    final void abort() {
        if (this.isExecuting()) {
            this.act.abort();
        }
        BehavingEntity.getBehavingEntity().abortStep(this);
        this.executing = false;
    }

    @Override
    void suspend(ExecutableStep step) {
        super.suspend(step);
        BehavingEntity.getBehavingEntity().suspendStep(this);
        if (this.isExecuting()) {
            this.act.abort();
            try {
                Class<?> actionClass = this.act.getClass();
                this.act = (PrimitiveAction)actionClass.newInstance();
            }
            catch (Exception e) {
                throw new AblRuntimeError("Reflection error in PrimitiveStep.suspend()", e);
            }
            this.executing = false;
        }
    }

    @Override
    public void metaSuspend() {
        super.metaSuspend();
        BehavingEntity.getBehavingEntity().suspendStep(this);
        if (this.isExecuting()) {
            this.act.abort();
            try {
                Class<?> actionClass = this.act.getClass();
                this.act = (PrimitiveAction)actionClass.newInstance();
            }
            catch (Exception e) {
                throw new AblRuntimeError("Reflection error in PrimitiveStep.suspend()", e);
            }
            this.executing = false;
        }
    }

    @Override
    void jointSuspend() {
        super.jointSuspend();
        BehavingEntity.getBehavingEntity().suspendStep(this);
        if (this.isExecuting()) {
            this.act.abort();
            try {
                Class<?> actionClass = this.act.getClass();
                this.act = (PrimitiveAction)actionClass.newInstance();
            }
            catch (Exception e) {
                throw new AblRuntimeError("Reflection error in PrimitiveStep.suspend()", e);
            }
            this.executing = false;
        }
    }

    @Override
    void unsuspend(ExecutableStep step) {
        super.unsuspend(step);
        if (!this.isSuspended()) {
            BehavingEntity.getBehavingEntity().unsuspendStep(this);
        }
    }

    @Override
    public void metaUnsuspend() {
        super.metaUnsuspend();
        if (!this.isSuspended()) {
            BehavingEntity.getBehavingEntity().unsuspendStep(this);
        }
    }

    @Override
    void jointUnsuspend() {
        super.jointUnsuspend();
        if (!this.isSuspended()) {
            BehavingEntity.getBehavingEntity().unsuspendStep(this);
        }
    }
}

