/*
 * Decompiled with CFR 0.152.
 */
package abl.runtime;

import abl.runtime.BehavingEntity;
import abl.runtime.BehaviorWME;
import abl.runtime.FailStep;
import abl.runtime.FailStepWME;
import abl.runtime.GoalStep;
import abl.runtime.GoalStepWME;
import abl.runtime.MentalStep;
import abl.runtime.MentalStepWME;
import abl.runtime.MultiStepBehavior;
import abl.runtime.PrimitiveStep;
import abl.runtime.PrimitiveStepWME;
import abl.runtime.Step;
import abl.runtime.StepWME;
import abl.runtime.SucceedStep;
import abl.runtime.SucceedStepWME;
import abl.runtime.WaitStep;
import abl.runtime.WaitStepWME;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Hashtable;

public class MultiStepBehaviorWME
extends BehaviorWME {
    private final HashSet children = new HashSet();
    private final Hashtable stepToWMETable = new Hashtable();

    public MultiStepBehaviorWME(MultiStepBehavior multiStepBehavior, GoalStepWME parent) {
        super(multiStepBehavior, parent);
        this.behavior.addChildChangeListener(new MultiStepBehaviorChildChangeListener(this));
    }

    public synchronized int getNumberNeededForSuccess() {
        return ((MultiStepBehavior)this.behavior).getNumberNeededForSuccess();
    }

    public synchronized int getNumberOfCompletedSteps() {
        return ((MultiStepBehavior)this.behavior).getNumberOfCompletedSteps();
    }

    public synchronized int getNumberOfSteps() {
        return ((MultiStepBehavior)this.behavior).getNumberOfSteps();
    }

    @Override
    public synchronized int getBehaviorType() {
        return this.behavior.getBehaviorType();
    }

    public synchronized StepWME[] getChildren() {
        return this.children.toArray(new StepWME[this.children.size()]);
    }

    private synchronized void addChild(StepWME stepWME, Step step) {
        this.children.add(stepWME);
        this.stepToWMETable.put(step, stepWME);
    }

    private synchronized void removeChild(StepWME stepWME, Step step) {
        this.children.remove(stepWME);
        this.stepToWMETable.remove(step);
    }

    private class MultiStepBehaviorChildChangeListener
    implements PropertyChangeListener {
        MultiStepBehaviorWME multiStepBehaviorWME;

        MultiStepBehaviorChildChangeListener(MultiStepBehaviorWME b) {
            this.multiStepBehaviorWME = b;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            assert (!(evt.getOldValue() != null && evt.getNewValue() != null || evt.getOldValue() == null && evt.getNewValue() == null));
            if (evt.getOldValue() == null) {
                Step newStep = (Step)evt.getNewValue();
                StepWME newStepWME = null;
                switch (newStep.getStepType()) {
                    case 1: {
                        newStepWME = new GoalStepWME((GoalStep)newStep, (BehaviorWME)this.multiStepBehaviorWME);
                        break;
                    }
                    case 0: {
                        newStepWME = new PrimitiveStepWME((PrimitiveStep)newStep, (BehaviorWME)this.multiStepBehaviorWME);
                        break;
                    }
                    case 3: {
                        newStepWME = new WaitStepWME((WaitStep)newStep, (BehaviorWME)this.multiStepBehaviorWME);
                        break;
                    }
                    case 2: {
                        newStepWME = new MentalStepWME((MentalStep)newStep, (BehaviorWME)this.multiStepBehaviorWME);
                        break;
                    }
                    case 4: {
                        newStepWME = new FailStepWME((FailStep)newStep, (BehaviorWME)this.multiStepBehaviorWME);
                        break;
                    }
                    case 5: {
                        newStepWME = new SucceedStepWME((SucceedStep)newStep, (BehaviorWME)this.multiStepBehaviorWME);
                    }
                }
                this.multiStepBehaviorWME.addChild(newStepWME, newStep);
                BehavingEntity.getBehavingEntity().addWME(newStepWME);
            } else {
                Step childToRemove = (Step)evt.getOldValue();
                StepWME childToRemoveWME = (StepWME)MultiStepBehaviorWME.this.stepToWMETable.get(childToRemove);
                assert (childToRemoveWME != null);
                this.multiStepBehaviorWME.removeChild(childToRemoveWME, childToRemove);
                BehavingEntity.getBehavingEntity().deleteWME(childToRemoveWME);
                childToRemoveWME.delete();
            }
        }
    }
}

